/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.vil.expressions.translation;

import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Compound;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Import;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.LanguageUnit;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Parameter;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ParameterList;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.TypeDef;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VariableDeclaration;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionSpec;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.VersionStmt;
import de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator;
import de.uni_hildesheim.sse.vil.expressions.translation.Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.common.ICompoundReceiver;
import net.ssehub.easy.instantiation.core.model.common.IResolvableOperation;
import net.ssehub.easy.instantiation.core.model.common.ITypedefReceiver;
import net.ssehub.easy.instantiation.core.model.common.IVariableDeclarationReceiver;
import net.ssehub.easy.instantiation.core.model.common.Imports;
import net.ssehub.easy.instantiation.core.model.common.ListVariableDeclarationReceiver;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.Resolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.CompoundTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeResolver;
import net.ssehub.easy.varModel.model.Project;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class ModelTranslator<M extends IModel, I extends net.ssehub.easy.instantiation.core.model.common.VariableDeclaration, R extends Resolver<I>, S extends ExpressionStatement, E extends ExpressionTranslator<I, R, S>>
extends net.ssehub.easy.dslCore.translation.ModelTranslator<E> {
    private R resolver;

    public ModelTranslator(E expressionTranslator, R resolver) {
        super(expressionTranslator);
        this.resolver = resolver;
    }

    protected R getResolver() {
        return this.resolver;
    }

    protected Imports<M> processImports(EList<Import> imports) throws TranslatorException {
        Imports result;
        if (imports != null) {
            HashSet<Object> known = new HashSet<Object>();
            ArrayList<ModelImport> tmp = new ArrayList<ModelImport>();
            for (Import imp : imports) {
                Object name = imp.getName();
                if (imp.getWildcard() != null) {
                    name = (String)name + "*";
                }
                if (!known.contains(name)) {
                    boolean isInsert = imp.getInsert() != null;
                    this.warnVersionRestrictions(imp.getVersionSpec());
                    tmp.add(new ModelImport((String)name, false, ((ExpressionTranslator)this.getExpressionTranslator()).processRestriction((String)name, imp.getVersionSpec(), this.resolver), isInsert));
                    known.add(name);
                    continue;
                }
                throw new TranslatorException((String)name + " is imported multiple times", (EObject)imp, (EStructuralFeature)ExpressionDslPackage.Literals.IMPORT__NAME, 20209);
            }
            result = new Imports(tmp);
        } else {
            result = null;
        }
        return result;
    }

    protected ModelImport<M> getExtensionImport(String name, Imports<M> imports, EObject cause, EStructuralFeature causingFeature) throws TranslatorException {
        ModelImport result = null;
        if (name != null && (result = imports.getImport(name)) == null) {
            throw new TranslatorException(name + " is not imported", cause, causingFeature, 20209);
        }
        return result;
    }

    protected void processTypedefContents(List<EObject> elts, ITypedefReceiver receiver) {
        List defs = ModelTranslator.select(elts, TypeDef.class);
        this.processTypedefs(defs, receiver);
    }

    protected void processCompoundContents(List<EObject> elts, ICompoundReceiver receiver) {
        List defs = ModelTranslator.select(elts, Compound.class);
        this.processCompounds(defs, receiver);
    }

    protected void processTypedefs(List<TypeDef> defs, ITypedefReceiver receiver) {
        int count;
        do {
            count = defs.size();
            this.processTypedefs(defs, receiver, false);
        } while (count != defs.size() && count > 0);
        if (defs.size() > 0) {
            this.processTypedefs(defs, receiver, true);
        }
    }

    protected void processCompounds(List<Compound> cmps, ICompoundReceiver receiver) {
        int count;
        do {
            count = cmps.size();
            this.processCompounds(cmps, receiver, false);
        } while (count != cmps.size() && count > 0);
        if (cmps.size() > 0) {
            this.processCompounds(cmps, receiver, true);
        }
    }

    private void processTypedefs(List<TypeDef> defs, ITypedefReceiver receiver, boolean force) {
        Iterator<TypeDef> iter = defs.iterator();
        while (iter.hasNext()) {
            TypeDef def = iter.next();
            try {
                String name = def.getName();
                TypeDescriptor<?> type = ((ExpressionTranslator)this.getExpressionTranslator()).processType(def.getType(), this.resolver);
                if (!this.resolver.getTypeRegistry().addTypeAlias(name, type)) {
                    this.error("Type name '" + name + "' already exists", def, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE_DEF__NAME, 20210);
                }
                Typedef typedef = this.createTypedef(name, type);
                receiver.addTypedef(typedef);
                iter.remove();
            }
            catch (VilException e) {
                if (!force) continue;
                this.error(e.getMessage(), def, (EStructuralFeature)ExpressionDslPackage.Literals.TYPE_DEF__NAME, e.getId());
            }
            catch (TranslatorException e) {
                if (!force) continue;
                this.error(e);
            }
        }
    }

    private void processCompounds(List<Compound> cmps, ICompoundReceiver receiver, boolean force) {
        Iterator<Compound> iter = cmps.iterator();
        TypeRegistry registry = this.resolver.getTypeRegistry();
        while (iter.hasNext()) {
            Compound cmp = iter.next();
            try {
                CompoundTypeDescriptor refines = null;
                if (cmp.getSuper() != null) {
                    TypeDescriptor tmp = registry.getType(cmp.getSuper(), false);
                    if (tmp == null) {
                        this.error("Parent compound '" + cmp.getSuper() + "' does not exists", cmp, (EStructuralFeature)ExpressionDslPackage.Literals.COMPOUND__SUPER, 20200);
                    } else if (tmp instanceof CompoundTypeDescriptor) {
                        refines = (CompoundTypeDescriptor)tmp;
                    } else {
                        this.error(cmp.getSuper() + "' is not a compound", cmp, (EStructuralFeature)ExpressionDslPackage.Literals.COMPOUND__SUPER, 20203);
                    }
                }
                CompoundTypeDescriptor cType = new CompoundTypeDescriptor(cmp.getName(), cmp.getAbstract() != null, refines, registry);
                List vars = ModelTranslator.copy(cmp.getVars());
                if (vars != null) {
                    int s;
                    ListVariableDeclarationReceiver recv = new ListVariableDeclarationReceiver(cmp.getVars().size());
                    this.processVariableDeclarations(vars, (IVariableDeclarationReceiver<I>)recv, false);
                    HashSet<String> known = new HashSet<String>();
                    CompoundTypeDescriptor.SlotDescriptor[] slots = new CompoundTypeDescriptor.SlotDescriptor[recv.getVariableCount()];
                    CompoundTypeDescriptor cIter = refines;
                    while (cIter != null) {
                        s = 0;
                        while (s < cIter.getSlotCount()) {
                            known.add(cIter.getSlot(s).getName());
                            ++s;
                        }
                        cIter = cIter.getRefines();
                    }
                    s = 0;
                    while (s < slots.length) {
                        net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var = (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)recv.getVariable(s);
                        String varName = var.getName();
                        if (known.contains(varName)) {
                            this.error("Slot '" + varName + "' is already declared", (EObject)vars.get(s), (EStructuralFeature)ExpressionDslPackage.Literals.VARIABLE_DECLARATION__NAME, 20205);
                        } else {
                            known.add(varName);
                        }
                        slots[s] = new CompoundTypeDescriptor.SlotDescriptor(cType, var);
                        ++s;
                    }
                    cType.setFields(slots);
                }
                receiver.addCompound(this.createCompound(cType));
                if (!registry.registerCompoundType(cType)) {
                    this.error("Compound '" + cType.getName() + "' is already declared", cmp, (EStructuralFeature)ExpressionDslPackage.Literals.COMPOUND__NAME, 20205);
                }
                iter.remove();
            }
            catch (VilException e) {
                if (!force) continue;
                this.error(e.getMessage(), cmp, (EStructuralFeature)ExpressionDslPackage.Literals.COMPOUND__NAME, e.getId());
            }
        }
    }

    protected abstract Typedef createTypedef(String var1, TypeDescriptor<?> var2) throws VilException;

    protected abstract net.ssehub.easy.instantiation.core.model.common.Compound createCompound(CompoundTypeDescriptor var1) throws VilException;

    protected void processVariableDeclarations(List<VariableDeclaration> decls, IVariableDeclarationReceiver<I> receiver) {
        this.processVariableDeclarations(decls, receiver, true);
    }

    protected void processVariableDeclarations(List<VariableDeclaration> decls, IVariableDeclarationReceiver<I> receiver, boolean addToResolver) {
        int count;
        do {
            count = decls.size();
            this.processVariableDeclarations(decls, receiver, false, addToResolver);
        } while (count != decls.size() && count > 0);
        if (decls.size() > 0) {
            this.processVariableDeclarations(decls, receiver, true, addToResolver);
        }
    }

    private void processVariableDeclarations(List<VariableDeclaration> decls, IVariableDeclarationReceiver<I> receiver, boolean force, boolean addToResolver) {
        Iterator<VariableDeclaration> iter = decls.iterator();
        while (iter.hasNext()) {
            VariableDeclaration decl = iter.next();
            try {
                Object varDecl = ((ExpressionTranslator)this.getExpressionTranslator()).processVariableDeclaration(decl, this.resolver);
                receiver.addVariableDeclaration(varDecl);
                if (addToResolver) {
                    this.resolver.add(varDecl);
                }
                iter.remove();
            }
            catch (TranslatorException e) {
                if (!force) continue;
                this.error(e);
            }
        }
    }

    protected Advice[] processAdvices(EList<de.uni_hildesheim.sse.vil.expressions.expressionDsl.Advice> advices, URI modelURI) {
        Advice[] result = null;
        if (advices != null) {
            result = new Advice[advices.size()];
            int a = 0;
            while (a < advices.size()) {
                de.uni_hildesheim.sse.vil.expressions.expressionDsl.Advice adv = (de.uni_hildesheim.sse.vil.expressions.expressionDsl.Advice)advices.get(a);
                String name = Utils.getQualifiedNameString(adv.getName());
                try {
                    IVersionRestriction restrictions = ((ExpressionTranslator)this.getExpressionTranslator()).processRestriction(name, adv.getVersionSpec(), this.resolver);
                    StringBuilder warning = new StringBuilder();
                    result[a] = Advice.create((String)name, (URI)modelURI, (IVersionRestriction)restrictions, (StringBuilder)warning);
                    this.buildLocalTypeRegistry(result[a]);
                    if (warning.length() > 0) {
                        this.warning(warning.toString(), adv, (EStructuralFeature)ExpressionDslPackage.Literals.ADVICE__NAME, 20209);
                    }
                }
                catch (TranslatorException e) {
                    this.error(e);
                }
                ++a;
            }
        }
        return result;
    }

    private void buildLocalTypeRegistry(Advice advice) {
        Project varModel = advice.getResolved();
        if (varModel != null) {
            TypeRegistry registry = this.resolver.getTypeRegistry();
            registry.addTypeResolver((ITypeResolver)new IvmlTypeResolver(varModel, registry));
        }
    }

    protected void warnVersionRestrictions(VersionSpec spec) {
        ((ExpressionTranslator)this.getExpressionTranslator()).warnVersionRestrictions(spec);
    }

    protected I[] resolveParameters(ParameterList pList, EObject cause, EStructuralFeature paramListFeature, R resolver) throws TranslatorException {
        net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[] result = pList != null ? this.resolveParameters((EList)pList.getParam(), cause, paramListFeature, (Resolver)resolver) : null;
        return result;
    }

    protected I[] resolveParameters(EList<Parameter> parameters, EObject cause, EStructuralFeature paramListFeature, R resolver) throws TranslatorException {
        net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[] result;
        if (parameters != null) {
            ArrayList tmp = new ArrayList();
            int firstDefaultParam = -1;
            int lastNonDefaultParam = -1;
            int p = 0;
            while (p < parameters.size()) {
                Parameter par = (Parameter)parameters.get(p);
                TypeDescriptor<?> type = ((ExpressionTranslator)this.getExpressionTranslator()).processType(par.getType(), resolver);
                if (type != null) {
                    int t = 0;
                    while (t < tmp.size()) {
                        if (((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)tmp.get(t)).getName().equals(par.getName())) {
                            this.error("duplicate parameter name '" + par.getName() + "'", par, (EStructuralFeature)ExpressionDslPackage.Literals.PARAMETER__NAME, 20210);
                        }
                        ++t;
                    }
                    Expression dflt = null;
                    if (par.getDflt() != null) {
                        dflt = ((ExpressionTranslator)this.getExpressionTranslator()).processAssignment(par, type, par.getDflt(), resolver);
                    }
                    tmp.add(((ExpressionTranslator)this.getExpressionTranslator()).createVariableDeclaration(par.getName(), type, false, dflt, resolver));
                    if (dflt != null) {
                        if (firstDefaultParam < 0) {
                            firstDefaultParam = p;
                        }
                    } else {
                        lastNonDefaultParam = p;
                    }
                }
                ++p;
            }
            if (firstDefaultParam >= 0 && lastNonDefaultParam > firstDefaultParam) {
                this.error("Default parameters must be given after non-default parameters", cause, paramListFeature, 20203);
            }
            result = this.createArray(tmp.size());
            tmp.toArray(result);
        } else {
            result = null;
        }
        return result;
    }

    protected abstract I[] createArray(int var1);

    public static Version convert(VersionStmt versionStatement) {
        Version version = null;
        String vString = versionStatement == null ? null : versionStatement.getVersion();
        if (vString == null) {
            version = null;
        } else {
            try {
                version = new Version(vString);
            }
            catch (VersionFormatException versionFormatException) {
                // empty catch block
            }
        }
        return version;
    }

    protected abstract ModelManagement<M> getManagementInstance();

    protected void resolveImports(LanguageUnit input, EStructuralFeature inputFeature, M model, URI uri, List<? extends LanguageUnit> inProgress, ImportResolver<M> impResolver) {
        ArrayList infoInProgress = new ArrayList();
        AvailableModels available = this.getManagementInstance().availableModels();
        int p = 0;
        while (p < inProgress.size()) {
            LanguageUnit pr = inProgress.get(p);
            VersionStmt versionStatement = pr.getVersion();
            String vString = versionStatement == null ? null : versionStatement.getVersion();
            try {
                List info = available.getModelInfo(pr.getName(), vString);
                if (info != null) {
                    infoInProgress.addAll(info);
                }
            }
            catch (VersionFormatException e) {
                this.error(e.getMessage(), input, inputFeature, 20209);
            }
            ++p;
        }
        List<IMessage> resolutionMessages = this.getManagementInstance().resolveImports(model, uri, infoInProgress, impResolver);
        if (resolutionMessages.size() > 0) {
            resolutionMessages = this.postResolveImports(model, uri, resolutionMessages);
        }
        int i = 0;
        while (i < resolutionMessages.size()) {
            IMessage msg = resolutionMessages.get(i);
            switch (msg.getStatus()) {
                case ERROR: {
                    this.error(msg.getDescription(), input, inputFeature, 20209);
                    break;
                }
                case WARNING: {
                    this.warning(msg.getDescription(), input, inputFeature, 20209);
                    break;
                }
            }
            ++i;
        }
        this.addImportedVariablesToResolver(model, false, new HashSet());
    }

    private void addImportedVariablesToResolver(M model, boolean addModel, Set<M> done) {
        if (!done.contains(model)) {
            if (addModel) {
                this.addVisibleDeclarationsToResolver(model, this.resolver);
            }
            done.add(model);
            int i = 0;
            while (i < model.getImportsCount()) {
                IModel resolved = model.getImport(i).getResolved();
                if (resolved != null) {
                    this.addImportedVariablesToResolver(resolved, true, done);
                }
                ++i;
            }
        }
    }

    protected abstract void addVisibleDeclarationsToResolver(M var1, R var2);

    protected List<IMessage> postResolveImports(M model, URI uri, List<IMessage> resolutionMessages) {
        return resolutionMessages;
    }

    protected <O extends IResolvableOperation<I>> void checkOperationAnnotations(O op, EObject cause, EStructuralFeature causingFeature) {
        boolean dispCase = op.hasAnnotation("dispatchCase");
        boolean override = op.hasAnnotation("override");
        if (dispCase || override) {
            CallArgument[] args = new CallArgument[op.getParameterCount()];
            int p = 0;
            while (p < args.length) {
                args[p] = new CallArgument(((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)op.getParameter(p)).getType());
                ++p;
            }
            int unnamedArgsCount = CallArgument.countUnnamedArguments((CallArgument[])args);
            try {
                List cand = AbstractCallExpression.assignableCandidates((IMetaType)op.getDeclaringType(), (String)op.getName(), (CallArgument[])args, (int)unnamedArgsCount, (boolean)false, (boolean)true);
                int dispatchBasisCount = 0;
                int overrideCount = 0;
                int o = 0;
                while (o < cand.size()) {
                    IMetaOperation c = (IMetaOperation)cand.get(o);
                    if (c instanceof IResolvableOperation) {
                        IResolvableOperation tmp = (IResolvableOperation)c;
                        overrideCount += tmp.hasAnnotation("override") ? 1 : 0;
                        dispatchBasisCount += tmp.hasAnnotation("dispatchBasis") ? 1 : 0;
                    }
                    ++o;
                }
                if (dispCase && cand.size() > 0) {
                    if (dispatchBasisCount > 1) {
                        this.warning("Multiple matching dispatch basis operations found for " + op.getSignature(), cause, causingFeature, 20203);
                    } else if (dispatchBasisCount == 0) {
                        this.warning("No matching dispatch basis operations found for " + op.getSignature(), cause, causingFeature, 20203);
                    }
                }
                if (override) {
                    boolean ok;
                    boolean bl = ok = cand.size() > 0 && overrideCount < cand.size();
                    if (!ok) {
                        this.warning("No matching non-overriding operation found for " + op.getSignature(), cause, causingFeature, 20203);
                    }
                }
            }
            catch (VilException e) {
                this.warning(e.getMessage(), cause, causingFeature, e.getId());
            }
        }
    }
}

