/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.yaml;

import java.io.File;
import java.io.IOException;
import net.ssehub.easy.instantiation.yaml.YamlDeserializer;
import net.ssehub.easy.instantiation.yaml.YamlEditor;
import net.ssehub.easy.instantiation.yaml.YamlSerializer;

public class Main {
    private static final String CONF_FILE = "storm.yaml";

    public static void main(String[] args) {
        if (args.length == 2) {
            String key = args[0];
            String value = args[1];
            String path = "/usr/local/storm/conf/storm.yaml";
            File file = new File(path);
            try {
                YamlDeserializer.getInstance().createBackup(file);
                YamlEditor.getInstance().refreshData(file);
                String oldValue = (String)YamlEditor.getInstance().getEntry(key, file);
                String newValue = oldValue + " " + value;
                YamlEditor.getInstance().updateEntry(file, key, newValue);
                String oldString = YamlDeserializer.getInstance().getOriginalFile();
                String newString = YamlSerializer.getInstance().merge(YamlEditor.getInstance().getData(), oldString);
                YamlSerializer.getInstance().save(newString, file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Parameters not valid! Please make sure you call this programm with the following parameters: key value");
        }
    }
}

