/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.ProjectSettings;
import net.ssehub.easy.instantiation.core.model.vilTypes.ISettingsInitializer;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class JavaSettingsInitializer
implements ISettingsInitializer {
    private static final String JAVA_CLASSPATH = System.getProperty("java.class.path");

    public void initialize(File base, Map<ProjectSettings, Object> settings) {
    }

    public static String[] determineClasspath(Object classpath) {
        String[] result = null;
        if (classpath != null) {
            if (classpath instanceof String) {
                result = JavaSettingsInitializer.normalizePath(new String[]{String.valueOf(classpath)});
            } else if (classpath instanceof Set) {
                Set classpathSet = (Set)classpath;
                HashSet<String> tmpClasspath = new HashSet<String>();
                int parameterCount = classpathSet.getGenericParameterCount();
                TypeDescriptor typeDescriptorParameter = classpathSet.getGenericParameterType(parameterCount - 1);
                Iterator iterator = classpathSet.iterator();
                while (iterator.hasNext()) {
                    if (TypeRegistry.stringType().isSame(typeDescriptorParameter)) {
                        String string = (String)iterator.next();
                        File file = new File(string);
                        if (!file.exists()) continue;
                        JavaSettingsInitializer.add(tmpClasspath, JavaSettingsInitializer.normalizePath(file.getAbsolutePath()));
                        continue;
                    }
                    if (typeDescriptorParameter.isSame(TypeRegistry.DEFAULT.findType(Path.class))) {
                        Path path = (Path)iterator.next();
                        if (!path.exists()) continue;
                        JavaSettingsInitializer.add(tmpClasspath, JavaSettingsInitializer.normalizePath(path.getAbsolutePath().getAbsolutePath()));
                        continue;
                    }
                    iterator.next();
                }
                String[] tmpResult = new String[tmpClasspath.size()];
                result = tmpClasspath.toArray(tmpResult);
            }
        } else {
            String[] systemClasspath;
            result = systemClasspath = JavaSettingsInitializer.normalizePath(JAVA_CLASSPATH.split(File.pathSeparator));
        }
        return result;
    }

    private static String[] normalizePath(String[] allPaths) {
        ArrayList<String> tmp = new ArrayList<String>();
        int i = 0;
        while (i < allPaths.length) {
            String normalized = JavaSettingsInitializer.normalizePath(allPaths[i]);
            if (normalized != null) {
                tmp.add(normalized);
            }
            ++i;
        }
        String[] result = new String[tmp.size()];
        return tmp.toArray(result);
    }

    public static String[] filterPath(String[] allPaths) {
        ArrayList<String> tmp = new ArrayList<String>();
        int i = 0;
        while (i < allPaths.length) {
            String path = JavaSettingsInitializer.resolve(allPaths[i]);
            if (path != null) {
                tmp.add(allPaths[i]);
            }
            ++i;
        }
        String[] result = new String[tmp.size()];
        return tmp.toArray(result);
    }

    private static void add(HashSet<String> elts, String elt) {
        if (elt != null) {
            elts.add(elt);
        }
    }

    private static String normalizePath(String path) {
        String result = JavaSettingsInitializer.resolve(path);
        if (result != null) {
            result = result.replace("\\", "/");
        }
        return result;
    }

    private static String resolve(String path) {
        File f;
        String resolved = null;
        if (path != null && (f = new File(path)).exists()) {
            resolved = path;
        }
        return resolved;
    }
}

