/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.artifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.java.artifacts.IJavaParent;
import net.ssehub.easy.instantiation.java.artifacts.JavaAnnotation;
import net.ssehub.easy.instantiation.java.artifacts.JavaParentFragmentArtifact;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class JavaAttribute
extends JavaParentFragmentArtifact {
    private static EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(JavaAttribute.class, "net.ssehub.easy.instantiation.java");
    private FieldDeclaration fieldDeclaration;
    private String attributeName;

    public JavaAttribute(FieldDeclaration node, String name, IJavaParent parent) {
        super(parent);
        this.fieldDeclaration = node;
        this.attributeName = name;
    }

    @Override
    public void delete() throws VilException {
        this.fieldDeclaration.delete();
        super.delete();
        this.store();
        this.notifyChanged();
    }

    public String getName() throws VilException {
        return this.attributeName;
    }

    public void rename(String name) throws VilException {
        List list = this.fieldDeclaration.fragments();
        for (VariableDeclarationFragment variableDeclarationFragment : list) {
            variableDeclarationFragment.setName(this.fieldDeclaration.getAST().newSimpleName(name));
        }
        this.notifyChanged();
    }

    public Text getText() throws VilException {
        return Text.CONSTANT_EMPTY;
    }

    public Binary getBinary() throws VilException {
        return Binary.CONSTANT_EMPTY;
    }

    public void accept(IArtifactVisitor visitor) {
        visitor.visitFragmentArtifact((FragmentArtifact)this);
    }

    @ReturnGenerics(value={JavaAnnotation.class})
    public Set<JavaAnnotation> annotations() {
        return this.annotations(this.fieldDeclaration.modifiers());
    }

    public void setValue(Object value) {
        List list = this.fieldDeclaration.fragments();
        for (VariableDeclarationFragment fragment : list) {
            if (value != null) {
                if (value instanceof DecisionVariable) {
                    value = ((DecisionVariable)value).getValue();
                }
                int type = fragment.getInitializer().getNodeType();
                StringLiteral expression = null;
                switch (type) {
                    case 34: {
                        expression = this.fieldDeclaration.getAST().newNumberLiteral(String.valueOf(value));
                        break;
                    }
                    case 45: {
                        expression = this.fieldDeclaration.getAST().newStringLiteral();
                        expression.setLiteralValue(String.valueOf(value));
                        break;
                    }
                    case 9: {
                        expression = this.fieldDeclaration.getAST().newBooleanLiteral(Boolean.valueOf(value.toString()).booleanValue());
                        break;
                    }
                    case 13: {
                        expression = this.fieldDeclaration.getAST().newCharacterLiteral();
                        expression.setLiteralValue(String.valueOf(value));
                        break;
                    }
                    case 33: {
                        expression = this.fieldDeclaration.getAST().newNullLiteral();
                        break;
                    }
                    case 57: {
                        expression = this.fieldDeclaration.getAST().newTypeLiteral();
                        break;
                    }
                    default: {
                        logger.error("Type '" + String.valueOf(ASTNode.nodeClassForType((int)type)) + "' not supported yet...");
                    }
                }
                if (expression == null) continue;
                fragment.setInitializer((Expression)expression);
                this.notifyChanged();
                continue;
            }
            fragment.setInitializer(null);
            this.notifyChanged();
        }
    }

    public void makeConstant() {
        List modifierList = this.fieldDeclaration.modifiers();
        logger.debug("Trying to make attribute '" + this.attributeName + "' constant...");
        if (this.testIfModifierExists(Modifier.ModifierKeyword.STATIC_KEYWORD, modifierList)) {
            logger.debug("modifier 'static' already exists");
        } else {
            modifierList.add(this.fieldDeclaration.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
            logger.debug("Added 'static' modifier to '" + this.attributeName + "'");
        }
        if (this.testIfModifierExists(Modifier.ModifierKeyword.FINAL_KEYWORD, modifierList)) {
            logger.debug("modifier 'final' already exists...");
        } else {
            modifierList.add(this.fieldDeclaration.getAST().newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
            logger.debug("Added 'final' modifier to '" + this.attributeName + "'");
        }
        this.notifyChanged();
    }

    private boolean testIfModifierExists(Modifier.ModifierKeyword keyword, List<IExtendedModifier> modifierList) {
        boolean result = false;
        for (IExtendedModifier object : modifierList) {
            if (!object.toString().equals(keyword.toString())) continue;
            result = true;
            break;
        }
        return result;
    }

    public void makeVariable() {
        List modifierList = this.fieldDeclaration.modifiers();
        ArrayList<IExtendedModifier> removeList = new ArrayList<IExtendedModifier>();
        logger.debug("Trying to make attribute '" + this.attributeName + "' variable...");
        for (Object modifier : modifierList) {
            if (!modifier.toString().equals(Modifier.ModifierKeyword.FINAL_KEYWORD.toString()) && !modifier.toString().equals(Modifier.ModifierKeyword.STATIC_KEYWORD.toString())) continue;
            logger.debug("'" + String.valueOf(modifier) + "' flagged for deletion...");
            removeList.add((IExtendedModifier)modifier);
        }
        logger.debug("Remove modifiers...");
        modifierList.removeAll(removeList);
        this.notifyChanged();
    }

    @Invisible
    FieldDeclaration getFieldDeclaration() {
        return this.fieldDeclaration;
    }

    @Invisible
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "attribute '" + this.getNameSafe() + "'";
    }

    @Override
    @Invisible
    public ArtifactModel getArtifactModel() {
        return this.getParent().getArtifactModel();
    }
}

