/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.artifacts;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.JavaUtilities;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.ProjectSettings;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.java.JavaSettings;
import net.ssehub.easy.instantiation.java.JavaSettingsInitializer;
import net.ssehub.easy.instantiation.java.artifacts.DefaultJavaFileArtifactCreator;
import net.ssehub.easy.instantiation.java.artifacts.IJavaParent;
import net.ssehub.easy.instantiation.java.artifacts.JavaAnnotation;
import net.ssehub.easy.instantiation.java.artifacts.JavaAttribute;
import net.ssehub.easy.instantiation.java.artifacts.JavaClass;
import net.ssehub.easy.instantiation.java.artifacts.JavaImport;
import net.ssehub.easy.instantiation.java.artifacts.JavaMethod;
import net.ssehub.easy.instantiation.java.artifacts.JavaPackage;
import net.ssehub.easy.instantiation.java.artifacts.JavaQualifiedName;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

@ArtifactCreator(value=DefaultJavaFileArtifactCreator.class)
public class JavaFileArtifact
extends FileArtifact
implements IJavaParent {
    private static EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(JavaFileArtifact.class, "net.ssehub.easy.instantiation.java");
    private File file;
    private CompilationUnit unitNode;
    private List<JavaClass> classList;
    private boolean changed = false;
    private boolean enableContentStore = true;

    JavaFileArtifact(File file, ArtifactModel model) {
        super(file, model);
        this.file = file;
    }

    @Invisible
    public String annotationValue(String annotation, String field) {
        return "";
    }

    public boolean hasAnnotation(String annotation, String field, String value) {
        Set<JavaClass> classes = this.classes();
        boolean hasAnnotation = false;
        if (field == null || field.length() == 0) {
            field = "value";
        }
        block0: for (JavaClass javaClass : classes) {
            if (hasAnnotation = this.checkAnnotation(annotation, field, value, hasAnnotation, javaClass.annotations())) break;
            Set<JavaAttribute> attributes = javaClass.attributes();
            for (JavaAttribute javaAttribute : attributes) {
                Set<JavaAnnotation> attributeAnnotations = javaAttribute.annotations();
                if (hasAnnotation = this.checkAnnotation(annotation, field, value, hasAnnotation, attributeAnnotations)) break;
            }
            Set<JavaMethod> methods = javaClass.methods();
            for (JavaMethod javaMethod : methods) {
                Set<JavaAnnotation> methodAnnotation = javaMethod.annotations();
                if (hasAnnotation = this.checkAnnotation(annotation, field, value, hasAnnotation, methodAnnotation)) continue block0;
            }
        }
        return hasAnnotation;
    }

    private boolean checkAnnotation(String annotation, String field, String value, boolean hasAnnotation, Set<JavaAnnotation> annotations) {
        String simpleName = JavaAnnotation.toSimpleName(annotation);
        for (JavaAnnotation javaAnnotation : annotations) {
            try {
                if (!javaAnnotation.getQualifiedName().equals(annotation) && !javaAnnotation.getName().equals(simpleName) || !javaAnnotation.getAnnotationValue(field).equals(value)) continue;
                hasAnnotation = true;
                break;
            }
            catch (VilException e) {
                logger.exception((Exception)((Object)e));
            }
        }
        return hasAnnotation;
    }

    public void artifactChanged(Object cause) throws VilException {
        super.artifactChanged(cause);
        if (cause instanceof Text && this.getText() != null) {
            this.initialize(this.getText().getText().toCharArray());
        } else {
            this.initialize();
        }
        this.changed = false;
    }

    @Override
    public void store() throws VilException {
        super.store();
        if (this.changed) {
            if (!this.file.exists()) {
                try {
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    logger.exception((Exception)e);
                }
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.file));
                    String code = this.unitNode.toString();
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator", "insert");
                    options.put("org.eclipse.jdt.core.formatter.insert_space_after_assignment_operator", "insert");
                    options.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
                    options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
                    options.put("org.eclipse.jdt.core.compiler.source", "1.7");
                    options.put("org.eclipse.jdt.core.formatter.tabulation.char", "space");
                    CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(options);
                    TextEdit textEdit = codeFormatter.format(8, code, 0, code.length(), 0, System.getProperty("line.separator"));
                    Document doc = new Document(code);
                    try {
                        if (textEdit != null) {
                            textEdit.apply((IDocument)doc);
                        }
                    }
                    catch (MalformedTreeException e) {
                        throw new VilException((Throwable)e, 20015);
                    }
                    catch (BadLocationException e) {
                        throw new VilException((Throwable)e, 20015);
                    }
                    try {
                        writer.write(doc.get());
                    }
                    catch (IOException e) {
                        throw new VilException((Throwable)e, 20015);
                    }
                }
                catch (IOException e) {
                    throw new VilException((Throwable)e, 50001);
                }
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    throw new VilException((Throwable)e, 50001);
                }
            }
            this.changed = false;
        }
    }

    @ReturnGenerics(value={JavaClass.class})
    public Set<JavaClass> classes() {
        if (this.classList == null) {
            this.initialize();
        }
        return new ArraySet((Object[])this.classList.toArray(new JavaClass[this.classList.size()]), JavaClass.class);
    }

    public JavaClass getClassByName(String name) {
        JavaClass result = null;
        if (this.classList == null) {
            this.initialize();
        }
        int c = 0;
        while (result == null && c < this.classList.size()) {
            JavaClass cls = this.classList.get(c);
            try {
                if (cls.getName().equals(name)) {
                    result = cls;
                }
            }
            catch (VilException e) {
                logger.exception((Exception)((Object)e));
            }
            ++c;
        }
        return result;
    }

    public JavaClass getDefaultClass() {
        JavaClass result;
        try {
            String name = this.getName();
            if (name.endsWith(".java")) {
                name = name.substring(0, name.length() - 5);
            }
            result = this.getClassByName(name);
        }
        catch (VilException e) {
            logger.exception((Exception)((Object)e));
            result = null;
        }
        return result;
    }

    private void initialize() {
        this.initialize(JavaFileArtifact.readFileToString(this.file).toCharArray());
    }

    private void initialize(char[] data) {
        String[] sourcePath;
        this.classList = new ArrayList<JavaClass>();
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setSource(data);
        parser.setKind(8);
        parser.setBindingsRecovery(true);
        parser.setResolveBindings(true);
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.7");
        parser.setCompilerOptions((Map)options);
        String unitName = FilenameUtils.getBaseName((String)this.file.getName());
        parser.setUnitName(unitName);
        String[] classpath = JavaSettingsInitializer.filterPath(JavaUtilities.JRE_CLASS_PATH);
        boolean isClasspathFromScript = false;
        if (this.getArtifactModel() != null) {
            Object classPathFromScript = this.getArtifactModel().getSettings((ProjectSettings)JavaSettings.CLASSPATH);
            if (classPathFromScript != null) {
                isClasspathFromScript = true;
                sourcePath = JavaSettingsInitializer.determineClasspath(classPathFromScript);
            } else {
                sourcePath = JavaSettingsInitializer.determineClasspath(null);
            }
        } else {
            sourcePath = JavaSettingsInitializer.determineClasspath(null);
        }
        String[] sources = sourcePath;
        ArrayList<String> tmpClasspath = new ArrayList<String>(Arrays.asList(classpath));
        ArrayList<String> tmpSources = new ArrayList<String>(Arrays.asList(sources));
        ArrayList<String> sourceFiles = new ArrayList<String>();
        ArrayList<String> jarFiles = new ArrayList<String>();
        for (String string : tmpSources) {
            if (!string.endsWith(".jar")) {
                sourceFiles.add(string);
                continue;
            }
            if (!string.endsWith(".jar")) continue;
            jarFiles.add(string);
        }
        tmpSources = sourceFiles;
        tmpClasspath.addAll(jarFiles);
        String[] cp = tmpClasspath.toArray(new String[tmpClasspath.size()]);
        String[] src = tmpSources.toArray(new String[tmpSources.size()]);
        parser.setEnvironment(cp, src, null, true);
        this.unitNode = (CompilationUnit)parser.createAST(null);
        this.printWarnings(isClasspathFromScript);
        this.unitNode.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration typeDeclaration) {
                if (typeDeclaration.isPackageMemberTypeDeclaration()) {
                    JavaFileArtifact.this.classList.add(new JavaClass(typeDeclaration, JavaFileArtifact.this));
                }
                return true;
            }
        });
        this.unitNode.recordModifications();
    }

    private void printWarnings(boolean isClasspathFromScript) {
        IProblem[] problems;
        if (isClasspathFromScript && (problems = this.unitNode.getProblems()) != null && problems.length > 0) {
            logger.warn("Got " + problems.length + " problems compiling the source file: " + this.file.getAbsolutePath());
            IProblem[] iProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem problem = iProblemArray[n2];
                logger.warn(problem.getMessage());
                ++n2;
            }
        }
    }

    @Invisible
    public static String readFileToString(File filePath) {
        StringBuilder fileData = new StringBuilder(1000);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filePath));
            char[] buf = new char[10];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
        }
        catch (FileNotFoundException fnf) {
            logger.exception((Exception)fnf);
        }
        catch (IOException ioe) {
            logger.exception((Exception)ioe);
        }
        return fileData.toString();
    }

    @Override
    public void notifyChildChanged(FragmentArtifact child) {
        this.changed = true;
    }

    @Override
    public void deleteChild(FragmentArtifact child) throws VilException {
    }

    @ReturnGenerics(value={JavaImport.class})
    public Set<JavaImport> imports() {
        if (this.unitNode == null) {
            this.initialize();
        }
        ArrayList<JavaImport> imports = new ArrayList<JavaImport>();
        List unitNodeImports = this.unitNode.imports();
        for (ImportDeclaration importDeclaration : unitNodeImports) {
            JavaImport javaImport = new JavaImport(importDeclaration, this);
            imports.add(javaImport);
        }
        return new ArraySet((Object[])imports.toArray(new JavaImport[imports.size()]), JavaImport.class);
    }

    public JavaPackage javaPackage() {
        if (this.unitNode == null) {
            this.initialize();
        }
        JavaPackage javaPackage = new JavaPackage(this.unitNode.getPackage(), this);
        return javaPackage;
    }

    public Set<JavaQualifiedName> qualifiedNames() {
        if (this.classList == null) {
            this.initialize();
        }
        ArrayList<JavaQualifiedName> qualifiedNames = new ArrayList<JavaQualifiedName>();
        for (JavaClass javaClass : this.classList) {
            for (JavaQualifiedName javaQualifiedName : javaClass.qualifiedNames()) {
                qualifiedNames.add(javaQualifiedName);
            }
        }
        return new ArraySet((Object[])qualifiedNames.toArray(new JavaQualifiedName[qualifiedNames.size()]), JavaQualifiedName.class);
    }

    public void modifyNamespace(String oldName, String newName) {
        try {
            this.renameImports(oldName, newName);
            this.renameQualifiedNames(oldName, newName);
            this.renamePackages(oldName, newName);
            this.store();
        }
        catch (VilException e) {
            logger.exception((Exception)((Object)e));
        }
    }

    public void modifiyNamespace(Map<String, String> nameMapping) {
        try {
            this.renameImports(nameMapping);
            this.renameQualifiedNames(nameMapping);
            this.renamePackages(nameMapping);
            this.store();
        }
        catch (VilException e) {
            logger.exception((Exception)((Object)e));
        }
    }

    public void renamePackages(String oldName, String newName) throws VilException {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put(oldName, newName);
        this.renamePackages(tmp);
    }

    public void renamePackages(Map<String, String> nameMapping) throws VilException {
        JavaPackage javaPackage = this.javaPackage();
        String path = javaPackage.getName();
        for (Map.Entry<String, String> entry : nameMapping.entrySet()) {
            javaPackage.rename(path.replace(entry.getKey(), entry.getValue()));
        }
    }

    public void renameImports(String oldName, String newName) throws VilException {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put(oldName, newName);
        this.renameImports(tmp);
    }

    public void renameImports(Map<String, String> nameMapping) throws VilException {
        Set<JavaImport> imports = this.imports();
        for (Map.Entry<String, String> entry : nameMapping.entrySet()) {
            for (JavaImport javaImport : imports) {
                if (!javaImport.getName().contains(entry.getKey())) continue;
                javaImport.rename(javaImport.getName().replace(entry.getKey(), entry.getValue()));
            }
        }
    }

    public void renameQualifiedNames(String oldName, String newName) throws VilException {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put(oldName, newName);
        this.renameQualifiedNames(tmp);
    }

    public void renameQualifiedNames(Map<String, String> nameMapping) throws VilException {
        Set<JavaClass> classes = this.classes();
        for (JavaClass javaClass : classes) {
            Set<JavaQualifiedName> qualifiedNames = javaClass.qualifiedNames();
            for (Map.Entry<String, String> entry : nameMapping.entrySet()) {
                for (JavaQualifiedName javaQualifiedName : qualifiedNames) {
                    javaQualifiedName.rename(javaQualifiedName.getName().replace(entry.getKey(), entry.getValue()));
                }
            }
        }
    }

    @Invisible
    @Conversion
    public static JavaFileArtifact convert(IFileSystemArtifact val) {
        JavaFileArtifact convertedValue = null;
        if (val instanceof JavaFileArtifact) {
            convertedValue = (JavaFileArtifact)val;
        }
        return convertedValue;
    }

    @Invisible
    @Conversion
    public static JavaFileArtifact convert(String val) throws VilException {
        Path path = Path.convert((String)val);
        return JavaFileArtifact.convert(path);
    }

    @Invisible
    @Conversion
    public static JavaFileArtifact convert(Path path) throws VilException {
        return (JavaFileArtifact)ArtifactFactory.createArtifact(JavaFileArtifact.class, (Object)path.getAbsolutePath(), (ArtifactModel)path.getArtifactModel());
    }

    @Invisible
    public boolean enableContentStore() {
        return this.enableContentStore;
    }

    public void setEnableContentStore(boolean enableContentStore) {
        this.enableContentStore = enableContentStore;
    }
}

