/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.java.codeArtifacts.CodeParser;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAbstractVisibleElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAlternative;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnonymousClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeArrayInitializerExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAttribute;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeCastExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeConstructorCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeEnum;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeForLoop;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeJavadocComment;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeLambdaExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethod;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeNewArrayExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParameterSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParsedExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeSwitch;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTernaryExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTextExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTryBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibleElement;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.GuardedPattern;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NullPattern;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PatternInstanceofExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordPattern;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StringTemplateExpression;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.TypePattern;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

class AST2ArtifactVisitor
extends ASTVisitor {
    static final ProblemConsumer LOG_CONSUMER = p -> {
        if (p != null) {
            EASyLoggerFactory.INSTANCE.getLogger(JavaCodeArtifact.class, "net.ssehub.easy.instantiation.core").warn(p.getMessage());
        }
    };
    private Stack<JavaCodeBlock> blocks = new Stack();
    private Stack<JavaCodeClass> classes = new Stack();
    private JavaCodeClass cls;
    private JavaCodeEnum enumeration;
    private JavaCodeMethod method;
    private JavaCodeParsedExpression ex;
    private Map<Integer, Comment> comments;
    private char[] source;

    AST2ArtifactVisitor(ASTNode unit, char[] source) {
        this.source = source;
        CompilationUnit commentUnit = null;
        if (unit instanceof CompilationUnit) {
            commentUnit = (CompilationUnit)unit;
        } else {
            ASTNode uIter = unit.getParent();
            while (uIter != null) {
                if (uIter instanceof CompilationUnit) {
                    commentUnit = (CompilationUnit)uIter;
                }
                uIter = uIter.getParent();
            }
        }
        if (commentUnit != null) {
            this.comments = CodeParser.mapComments(commentUnit);
        }
        if (unit instanceof Block) {
            this.blocks.push(new JavaCodeBlock(null, false, false, false, false, false));
        }
    }

    static ProblemConsumer logConsumer() {
        return LOG_CONSUMER;
    }

    static ProblemConsumer vilExceptionConsumer() {
        return new ProblemConsumer(){
            private String messages = "";

            @Override
            public void accept(IProblem problem) throws VilException {
                if (problem == null) {
                    throw new VilException(this.messages, -1);
                }
                if (this.messages.length() > 0) {
                    this.messages = String.valueOf(this.messages) + "; ";
                }
                this.messages = String.valueOf(this.messages) + problem.getMessage();
            }
        };
    }

    public static AST2ArtifactVisitor parseCompilationUnit(String text, ProblemConsumer problems) throws VilException {
        return AST2ArtifactVisitor.parse(text, 8, problems);
    }

    public static AST2ArtifactVisitor parseExpression(String text, ProblemConsumer problems) throws VilException {
        return AST2ArtifactVisitor.parse(text, 1, problems);
    }

    public static AST2ArtifactVisitor parseStatements(String text, ProblemConsumer problems) throws VilException {
        return AST2ArtifactVisitor.parse(text, 2, problems);
    }

    private static AST2ArtifactVisitor parse(String text, int parserKind, ProblemConsumer problems) throws VilException {
        CompilationUnit unit;
        char[] source = text.toCharArray();
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setKind(parserKind);
        parser.setSource(source);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"21", (Map)options);
        parser.setCompilerOptions((Map)options);
        ASTNode node = parser.createAST(null);
        AST2ArtifactVisitor vis = new AST2ArtifactVisitor(node, source);
        node.accept((ASTVisitor)vis);
        if (node instanceof CompilationUnit && problems != null && (unit = (CompilationUnit)node).getProblems() != null) {
            int problemCount = 0;
            IProblem[] iProblemArray = unit.getProblems();
            int n = iProblemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProblem p = iProblemArray[n2];
                if (p.getID() != 4195409) {
                    problems.accept(p);
                    ++problemCount;
                }
                ++n2;
            }
            if (problemCount > 0) {
                problems.accept(null);
            }
        }
        return vis;
    }

    public JavaCodeClass getCls() {
        return this.cls;
    }

    public JavaCodeEnum getEnum() {
        return this.enumeration;
    }

    public JavaCodeMethod getMethod() {
        return this.method;
    }

    public JavaCodeBlock getBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.peek();
    }

    public JavaCodeParsedExpression getExpression() {
        return this.ex;
    }

    private JavaCodeClass getCurrentClass() {
        return this.classes.isEmpty() ? null : this.classes.peek();
    }

    public boolean visit(EmptyStatement node) {
        this.getBlock().add(";");
        return false;
    }

    public boolean visit(IfStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        JavaCodeAlternative a = this.getBlock().addIf(this.getExToString());
        this.blocks.push(a);
        node.getThenStatement().accept((ASTVisitor)this);
        this.blocks.pop();
        if (node.getElseStatement() != null) {
            this.blocks.push(a.addElse());
            node.getElseStatement().accept((ASTVisitor)this);
            this.blocks.pop();
        }
        return false;
    }

    public boolean visit(LineComment node) {
        int startPos;
        int pos = startPos = node.getStartPosition() + 2;
        while (pos < this.source.length && this.source[pos] != '\n' && this.source[pos] != '\r') {
            ++pos;
        }
        this.getBlock().addSLComment(new String(this.source, startPos, pos - startPos).trim());
        return false;
    }

    public boolean visit(Assignment node) {
        node.getLeftHandSide().accept((ASTVisitor)this);
        String lhs = this.getExToString();
        node.getRightHandSide().accept((ASTVisitor)this);
        if (this.getBlock() != null) {
            this.getBlock().addAssignment(lhs, node.getOperator().toString(), this.getEx());
        }
        return false;
    }

    public boolean visit(Block node) {
        CodeParser.visitCommentBefore((ASTNode)node, this.comments, this);
        boolean nestedBlock = node.getParent() instanceof Block;
        if (nestedBlock) {
            JavaCodeBlock b = new JavaCodeBlock(this.getBlock(), false, true).indentBefore(true);
            this.getBlock().addBlock(b);
            this.blocks.push(b);
        }
        CodeParser.apply(() -> node.statements(), Statement.class, s -> {
            CodeParser.visitCommentBefore((ASTNode)s, this.comments, this);
            s.accept((ASTVisitor)this);
            this.ex = null;
        });
        if (nestedBlock) {
            this.blocks.pop();
        }
        CodeParser.visitCommentAfter((ASTNode)node, this.comments, this);
        return false;
    }

    public boolean visit(DoStatement node) {
        this.blocks.push(this.getBlock().addDoLoop(node.getExpression().toString()));
        node.getBody().accept((ASTVisitor)this);
        this.blocks.pop();
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        SingleVariableDeclaration v = node.getParameter();
        node.getExpression().accept((ASTVisitor)this);
        this.blocks.push(this.getBlock().addForLoop(this.toString(v.getType(), false), v.getName().getIdentifier(), this.getExToString()));
        node.getBody().accept((ASTVisitor)this);
        this.blocks.pop();
        return false;
    }

    public boolean visit(BreakStatement node) {
        this.getBlock().addBreak();
        return false;
    }

    public boolean visit(ContinueStatement node) {
        this.getBlock().addContinue();
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.getBlock().add(this.getEx());
        return false;
    }

    private String toString(Type type, boolean elementType) {
        String result;
        if (type == null) {
            result = "";
        } else {
            result = type.toString();
            if (elementType && type instanceof ArrayType) {
                result = this.toString(((ArrayType)type).getElementType(), true);
            }
        }
        return result;
    }

    public boolean visit(ForStatement node) {
        node.getExpression();
        node.initializers();
        node.updaters();
        AtomicReference<String> vType = new AtomicReference<String>("");
        ArrayList names = new ArrayList();
        ArrayList inits = new ArrayList();
        CodeParser.apply(() -> node.initializers(), Expression.class, i -> {
            if (i instanceof VariableDeclarationExpression) {
                VariableDeclarationExpression d = (VariableDeclarationExpression)i;
                vType.set(this.toString(d.getType(), false));
                CodeParser.apply(() -> d.fragments(), VariableDeclarationFragment.class, f -> {
                    names.add(f.getName().getIdentifier());
                    if (f.getInitializer() != null) {
                        f.getInitializer().accept((ASTVisitor)this);
                        inits.add(this.getExToString());
                    } else {
                        inits.add("");
                    }
                });
            } else {
                i.accept((ASTVisitor)this);
                inits.add(this.getExToString());
            }
        });
        String cond = "";
        if (node.getExpression() != null) {
            node.getExpression().accept((ASTVisitor)this);
            cond = this.getExToString();
        }
        ArrayList updaters = new ArrayList();
        CodeParser.apply(() -> node.updaters(), Expression.class, u -> {
            u.accept((ASTVisitor)this);
            updaters.add(this.getExToString());
        });
        JavaCodeForLoop f = this.getBlock().addForLoop(vType.get(), CodeParser.first(names, ""), CodeParser.first(inits, ""), cond, CodeParser.first(updaters, ""));
        int l = 1;
        while (l < Math.min(Math.min(names.size(), inits.size()), updaters.size())) {
            f.addLoopVariable(CodeParser.get(names, l, ""), CodeParser.get(inits, l, ""));
            f.addUpdate(CodeParser.get(updaters, l, ""));
            ++l;
        }
        this.blocks.push(f);
        node.getBody().accept((ASTVisitor)this);
        this.blocks.pop();
        return false;
    }

    public boolean visit(ReturnStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.getBlock().addReturn(this.getEx());
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        return this.createMethodCall(node.getExpression(), "super", false, () -> node.arguments(), true);
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.createMethodCall((Expression)node.getQualifier(), "super." + node.getName().getIdentifier(), false, () -> node.arguments(), false);
    }

    private String getExToString() {
        return this.ex == null ? "" : this.getEx().toCode();
    }

    private JavaCodeParsedExpression getEx() {
        JavaCodeParsedExpression result = this.ex;
        this.ex = null;
        return result;
    }

    public boolean visit(SwitchStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        JavaCodeSwitch sw = this.getBlock().addSwitch(this.getEx());
        AtomicReference<Object> lastCase = new AtomicReference<Object>(null);
        AtomicReference<Object> lastBlock = new AtomicReference<Object>(null);
        CodeParser.apply(() -> node.statements(), Statement.class, s -> {
            if (s instanceof SwitchCase) {
                SwitchCase ca = (SwitchCase)s;
                if (lastCase.get() != null) {
                    lastBlock.set(sw.addCase(new JavaCodeTextExpression(sw, lastCase.get()), false, false));
                }
                StringBuilder expr = new StringBuilder();
                CodeParser.apply(() -> ca.expressions(), Expression.class, e -> {
                    e.accept((ASTVisitor)this);
                    if (expr.length() > 0) {
                        expr.append(", ");
                    }
                    expr.append(this.getExToString());
                });
                lastCase.set(expr.toString());
                if (lastBlock.get() != null) {
                    this.blocks.pop();
                    lastBlock.set(null);
                }
            } else {
                if (lastBlock.get() == null) {
                    JavaCodeBlock bl = ((String)lastCase.get()).isEmpty() ? sw.addDefault(s instanceof Block, false) : sw.addCase(new JavaCodeTextExpression(sw, lastCase.get()), s instanceof Block, false);
                    lastBlock.set(bl);
                    lastCase.set(null);
                    this.blocks.push((JavaCodeBlock)lastBlock.get());
                }
                s.accept((ASTVisitor)this);
            }
        });
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.blocks.push(this.getBlock().addSynchronized(this.getEx()));
        node.getBody().accept((ASTVisitor)this);
        this.blocks.pop();
        return false;
    }

    public boolean visit(ThrowStatement node) {
        node.getExpression().accept((ASTVisitor)this);
        this.getBlock().addThrow(this.getEx());
        return true;
    }

    public boolean visit(TryStatement node) {
        JavaCodeTryBlock t = this.getBlock().addTry();
        CodeParser.apply(() -> node.resources(), VariableDeclarationExpression.class, r -> {
            String type = this.toString(r.getType(), false);
            CodeParser.apply(() -> r.fragments(), VariableDeclarationFragment.class, f -> {
                if (f.getInitializer() != null) {
                    f.getInitializer().accept((ASTVisitor)this);
                }
                t.addResource(type, f.getName().getIdentifier(), this.getEx());
            });
        });
        this.blocks.push(t);
        node.getBody().accept((ASTVisitor)this);
        this.blocks.pop();
        CodeParser.apply(() -> node.catchClauses(), CatchClause.class, c -> {
            SingleVariableDeclaration v = c.getException();
            this.blocks.push(t.addCatch(this.toString(v.getType(), false), v.getName().getIdentifier()));
            c.getBody().accept((ASTVisitor)this);
            this.blocks.pop();
        });
        if (node.getFinally() != null) {
            this.blocks.push(t.addFinally());
            node.getFinally().accept((ASTVisitor)this);
            this.blocks.pop();
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        CodeParser.apply(() -> node.fragments(), VariableDeclarationFragment.class, f -> {
            f.getInitializer().accept((ASTVisitor)this);
            this.getBlock().addVariable(this.toString(node.getType(), false), f.getName().getIdentifier(), (JavaCodeExpression)this.getEx());
        });
        return false;
    }

    public boolean visit(WhileStatement node) {
        this.blocks.push(this.getBlock().addWhileLoop(node.getExpression().toString()));
        node.getBody().accept((ASTVisitor)this);
        this.blocks.pop();
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        CodeParser.apply(() -> node.bodyDeclarations(), BodyDeclaration.class, b -> b.accept((ASTVisitor)this));
        return false;
    }

    public boolean visit(ArrayAccess node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(ArrayCreation node) {
        JavaCodeNewArrayExpression nEx = new JavaCodeNewArrayExpression(null, this.toString((Type)node.getType(), true));
        CodeParser.apply(() -> node.dimensions(), Expression.class, e -> {
            e.accept((ASTVisitor)this);
            nEx.addDimension(this.getEx());
        });
        this.ex = nEx;
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        JavaCodeArrayInitializerExpression aEx = new JavaCodeArrayInitializerExpression(null, false);
        CodeParser.apply(() -> node.expressions(), Expression.class, e -> {
            e.accept((ASTVisitor)this);
            aEx.addArgument(this.getEx());
        });
        this.ex = aEx;
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(CastExpression node) {
        node.getExpression().accept((ASTVisitor)this);
        this.ex = new JavaCodeCastExpression(null, this.toString(node.getType(), false), this.getEx());
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(ClassInstanceCreation node) {
        if (node.getAnonymousClassDeclaration() != null) {
            JavaCodeAnonymousClass c = new JavaCodeAnonymousClass(this.toString(node.getType(), false), this.getCurrentClass());
            this.classes.push(c);
            CodeParser.apply(() -> node.arguments(), Expression.class, a -> {
                a.accept((ASTVisitor)this);
                c.addArgument(this.getEx());
            });
            node.getAnonymousClassDeclaration().accept((ASTVisitor)this);
            this.classes.pop();
            this.ex = JavaCodeAnonymousClass.toExpression(c);
        } else {
            this.createMethodCall(node.getExpression(), this.toString(node.getType(), false), true, () -> node.arguments(), false);
        }
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        node.getExpression().accept((ASTVisitor)this);
        JavaCodeParsedExpression condEx = this.getEx();
        node.getThenExpression().accept((ASTVisitor)this);
        JavaCodeParsedExpression thenEx = this.getEx();
        node.getElseExpression().accept((ASTVisitor)this);
        JavaCodeParsedExpression elseEx = this.getEx();
        this.ex = new JavaCodeTernaryExpression(null, condEx, thenEx, elseEx);
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        return this.createMethodCall(null, "this", false, () -> node.arguments(), true);
    }

    public boolean visit(CreationReference node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(ExpressionMethodReference node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(Dimension node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(FieldAccess node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(GuardedPattern node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(InfixExpression node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(InstanceofExpression node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(LambdaExpression node) {
        JavaCodeLambdaExpression l = new JavaCodeLambdaExpression(null);
        CodeParser.apply(() -> node.parameters(), VariableDeclaration.class, p -> l.addVariable(p.getName().getIdentifier()));
        if (node.getBody() instanceof Expression) {
            node.getBody().accept((ASTVisitor)this);
            l.addExpression(this.getEx());
        } else {
            this.blocks.push(new JavaCodeBlock(null, false, false));
            node.getBody().accept((ASTVisitor)this);
            l.setBlock(this.blocks.pop());
        }
        this.ex = l;
        return false;
    }

    private boolean createMethodCall(Expression expr, String name, boolean constructor, Supplier<List<?>> args, boolean add) {
        if (expr != null) {
            expr.accept((ASTVisitor)this);
            name = this.getExToString() + "." + (String)name;
        }
        int dotCount = StringUtils.countMatches((String)name, (String)".");
        JavaCodeImportScope scope = ((String)name).startsWith("System.") ? JavaCodeImportScope.NONE : (dotCount > 2 ? JavaCodeImportScope.CLASS_NO_METHOD : JavaCodeImportScope.NONE);
        JavaCodeMethodCall call = constructor ? new JavaCodeConstructorCall(null, (String)name, false, "") : new JavaCodeMethodCall(null, (String)name, scope, false, "");
        CodeParser.apply(args, Expression.class, a -> {
            a.accept((ASTVisitor)this);
            call.addArgument(this.getEx());
        });
        if (add) {
            this.getBlock().add(call);
        } else {
            this.ex = call;
        }
        return false;
    }

    public boolean visit(MethodInvocation node) {
        return this.createMethodCall(node.getExpression(), node.getName().getIdentifier(), false, () -> node.arguments(), false);
    }

    private boolean append(ASTNode node) {
        this.ex = this.ex == null ? new JavaCodeTextExpression(null, node.toString()) : (this.ex instanceof JavaCodeTextExpression ? ((JavaCodeTextExpression)this.ex).append(node.toString()) : new JavaCodeTextExpression(null, this.ex.toCode()).append(node.toString()));
        return false;
    }

    public boolean visit(NullLiteral node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(NullPattern node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(NumberLiteral node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(PatternInstanceofExpression node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(PostfixExpression node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(PrefixExpression node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(QualifiedName node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(QualifiedType node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(RecordPattern node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(SimpleName node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(SimpleType node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(StringLiteral node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(SuperFieldAccess node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(SuperMethodReference node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(TextBlock node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(ThisExpression node) {
        return this.append((ASTNode)node);
    }

    private void processModifier(Supplier<List<?>> modSupplier, JavaCodeMethod meth) {
        this.processModifier(modSupplier, meth, m -> {
            if (m.isDefault()) {
                meth.setDefault();
            }
            if (m.isSynchronized()) {
                meth.setSynchronized();
            }
        });
    }

    private void processModifier(Supplier<List<?>> modSupplier, JavaCodeAbstractVisibleElement elt, Consumer<Modifier> elseConsumer) {
        this.processModifier(modSupplier, elt, t -> {
            JavaCodeAbstractVisibleElement javaCodeAbstractVisibleElement2 = elt.setAbstract((boolean)t);
        }, elseConsumer);
    }

    private void processModifier(Supplier<List<?>> modSupplier, JavaCodeVisibleElement elt, Consumer<Boolean> abstractConsumer, Consumer<Modifier> elseConsumer) {
        elt.setPackage();
        CodeParser.apply(modSupplier, Modifier.class, mod -> {
            boolean done = false;
            if (mod.isPublic()) {
                elt.setPublic();
                done = true;
            } else if (mod.isPrivate()) {
                elt.setPrivate();
                done = true;
            } else if (mod.isProtected()) {
                elt.setProtected();
                done = true;
            }
            if (mod.isFinal()) {
                elt.setFinal();
                done = true;
            }
            if (mod.isStatic()) {
                elt.setStatic();
                done = true;
            }
            if (mod.isAbstract() && abstractConsumer != null) {
                abstractConsumer.accept(true);
                done = true;
            }
            if (!done && elseConsumer != null) {
                elseConsumer.accept((Modifier)mod);
            }
        });
    }

    public boolean visit(FieldDeclaration node) {
        JavaCodeClass c = this.getCurrentClass();
        if (c != null) {
            String type = this.toString(node.getType(), false);
            CodeParser.apply(() -> node.fragments(), VariableDeclarationFragment.class, f -> {
                JavaCodeAttribute a = c.addAttribute(type, f.getName().getIdentifier());
                this.processModifier(() -> node.modifiers(), a, null, m -> {
                    if (m.isTransient()) {
                        a.setTransient();
                    }
                });
                if (f.getInitializer() != null) {
                    f.getInitializer().accept((ASTVisitor)this);
                    a.addInitializer(this.getEx());
                }
            });
        }
        return false;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        JavaCodeClass c = new JavaCodeClass(node.getName().getIdentifier(), this.classes.isEmpty() ? null : this.classes.peek());
        c.asAnnotation();
        this.processModifier(() -> node.modifiers(), c, null);
        this.classes.push(c);
        CodeParser.apply(() -> node.bodyDeclarations(), BodyDeclaration.class, b -> b.accept((ASTVisitor)this));
        this.classes.pop();
        if (this.cls == null) {
            this.cls = c;
        }
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        String docComment;
        JavaCodeJavadocComment comment = new JavaCodeJavadocComment(null, null);
        Javadoc javadoc = node.getJavadoc();
        if (javadoc != null) {
            CodeParser.apply(() -> javadoc.tags(), TagElement.class, t -> {
                String tagName = t.getTagName();
                if (tagName == null) {
                    comment.setComment(CodeParser.join(t.fragments(), 0, -1));
                } else if ("@param".equals(tagName)) {
                    CodeParser.idRest(t.fragments(), (i, r) -> {
                        JavaCodeJavadocComment javaCodeJavadocComment2 = comment.addParameterComment(i, r);
                    });
                } else if ("@exception".equals(tagName)) {
                    CodeParser.idRest(t.fragments(), (i, r) -> {
                        JavaCodeJavadocComment javaCodeJavadocComment2 = comment.addExceptionComment(i, r);
                    });
                } else if ("@return".equals(tagName)) {
                    comment.addReturnComment(CodeParser.join(t.fragments(), 0, -1));
                }
            });
        }
        if ((docComment = CodeParser.getComment((ASTNode)node, this.comments, this.source)) != null) {
            comment.setComment(docComment);
        }
        AtomicBoolean enabled = new AtomicBoolean(true);
        JavaCodeClass enclosing = this.getCurrentClass();
        JavaCodeMethod m = new JavaCodeMethod(JavaCodeTypeSpecification.create(node.getType()), node.getName().getIdentifier(), enclosing, null);
        if (enclosing != null) {
            enclosing.addMethod(m);
        }
        m.setJavadocComment(comment);
        this.processModifier(() -> node.modifiers(), m);
        CodeParser.processAnnotations(() -> node.modifiers(), e -> enabled.set((boolean)e), c -> {
            JavaCodeJavadocComment javaCodeJavadocComment = m.getJavadocComment().setComment((String)c);
        }, m);
        if (node.getDefault() != null) {
            node.getDefault().accept((ASTVisitor)this);
            m.addDefault(this.getEx());
        }
        if (enabled.get()) {
            this.method = m;
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        JavaCodeClass c = new JavaCodeClass(node.getName().getIdentifier(), this.classes.isEmpty() ? null : this.classes.peek());
        c.asInterface(node.isInterface());
        this.processModifier(() -> node.modifiers(), c, null);
        CodeParser.apply(() -> node.typeParameters(), TypeParameter.class, t -> c.addGeneric(t.getName().getIdentifier()));
        c.addExtends(this.toString(node.getSuperclassType(), false));
        CodeParser.apply(() -> node.superInterfaceTypes(), Type.class, t -> c.addInterface(this.toString((Type)t, false)));
        this.classes.push(c);
        TypeDeclaration[] typeDeclarationArray = node.getTypes();
        int n = typeDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration t2 = typeDeclarationArray[n2];
            t2.accept((ASTVisitor)this);
            ++n2;
        }
        typeDeclarationArray = node.getFields();
        n = typeDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            TypeDeclaration f = typeDeclarationArray[n2];
            f.accept((ASTVisitor)this);
            ++n2;
        }
        typeDeclarationArray = node.getMethods();
        n = typeDeclarationArray.length;
        n2 = 0;
        while (n2 < n) {
            TypeDeclaration m = typeDeclarationArray[n2];
            m.accept((ASTVisitor)this);
            ++n2;
        }
        this.classes.pop();
        if (this.cls == null) {
            this.cls = c;
        }
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        JavaCodeEnum e = new JavaCodeEnum(node.getName().getIdentifier(), this.classes.isEmpty() ? null : this.classes.peek());
        this.processModifier(() -> node.modifiers(), e, null);
        CodeParser.apply(() -> node.superInterfaceTypes(), Type.class, t -> e.addInterface(this.toString((Type)t, false)));
        this.classes.push(e);
        CodeParser.apply(() -> node.enumConstants(), EnumConstantDeclaration.class, c -> e.addLiteral(c.getName().getIdentifier()));
        CodeParser.apply(() -> node.bodyDeclarations(), BodyDeclaration.class, b -> b.accept((ASTVisitor)this));
        this.classes.pop();
        if (this.enumeration == null) {
            this.enumeration = e;
        }
        if (this.cls == null) {
            this.cls = e;
        }
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(TypeLiteral node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(TypeMethodReference node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(TypePattern node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(VariableDeclarationExpression node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(StringTemplateExpression node) {
        return this.append((ASTNode)node);
    }

    public boolean visit(MethodDeclaration node) {
        String docComment;
        JavaCodeJavadocComment comment = new JavaCodeJavadocComment(null, null);
        Javadoc javadoc = node.getJavadoc();
        if (javadoc != null) {
            CodeParser.apply(() -> javadoc.tags(), TagElement.class, t -> {
                String tagName = t.getTagName();
                if (tagName == null) {
                    comment.setComment(CodeParser.join(t.fragments(), 0, -1));
                } else if ("@param".equals(tagName)) {
                    CodeParser.idRest(t.fragments(), (i, r) -> {
                        JavaCodeJavadocComment javaCodeJavadocComment2 = comment.addParameterComment(i, r);
                    });
                } else if ("@exception".equals(tagName)) {
                    CodeParser.idRest(t.fragments(), (i, r) -> {
                        JavaCodeJavadocComment javaCodeJavadocComment2 = comment.addExceptionComment(i, r);
                    });
                } else if ("@return".equals(tagName)) {
                    comment.addReturnComment(CodeParser.join(t.fragments(), 0, -1));
                }
            });
        }
        if ((docComment = CodeParser.getComment((ASTNode)node, this.comments, this.source)) != null) {
            comment.setComment(docComment);
        }
        AtomicBoolean enabled = new AtomicBoolean(true);
        JavaCodeClass enclosing = this.getCurrentClass();
        JavaCodeMethod m = new JavaCodeMethod(JavaCodeTypeSpecification.create(node.getReturnType2()), node.getName().getIdentifier(), enclosing, null);
        if (enclosing != null) {
            enclosing.addMethod(m);
        }
        m.setJavadocComment(comment);
        this.processModifier(() -> node.modifiers(), m);
        CodeParser.processAnnotations(() -> node.modifiers(), e -> enabled.set((boolean)e), c -> {
            JavaCodeJavadocComment javaCodeJavadocComment = m.getJavadocComment().setComment((String)c);
        }, m);
        CodeParser.apply(() -> node.thrownExceptionTypes(), Type.class, t -> m.addException(t.toString(), CodeParser.getComment((ASTNode)t, this.comments, this.source)));
        CodeParser.apply(() -> node.parameters(), SingleVariableDeclaration.class, d -> {
            AtomicBoolean paramEnabled = new AtomicBoolean(true);
            AtomicReference<String> paramComment = new AtomicReference<String>();
            paramComment.set(CodeParser.getComment((ASTNode)d, this.comments, this.source));
            JavaCodeParameterSpecification p = new JavaCodeParameterSpecification(d.getType().toString(), d.getName().getIdentifier(), m);
            CodeParser.apply(() -> d.modifiers(), Modifier.class, mod -> p.setFinal(mod.isFinal()));
            CodeParser.processAnnotations(() -> d.modifiers(), e -> paramEnabled.set((boolean)e), c -> paramComment.set((String)c), p);
            if (paramEnabled.get()) {
                m.addParameter(p, (String)paramComment.get());
            } else {
                m.getJavadocComment().deleteParameterComment(p.getName());
            }
        });
        this.blocks.push(m.getBlock());
        if (node.getBody() != null) {
            node.getBody().accept((ASTVisitor)this);
        }
        this.blocks.pop();
        if (enabled.get()) {
            this.method = m;
        }
        return false;
    }

    static interface ProblemConsumer {
        public void accept(IProblem var1) throws VilException;
    }
}

