/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibility;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibleElement;

public abstract class JavaCodeAbstractVisibleElement
extends JavaCodeVisibleElement {
    private boolean isAbstract;
    private List<String> generics;

    protected JavaCodeAbstractVisibleElement(String name, JavaCodeVisibility visibility, String comment) {
        super(name, visibility, comment);
    }

    @OperationMeta(name={"setAbstract", "abstract"})
    public JavaCodeAbstractVisibleElement setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    @OperationMeta(name={"setAbstract", "abstract"})
    public JavaCodeAbstractVisibleElement setAbstract() {
        this.setAbstract(true);
        return this;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    @OperationMeta(name={"addGeneric", "generic"})
    public JavaCodeAbstractVisibleElement addGeneric(String generic) {
        if (this.generics == null) {
            this.generics = new ArrayList<String>();
        }
        this.generics.add(generic);
        return this;
    }

    @Override
    @Invisible
    protected String insertModifier(String text) {
        Object result = text;
        if (this.isAbstract) {
            result = IJavaCodeElement.appendWhitespace(text) + "abstract";
        }
        return result;
    }

    @Override
    @Invisible
    protected String insertGenerics(String text) {
        return text + IJavaCodeElement.toList(this.generics, ", ");
    }

    protected void storeGenerics(CodeWriter out) {
        if (this.generics != null) {
            out.print("<" + IJavaCodeElement.toList(this.generics, ", ") + ">");
        }
    }
}

