/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlock;

public class JavaCodeAlternative
extends JavaCodeBlock {
    private String condition;
    private JavaCodeBlock elseBlock;

    public JavaCodeAlternative(IJavaCodeElement parent, String condition) {
        super(parent, true, false);
        this.condition = condition;
    }

    @OperationMeta(name={"addElse", "else"})
    public JavaCodeBlock addElse() {
        this.elseBlock = new JavaCodeBlock(this, true, true);
        return this.elseBlock;
    }

    @OperationMeta(name={"addElseIf", "elseIf"})
    public JavaCodeAlternative addElseIf(String condition) {
        JavaCodeAlternative result = new JavaCodeAlternative(this, condition);
        this.elseBlock = result;
        return result;
    }

    public boolean hasElse() {
        return this.elseBlock instanceof JavaCodeBlock;
    }

    public boolean hasElseIf() {
        return this.elseBlock instanceof JavaCodeAlternative;
    }

    public JavaCodeAlternative elseIfToElse() {
        if (this.elseBlock instanceof JavaCodeAlternative) {
            JavaCodeBlock tmp = new JavaCodeBlock(this, true, true);
            tmp.addAll(this.elseBlock);
            this.elseBlock = tmp;
        }
        return this;
    }

    private boolean isCascaded() {
        boolean chained = false;
        if (this.getParent() instanceof JavaCodeAlternative) {
            chained = !((JavaCodeAlternative)this.getParent()).contains(this);
        }
        return chained;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        if (this.isCascaded()) {
            out.print(" ");
        } else {
            out.printIndent();
        }
        out.print("if (");
        out.print(this.condition);
        out.print(")");
        super.store(out);
        if (this.elseBlock != null) {
            out.print(" else");
            this.elseBlock.store(out);
        } else {
            out.println();
        }
    }
}

