/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotationArgument;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeArrayInitializerExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParameterSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStringExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTextExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import org.apache.commons.lang.StringEscapeUtils;

public class JavaCodeAnnotation
implements IJavaCodeElement {
    private JavaCodeTypeSpecification type;
    private IJavaCodeElement annotated;
    private List<JavaCodeAnnotationArgument> arguments;
    private String nested;

    JavaCodeAnnotation(JavaCodeTypeSpecification type, IJavaCodeElement annotated) {
        this(type, null, annotated);
    }

    JavaCodeAnnotation(JavaCodeTypeSpecification type, String nested, IJavaCodeElement annotated) {
        this.annotated = annotated;
        this.type = type;
        this.nested = nested;
        if (this.getArtifact() != null) {
            this.getArtifact().validateType(type);
        }
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + " " + this.type.getStringValue(comparator);
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(Object value) {
        return this.addArgument(null, value);
    }

    @OperationMeta(name={"addStringArgument", "stringArg"})
    public JavaCodeAnnotation addStringArgument(String value) {
        this.addArgument("\"" + StringEscapeUtils.escapeJava((String)value) + "\"");
        return this;
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(Sequence<?> values) {
        return this.addArgument((String)null, values);
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(String name, Sequence<?> values) {
        this.ensureArguments();
        ArrayList<JavaCodeExpression> tmp = new ArrayList<JavaCodeExpression>();
        for (Object o : values) {
            tmp.add(new JavaCodeTextExpression(this, (o = IVilType.convertVilValue(o)) == null ? "" : o.toString()));
        }
        IJavaCodeElement.add(this.arguments, new JavaCodeAnnotationArgument(name, null, tmp, false, this));
        return this;
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(String name, Object value) {
        return this.addArgument(name, value, false);
    }

    @OperationMeta(name={"addStringArgument", "stringArg"})
    public JavaCodeAnnotation addStringArgument(String name, String value) {
        return this.addArgument(name, "\"" + StringEscapeUtils.escapeJava((String)value) + "\"");
    }

    public JavaCodeArrayInitializerExpression addArrayArgument(String name, boolean lineBreaks) {
        JavaCodeArrayInitializerExpression result = new JavaCodeArrayInitializerExpression(this, lineBreaks);
        this.ensureArguments();
        this.arguments.add(new JavaCodeAnnotationArgument(name, result, null, lineBreaks, this));
        return result;
    }

    public JavaCodeArrayInitializerExpression addArrayArgument(boolean lineBreaks) {
        return this.addArrayArgument(null, lineBreaks);
    }

    @OperationMeta(name={"addClassArgument", "classArg"})
    public JavaCodeAnnotation addClassArgument(String cls) {
        return this.addClassArgument(null, cls);
    }

    @OperationMeta(name={"addClassArgument", "classArg"})
    public JavaCodeAnnotation addClassArgument(String name, String cls) {
        JavaCodeTypeSpecification type;
        if (cls.endsWith(".class")) {
            cls = cls.substring(0, cls.length() - 6);
        }
        if ((type = JavaCodeTypeSpecification.toClassType(cls, this)) != null) {
            this.addArgument(name, type.getOutputTypeName() + ".class");
        }
        return this;
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(String name, Object value, boolean valueAsString) {
        return this.addArgument(name, value, null, false, valueAsString);
    }

    private void ensureArguments() {
        if (this.arguments == null) {
            this.arguments = new ArrayList<JavaCodeAnnotationArgument>();
        }
    }

    private JavaCodeAnnotation addArgument(String name, Object value, List<JavaCodeExpression> values, boolean splitLines, boolean valueAsString) {
        this.ensureArguments();
        value = IVilType.convertVilValue((Object)value);
        String stringValue = value == null ? null : value.toString();
        JavaCodeTextExpression v = null;
        v = stringValue != null && valueAsString ? new JavaCodeStringExpression((IJavaCodeElement)this, stringValue) : new JavaCodeTextExpression(this, stringValue);
        IJavaCodeElement.add(this.arguments, new JavaCodeAnnotationArgument(name, v, values, splitLines, this));
        return this;
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(Sequence<String> values, boolean valuesAsTypes) {
        return this.addArgument((String)null, values, valuesAsTypes);
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(Sequence<String> values, boolean splitLines, boolean valuesAsTypes) {
        return this.addArgument(null, values, splitLines, valuesAsTypes);
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(String name, Sequence<String> values, boolean valuesAsTypes) {
        return this.addArgument(name, values, false, valuesAsTypes);
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeAnnotation addArgument(String name, Sequence<String> values, boolean splitAndIndent, boolean valuesAsTypes) {
        ArrayList<JavaCodeExpression> tmp = new ArrayList<JavaCodeExpression>();
        for (String s : values) {
            tmp.add(new JavaCodeTextExpression(this, s));
            if (!valuesAsTypes || !s.endsWith(".class")) continue;
            s = s.substring(0, s.length() - 6);
            new JavaCodeTypeSpecification(s, this.annotated);
        }
        return this.addArgument(name, null, tmp, splitAndIndent, false);
    }

    @Override
    public void store(CodeWriter out) {
        this.storeNoLn(out);
        out.println();
    }

    public void storeNoLn(CodeWriter out) {
        out.printwi("@");
        out.print(this.type.getOutputTypeName());
        if (this.nested != null && this.nested.length() > 0) {
            out.print(".");
            out.print(this.nested);
        }
        if (this.arguments != null && !this.arguments.isEmpty()) {
            out.print("(");
            IJavaCodeElement.storeList(this.arguments, ", ", out);
            out.print(")");
        }
    }

    @Override
    public IJavaCodeArtifact getArtifact() {
        return this.annotated.getArtifact();
    }

    @Override
    public IJavaCodeElement getParent() {
        return this.annotated;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        this.annotated = parent;
    }

    @Override
    public int getElementCount() {
        return this.annotated instanceof JavaCodeParameterSpecification ? 0 : 1;
    }

    public String getType() {
        return this.type.getType();
    }
}

