/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.function.Consumer;
import java.util.function.Function;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeArgumentListExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParameterSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVariableDeclaration;

public class JavaCodeArrayInitializerExpression
extends JavaCodeArgumentListExpression {
    private boolean lineBreaks = false;
    private boolean indent = true;

    protected JavaCodeArrayInitializerExpression(IJavaCodeElement parent, boolean lineBreaks) {
        super(parent);
        this.lineBreaks = lineBreaks;
    }

    public static JavaCodeArrayInitializerExpression create() {
        return new JavaCodeArrayInitializerExpression(null, false);
    }

    public static JavaCodeArrayInitializerExpression create(boolean lineBreaks) {
        return new JavaCodeArrayInitializerExpression(null, lineBreaks);
    }

    @OperationMeta(name={"indent"})
    public JavaCodeArrayInitializerExpression setIndent(boolean indent) {
        this.indent = indent;
        return this;
    }

    @OperationMeta(name={"linebreaks"})
    public JavaCodeArrayInitializerExpression setLinebreaks(boolean lineBreaks) {
        this.lineBreaks = lineBreaks;
        return this;
    }

    @Override
    @OperationMeta(name={"value"})
    public JavaCodeArrayInitializerExpression addArgument(Object arg) {
        return (JavaCodeArrayInitializerExpression)super.addArgument(arg);
    }

    @Override
    @OperationMeta(name={"null"})
    public JavaCodeArrayInitializerExpression addNullArgument() {
        return (JavaCodeArrayInitializerExpression)super.addNullArgument();
    }

    @Override
    @OperationMeta(name={"string"})
    public JavaCodeArrayInitializerExpression addStringArgument(String val) {
        return (JavaCodeArrayInitializerExpression)super.addStringArgument(val);
    }

    @Override
    @OperationMeta(name={"stringNotEmpty"})
    public JavaCodeArrayInitializerExpression addStringArgumentNotEmpty(String val) {
        return (JavaCodeArrayInitializerExpression)super.addStringArgumentNotEmpty(val);
    }

    @Override
    @OperationMeta(name={"class"})
    public JavaCodeArrayInitializerExpression addClassArgument(String cls) {
        return (JavaCodeArrayInitializerExpression)super.addClassArgument(cls);
    }

    @Override
    @OperationMeta(name={"this"})
    public JavaCodeArrayInitializerExpression addThisArgument() {
        return (JavaCodeArrayInitializerExpression)super.addThisArgument();
    }

    @Override
    @OperationMeta(name={"text"})
    public JavaCodeArrayInitializerExpression addArgument(String arg) {
        return (JavaCodeArrayInitializerExpression)super.addArgument(arg);
    }

    @Override
    @OperationMeta(name={"value"})
    public JavaCodeArrayInitializerExpression addArgument(JavaCodeExpression ex) {
        return (JavaCodeArrayInitializerExpression)super.addArgument(ex);
    }

    @Override
    @OperationMeta(name={"var"})
    public JavaCodeArrayInitializerExpression addArgument(JavaCodeVariableDeclaration var) {
        return (JavaCodeArrayInitializerExpression)super.addArgument(var);
    }

    @Override
    @OperationMeta(name={"var"})
    public JavaCodeArrayInitializerExpression addArgument(JavaCodeParameterSpecification param) {
        return (JavaCodeArrayInitializerExpression)super.addArgument(param);
    }

    @Override
    @OperationMeta(name={"const"})
    public JavaCodeArrayInitializerExpression addConstantArgument(String arg) {
        return (JavaCodeArrayInitializerExpression)super.addConstantArgument(arg);
    }

    @Override
    @OperationMeta(name={"args"})
    public JavaCodeArrayInitializerExpression addArguments(JavaCodeArgumentListExpression arguments) {
        return (JavaCodeArrayInitializerExpression)super.addArguments(arguments);
    }

    @OperationMeta(name={"values"})
    public JavaCodeArrayInitializerExpression addValues(Sequence<?> values) {
        return this.addValues(values, v -> v, v -> {
            JavaCodeArrayInitializerExpression javaCodeArrayInitializerExpression = this.addArgument(v);
        });
    }

    @OperationMeta(name={"stringValues"})
    public JavaCodeArrayInitializerExpression addStringValues(Sequence<?> values) {
        return this.addValues(values, String::valueOf, v -> {
            JavaCodeArrayInitializerExpression javaCodeArrayInitializerExpression = this.addStringArgument((String)v);
        });
    }

    @OperationMeta(name={"classValues"})
    public JavaCodeArrayInitializerExpression addClassValues(Sequence<?> values) {
        return this.addValues(values, String::valueOf, v -> {
            JavaCodeArrayInitializerExpression javaCodeArrayInitializerExpression = this.addClassArgument((String)v);
        });
    }

    private <T> JavaCodeArrayInitializerExpression addValues(Sequence<?> values, Function<Object, T> transformer, Consumer<T> consumer) {
        for (Object v : values) {
            consumer.accept(transformer.apply(IVilType.convertVilValue(v)));
        }
        return this;
    }

    @Override
    @OperationMeta(name={"valuesCount"})
    public int getArgumentsCount() {
        return super.getArgumentsCount();
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        out.print("{");
        if (this.lineBreaks) {
            int count = 0;
            int last = this.getArgumentsCount();
            if (last > 0) {
                out.println();
                if (this.indent) {
                    out.increaseIndent();
                }
                for (IJavaCodeElement v : this.arguments()) {
                    out.printIndent();
                    v.store(out);
                    if (++count >= last) continue;
                    out.println(",");
                }
                if (this.indent) {
                    out.decreaseIndent();
                }
            }
        } else {
            this.storeArgumentList(out);
        }
        out.print("}");
    }
}

