/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoString;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnonymousClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeConstructorCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethod;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeNewArrayExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStringExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTextExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibility;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibleElement;

public class JavaCodeAttribute
extends JavaCodeVisibleElement {
    private JavaCodeTypeSpecification type;
    private JavaCodeClass enclosing;
    private JavaCodeExpression initializer;
    private boolean isTransient;

    protected JavaCodeAttribute(JavaCodeTypeSpecification type, String name, JavaCodeClass enclosing) {
        super(name, JavaCodeVisibility.PRIVATE, null);
        this.enclosing = enclosing;
        this.type = type;
    }

    @Override
    public boolean isAttribute() {
        return true;
    }

    @Override
    @Invisible
    public IJavaCodeArtifact getArtifact() {
        return this.enclosing.getArtifact();
    }

    @Override
    @Invisible
    protected JavaCodeClass getEnclosing() {
        return this.enclosing;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        super.store(out);
        out.printwi(this.getModifier());
        if (this.isTransient) {
            out.print("transient");
            out.print(" ");
        }
        this.type.store(out);
        out.print(" ");
        out.print(this.getName());
        if (this.initializer != null) {
            out.print(" = ");
            this.initializer.store(out);
        }
        out.println(";");
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + ": " + this.getName();
    }

    @Override
    public JavaCodeAttribute setVisibility(String visibility) {
        super.setVisibility(visibility);
        return this;
    }

    @Override
    public JavaCodeAttribute setVisibility(JavaCodeVisibility visibility) {
        super.setVisibility(visibility);
        return this;
    }

    @Override
    public JavaCodeAttribute setPublic() {
        super.setPublic();
        return this;
    }

    @Override
    public JavaCodeAttribute setPrivate() {
        super.setPrivate();
        return this;
    }

    @Override
    public JavaCodeAttribute setProtected() {
        super.setProtected();
        return this;
    }

    @Override
    public JavaCodeAttribute setPackage() {
        super.setPackage();
        return this;
    }

    @Override
    public JavaCodeAttribute setStatic(boolean isStatic) {
        super.setStatic(isStatic);
        return this;
    }

    @Override
    public JavaCodeAttribute setStatic() {
        super.setStatic();
        return this;
    }

    @OperationMeta(name={"setTransient", "transient"})
    public JavaCodeVisibleElement setTransient() {
        this.setTransient(true);
        return this;
    }

    @OperationMeta(name={"setTransient", "transient"})
    public JavaCodeVisibleElement setTransient(boolean isTransient) {
        this.isTransient = isTransient;
        return this;
    }

    public JavaCodeAttribute setPublicStaticFinal() {
        super.setPublic();
        super.setStatic();
        super.setFinal();
        return this;
    }

    @OperationMeta(name={"addInitializer", "initializer"})
    public JavaCodeAttribute addInitializer(JavaCodeExpression initializer) {
        this.initializer = initializer;
        if (this.initializer != null) {
            this.initializer.setParent(this);
        }
        return this;
    }

    @OperationMeta(name={"addStringInitializer", "stringInitializer"})
    public JavaCodeAttribute addStringInitializer(String stringEx) {
        this.initializer = new JavaCodeStringExpression((IJavaCodeElement)this, stringEx);
        return this;
    }

    public JavaCodeAnonymousClass addAnonymous(String cls) {
        JavaCodeAnonymousClass ano = new JavaCodeAnonymousClass(cls, this.getEnclosing());
        this.initializer = JavaCodeAnonymousClass.toExpression(ano);
        return ano;
    }

    public JavaCodeConstructorCall addNew(String cls) {
        this.initializer = new JavaCodeConstructorCall(this, cls, false, "");
        return (JavaCodeConstructorCall)this.initializer;
    }

    public JavaCodeNewArrayExpression addNewArray(String type) {
        this.initializer = new JavaCodeNewArrayExpression(this, type);
        return (JavaCodeNewArrayExpression)this.initializer;
    }

    public JavaCodeMethodCall addCall(String methodName, JavaCodeImportScope scope) {
        this.initializer = new JavaCodeMethodCall(this, methodName, scope, false, "");
        return (JavaCodeMethodCall)this.initializer;
    }

    public JavaCodeMethod addGetter() {
        return this.addGetter(false);
    }

    public JavaCodeMethod addGetter(boolean mayBeNull) {
        String attribute = this.getName();
        JavaCodeMethod method = this.enclosing.addMethod(this.type, "get" + PseudoString.firstToUpperCase((String)attribute), "Returns the value of " + attribute + ".");
        method.setStatic(this.isStatic());
        String retComment = "the value of " + attribute + (mayBeNull ? ", may be <b>null</b>" : "");
        method.addReturn(new JavaCodeTextExpression(this, this.getName()), retComment);
        return method;
    }

    public JavaCodeMethod addSetter() {
        return this.addSetter(null);
    }

    public JavaCodeMethod addSetter(String paramName) {
        return this.addSetter(paramName, false);
    }

    public JavaCodeMethod addSetter(boolean mayBeNull) {
        return this.addSetter(null, mayBeNull);
    }

    public JavaCodeMethod addSetter(String paramName, boolean mayBeNull) {
        String attribute = this.getName();
        String pName = paramName == null || paramName.length() == 0 ? attribute : paramName;
        JavaCodeMethod method = this.enclosing.addMethod(JavaCodeTypeSpecification.VOID, "set" + PseudoString.firstToUpperCase((String)attribute), "Changes the value of " + attribute + ".");
        method.setStatic(this.isStatic());
        method.addParameter(this.type, pName, "the new value" + (mayBeNull ? ", may be <b>null</b>" : ""));
        method.add("this." + attribute + " = " + pName + ";");
        return method;
    }

    @Override
    public IJavaCodeElement getParent() {
        return this.enclosing;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        JavaCodeClass.setParent(parent, p -> {
            JavaCodeClass javaCodeClass = this.enclosing = p;
        });
    }
}

