/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.AST2ArtifactVisitor;
import net.ssehub.easy.instantiation.java.codeArtifacts.ConditionalAttributeNewLineStrategy;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAbstractVisibleElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAttribute;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeEmptyLine;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeEnum;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeInitializer;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethod;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeSingleLineComment;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeText;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibility;
import net.ssehub.easy.instantiation.java.codeArtifacts.NewLineStrategy;
import net.ssehub.easy.instantiation.java.codeArtifacts.ProxyElement;

public class JavaCodeClass
extends JavaCodeAbstractVisibleElement {
    static final JavaCodeClass EMPTY = new JavaCodeClass("", JavaCodeArtifact.EMPTY);
    private static NewLineStrategy newLineStrategy = new ConditionalAttributeNewLineStrategy();
    private Kind kind = Kind.CLASS;
    private List<IJavaCodeElement> elements = new ArrayList<IJavaCodeElement>();
    private JavaCodeClass enclosing;
    private IJavaCodeArtifact artifact;
    private JavaCodeTypeSpecification extendingClass;
    private List<JavaCodeTypeSpecification> implementedInterfaces;

    JavaCodeClass(String name, IJavaCodeArtifact artifact) {
        this(name, artifact, null);
    }

    JavaCodeClass(String name, IJavaCodeArtifact artifact, String comment) {
        super(name, JavaCodeVisibility.PUBLIC, comment);
        this.artifact = artifact;
    }

    JavaCodeClass(String name, JavaCodeClass enclosing) {
        this(name, enclosing, null);
    }

    JavaCodeClass(String name, JavaCodeClass enclosing, String comment) {
        super(name, JavaCodeVisibility.PUBLIC, comment);
        this.enclosing = enclosing;
    }

    @Invisible
    @Conversion
    public static JavaCodeClass convert(Object text) throws VilException {
        JavaCodeClass result = null;
        Object tmp = IVilType.convertVilValue((Object)text);
        if (tmp != null) {
            result = JavaCodeClass.create(text.toString(), AST2ArtifactVisitor.vilExceptionConsumer());
        }
        return result;
    }

    private static JavaCodeClass create(String text, AST2ArtifactVisitor.ProblemConsumer problem) throws VilException {
        return AST2ArtifactVisitor.parseCompilationUnit(text, problem).getCls();
    }

    public static JavaCodeClass create(String text) throws VilException {
        return JavaCodeClass.create(text, AST2ArtifactVisitor.logConsumer());
    }

    @Override
    protected String validateName(String name) {
        JavaCodeTypeSpecification tmp = new JavaCodeTypeSpecification(name, null);
        int g = 0;
        while (g < tmp.getGenericCount()) {
            this.addGeneric(tmp.getGeneric(g).getOutputTypeName());
            ++g;
        }
        return tmp.getOutputTypeName();
    }

    @Override
    @Invisible
    public IJavaCodeArtifact getArtifact() {
        if (this.artifact == null) {
            return this.enclosing == null ? null : this.enclosing.getArtifact();
        }
        return this.artifact;
    }

    @Override
    @Invisible
    protected JavaCodeClass getEnclosing() {
        return this.enclosing;
    }

    @Override
    protected JavaCodeClass getClassParent() {
        return this;
    }

    public JavaCodeClass addClass(String name) {
        return IJavaCodeElement.add(this.elements, new JavaCodeClass(name, this).setProtected());
    }

    public JavaCodeClass addClass(String name, String comment) {
        return IJavaCodeElement.add(this.elements, new JavaCodeClass(name, this, comment).setProtected());
    }

    public JavaCodeEnum addEnum(String name) {
        return IJavaCodeElement.add(this.elements, new JavaCodeEnum(name, this));
    }

    public JavaCodeEnum addEnum(String name, String comment) {
        return IJavaCodeElement.add(this.elements, new JavaCodeEnum(name, this, comment));
    }

    @OperationMeta(name={"addInitializer", "initializer"})
    public JavaCodeInitializer addInitializer(boolean isStatic) {
        return IJavaCodeElement.add(this.elements, new JavaCodeInitializer(this, isStatic));
    }

    public void removeIfEmpty(JavaCodeElement elt) {
        if (elt.isEmpty()) {
            this.elements.remove(elt);
        }
    }

    @OperationMeta(name={"addAttribute", "attribute"})
    public JavaCodeAttribute addAttribute(String type, String name) {
        return this.createAttribute(type, name, true);
    }

    public JavaCodeAttribute createAttribute(String type, String name, boolean add) {
        JavaCodeAttribute result = new JavaCodeAttribute(JavaCodeTypeSpecification.create(type, this), name, this);
        if (add) {
            IJavaCodeElement.add(this.elements, result, JavaCodeClass.lastAttribute(this.elements));
        }
        return result;
    }

    JavaCodeAttribute addAttribute(JavaCodeTypeSpecification type, String name) {
        return IJavaCodeElement.add(this.elements, new JavaCodeAttribute(type, name, this), JavaCodeClass.lastAttribute(this.elements));
    }

    private static int lastAttribute(List<IJavaCodeElement> elements) {
        int pos = 0;
        while (pos < elements.size() && elements.get(pos).isAttribute()) {
            ++pos;
        }
        return pos;
    }

    @OperationMeta(name={"addExtends", "extends"})
    public JavaCodeClass addExtends(String type) {
        if (type != null && type.length() > 0) {
            this.extendingClass = JavaCodeTypeSpecification.create(type, this);
        }
        return this;
    }

    @OperationMeta(name={"addInterface", "implements"})
    public JavaCodeClass addInterface(String type) {
        if (type != null && type.length() > 0) {
            if (this.implementedInterfaces == null) {
                this.implementedInterfaces = new ArrayList<JavaCodeTypeSpecification>();
            }
            IJavaCodeElement.add(this.implementedInterfaces, JavaCodeTypeSpecification.create(type, this));
        }
        return this;
    }

    protected void setKind(Kind kind) {
        this.kind = kind;
    }

    public JavaCodeClass asInterface() {
        this.setKind(Kind.INTERFACE);
        return this;
    }

    public JavaCodeClass asInterface(boolean enable) {
        if (enable) {
            this.asInterface();
        }
        return this;
    }

    public JavaCodeClass asAnnotation() {
        this.setKind(Kind.ANNOTATION);
        return this;
    }

    @OperationMeta(name={"addMainMethod", "main"})
    public JavaCodeMethod addMainMethod() {
        return this.addMainMethod("The main method.", "args", "command line arguments");
    }

    @OperationMeta(name={"addMainMethod", "main"})
    public JavaCodeMethod addMainMethod(String methodComment) {
        return this.addMainMethod(methodComment, "args", "command line arguments");
    }

    @OperationMeta(name={"addMainMethod", "main"})
    public JavaCodeMethod addMainMethod(String methodComment, String param, String paramComment) {
        JavaCodeMethod result = this.addMethod("void", "main", methodComment).setStatic();
        result.addParameter("String[]", param, paramComment);
        return result;
    }

    @OperationMeta(name={"addConstructor", "constructor"})
    public JavaCodeMethod addConstructor() {
        return this.addConstructor(null);
    }

    @OperationMeta(name={"addConstructor", "constructor"})
    public JavaCodeMethod addConstructor(String comment) {
        return IJavaCodeElement.add(this.elements, this.configureConstructor(new JavaCodeMethod(null, this.getName(), this, comment)));
    }

    protected JavaCodeMethod configureConstructor(JavaCodeMethod cons) {
        return cons;
    }

    public JavaCodeMethod addMethod(JavaCodeMethod method) {
        method.setParent(this);
        return IJavaCodeElement.add(this.elements, method);
    }

    @OperationMeta(name={"addMethod", "method"})
    public JavaCodeMethod addMethod(String name) {
        return IJavaCodeElement.add(this.elements, new JavaCodeMethod(name, this));
    }

    @OperationMeta(name={"addMethod", "method"})
    public JavaCodeMethod addMethod(String type, String name) {
        return IJavaCodeElement.add(this.elements, new JavaCodeMethod(JavaCodeTypeSpecification.create(type, this), name, this));
    }

    @OperationMeta(name={"addMethod", "method"})
    public JavaCodeMethod addMethod(String type, String name, String comment) {
        return IJavaCodeElement.add(this.elements, new JavaCodeMethod(JavaCodeTypeSpecification.create(type, this), name, this, comment));
    }

    @OperationMeta(name={"addMethod", "method"})
    public JavaCodeMethod addMethod(String type, String name, String comment, String returnComment) {
        JavaCodeMethod result = this.addMethod(type, name, comment);
        result.getJavadocComment().addReturnComment(returnComment);
        return result;
    }

    JavaCodeMethod addMethod(JavaCodeTypeSpecification type, String name, String comment) {
        return IJavaCodeElement.add(this.elements, new JavaCodeMethod(type, name, this, comment));
    }

    JavaCodeMethod addMethod(JavaCodeTypeSpecification type, String name) {
        return IJavaCodeElement.add(this.elements, new JavaCodeMethod(type, name, this));
    }

    public JavaCodeMethod addGetter(JavaCodeAttribute attribute) {
        return attribute.addGetter();
    }

    public JavaCodeMethod addSetter(JavaCodeAttribute attribute) {
        return attribute.addSetter();
    }

    public JavaCodeMethod addSetter(JavaCodeAttribute attribute, String paramName) {
        return attribute.addSetter(paramName);
    }

    @Override
    public JavaCodeClass addGeneric(String name) {
        return (JavaCodeClass)super.addGeneric(name);
    }

    public JavaCodeClass addGeneric(String name, String comment) {
        super.addGeneric(name);
        if (comment != null && comment.length() > 0) {
            this.getJavadocComment().addGenericComment(name, comment);
        }
        return this;
    }

    public JavaCodeMethod addToString() {
        JavaCodeMethod toString = this.addMethod("String", "toString");
        toString.addOverrideAnnotation();
        return toString;
    }

    public JavaCodeMethod addHashCode() {
        JavaCodeMethod hash = this.addMethod("int", "hashCode");
        hash.addOverrideAnnotation();
        return hash;
    }

    public JavaCodeMethod addEquals(String paramName) {
        JavaCodeMethod eq = this.addMethod("boolean", "equals");
        eq.addOverrideAnnotation();
        eq.addParameter("Object", "other");
        return eq;
    }

    public JavaCodeMethod addMain(String paramName, boolean varArg) {
        JavaCodeMethod main = this.addMethod("", "main", "Executes the program.");
        main.setStatic();
        main.addParameter("String" + (varArg ? "[]" : "..."), "args", "Command line arguments");
        return main;
    }

    public void add(String text) {
        this.elements.add(new JavaCodeText(text, true, true));
    }

    public void addRaw(String text, boolean indent) {
        this.elements.add(new JavaCodeText(text, indent, true));
    }

    public JavaCodeClass addEmptyLine() {
        IJavaCodeElement.add(this.elements, new JavaCodeEmptyLine(this));
        return this;
    }

    public JavaCodeClass addSLComment(String text) {
        IJavaCodeElement.add(this.elements, new JavaCodeSingleLineComment(this, text));
        return this;
    }

    @Override
    public JavaCodeClass setVisibility(String visibility) {
        super.setVisibility(visibility);
        return this;
    }

    @Override
    public JavaCodeClass setVisibility(JavaCodeVisibility visibility) {
        super.setVisibility(visibility);
        return this;
    }

    @Override
    public JavaCodeClass setPublic() {
        super.setPublic();
        return this;
    }

    @Override
    public JavaCodeClass setPublic(boolean isPublic) {
        super.setPublic(isPublic);
        return this;
    }

    @Override
    public JavaCodeClass setPrivate() {
        super.setPrivate();
        return this;
    }

    @Override
    public JavaCodeClass setPrivate(boolean isPrivate) {
        super.setPrivate(isPrivate);
        return this;
    }

    @Override
    public JavaCodeClass setProtected() {
        super.setProtected();
        return this;
    }

    @Override
    public JavaCodeClass setProtected(boolean isProtected) {
        super.setProtected(isProtected);
        return this;
    }

    @Override
    public JavaCodeClass setPackage() {
        super.setPackage();
        return this;
    }

    @Override
    public JavaCodeClass setPackage(boolean isPackage) {
        super.setPackage(isPackage);
        return this;
    }

    @Override
    public JavaCodeClass setStatic(boolean isStatic) {
        super.setStatic(isStatic);
        return this;
    }

    @Override
    public JavaCodeClass setStatic() {
        super.setStatic();
        return this;
    }

    @Override
    public JavaCodeClass setAbstract(boolean isAbstract) {
        super.setAbstract(isAbstract);
        return this;
    }

    @Override
    public JavaCodeClass setAbstract() {
        super.setAbstract();
        return this;
    }

    @Invisible
    Kind getKind() {
        return this.kind;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        super.store(out);
        out.printwi(this.getModifier() + this.kind.getKeyword() + " " + this.getName());
        this.storeGenerics(out);
        if (this.extendingClass != null) {
            out.print(" extends ");
            this.extendingClass.store(out);
        }
        IJavaCodeElement.storeList(" implements ", this.implementedInterfaces, ", ", out);
        this.storeBlock(out);
        out.println();
    }

    @Override
    @Invisible
    protected String insertGenerics(String text) {
        return text;
    }

    protected void storeBlock(CodeWriter out) {
        out.println(" {");
        out.increaseIndent();
        this.storeAtBlockStart(out);
        if (this.elements.size() > 0) {
            out.println();
            newLineStrategy.start();
            for (IJavaCodeElement e : this.sortedElements()) {
                if (newLineStrategy.emitNewlineBefore(e)) {
                    out.println();
                }
                e.store(out);
                if (!newLineStrategy.emitNewlineAfter(e)) continue;
                out.println();
            }
        }
        out.decreaseIndent();
        out.printwi("}");
    }

    private List<IJavaCodeElement> sortedElements() {
        ElementSorting sorting = IJavaCodeElement.getFormattingArgument(ElementSorting.class, "eltSorting", ElementSorting.NONE);
        return switch (sorting) {
            case ElementSorting.CONS -> this.partition(null);
            case ElementSorting.CONS_ALPHA -> this.partition(IJavaCodeElement.KEY_COMPARATOR);
            default -> this.elements;
        };
    }

    private List<IJavaCodeElement> partition(Comparator<IJavaCodeElement> methodComparator) {
        List<IJavaCodeElement> result = ProxyElement.proxy(this.elements);
        ArrayList<IJavaCodeElement> before = new ArrayList<IJavaCodeElement>();
        ArrayList<IJavaCodeElement> init = new ArrayList<IJavaCodeElement>();
        ArrayList<IJavaCodeElement> cons = new ArrayList<IJavaCodeElement>();
        ArrayList<IJavaCodeElement> rest = new ArrayList<IJavaCodeElement>();
        boolean inMethods = false;
        for (IJavaCodeElement e : result) {
            if (e.isConstructor()) {
                inMethods = true;
                cons.add(e);
                continue;
            }
            if (e.isMethod()) {
                inMethods = true;
                rest.add(e);
                continue;
            }
            if (e.isInitializer()) {
                init.add(e);
                continue;
            }
            if (!inMethods || e.isAttribute()) {
                before.add(e);
                continue;
            }
            inMethods = true;
            rest.add(e);
        }
        IJavaCodeElement.sort(rest, methodComparator);
        result.clear();
        result.addAll(before);
        result.addAll(init);
        result.addAll(cons);
        result.addAll(rest);
        ProxyElement.unproxy(result);
        return result;
    }

    protected void storeAtBlockStart(CodeWriter out) {
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + ": " + this.getName();
    }

    @Override
    public IJavaCodeElement getParent() {
        return this.enclosing;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        JavaCodeClass.setParent(parent, p -> {
            JavaCodeClass javaCodeClass = this.enclosing = p;
        });
    }

    static void setParent(IJavaCodeElement parent, Consumer<JavaCodeClass> consumer) {
        IJavaCodeElement.setParent(JavaCodeClass.getParentCodeClass(parent), JavaCodeClass.class, consumer);
    }

    static JavaCodeClass getParentCodeClass(IJavaCodeElement element) {
        IJavaCodeElement iter = element;
        if (element != null && !(element instanceof JavaCodeClass)) {
            iter = element.getParent();
            while (iter != null && !(iter instanceof JavaCodeClass)) {
                iter = iter.getParent();
            }
        }
        return iter instanceof JavaCodeClass ? (JavaCodeClass)iter : null;
    }

    protected int getElementsCount() {
        return this.elements.size();
    }

    private static enum ElementSorting {
        NONE,
        CONS,
        CONS_ALPHA;

    }

    public static enum Kind {
        CLASS("class"),
        INTERFACE("interface"),
        ANNOTATION("@interface"),
        ENUM("enum");

        private String keyword;

        private Kind(String keyword) {
            this.keyword = keyword;
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

