/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeImport;

public class JavaCodeImport
implements IJavaCodeImport {
    public static final JavaCodeImport DEFAULT = new JavaCodeImport();
    private boolean isStatic;
    private String name;
    private IJavaCodeArtifact artifact;
    private boolean isWildcard;

    private JavaCodeImport() {
        this.name = "java.lang";
    }

    JavaCodeImport(String name, IJavaCodeArtifact artifact) {
        this(name, artifact, false);
    }

    JavaCodeImport(String name, IJavaCodeArtifact artifact, boolean isStatic) {
        this.name = name;
        this.artifact = artifact;
        this.isWildcard = name.endsWith("*");
        this.isStatic = isStatic;
        artifact.registerImport(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        String result = this.name;
        int pos = result.lastIndexOf(46);
        if (pos > 0) {
            result = result.substring(pos + 1);
        }
        return result;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setStatic() {
        this.setStatic(true);
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    @Invisible
    public IJavaCodeArtifact getArtifact() {
        return this.artifact;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        out.printwi("import ");
        if (this.isStatic) {
            out.print("static ");
        }
        out.println(this.name + ";");
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + ": " + this.getName();
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcard;
    }

    @Override
    public IJavaCodeElement getParent() {
        return null;
    }

    @Override
    public void setParent(IJavaCodeElement parent) {
    }
}

