/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParsedExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStatement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTextExpression;

public class JavaCodeLambdaExpression
extends JavaCodeParsedExpression {
    private List<String> variables;
    private JavaCodeExpression expression;
    private JavaCodeBlock block;

    protected JavaCodeLambdaExpression(IJavaCodeElement parent) {
        super(parent);
    }

    public static JavaCodeLambdaExpression create() {
        return JavaCodeLambdaExpression.create(null);
    }

    public static JavaCodeLambdaExpression create(String variable) {
        JavaCodeLambdaExpression result = new JavaCodeLambdaExpression(null);
        result.addVariable(variable);
        return result;
    }

    @OperationMeta(name={"addVariable", "var"})
    public JavaCodeLambdaExpression addVariable(String variable) {
        if (variable != null && variable.length() > 0) {
            if (this.variables == null) {
                this.variables = new ArrayList<String>();
            }
            if (!this.variables.contains(variable)) {
                this.variables.add(variable);
            }
        }
        return this;
    }

    @OperationMeta(name={"addVariables", "vars"})
    public JavaCodeLambdaExpression addVariables(String variables) {
        if (variables != null && variables.length() > 0) {
            String[] stringArray = variables.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                this.addVariable(v);
                ++n2;
            }
        }
        return this;
    }

    @OperationMeta(name={"addAsExpression", "asExpr"})
    public JavaCodeLambdaExpression addAsExpression(JavaCodeElement element) {
        if (element instanceof JavaCodeExpression) {
            this.addExpression((JavaCodeExpression)element);
        } else if (element instanceof JavaCodeBlock) {
            this.setBlock((JavaCodeBlock)element);
        } else if (element instanceof JavaCodeStatement) {
            this.setBlock(JavaCodeBlock.create().add((JavaCodeStatement)element));
        }
        return this;
    }

    @OperationMeta(name={"addExpression", "expr"})
    public JavaCodeLambdaExpression addExpression(JavaCodeExpression expression) {
        this.expression = expression;
        return this;
    }

    @OperationMeta(name={"addExpression", "expr"})
    public JavaCodeLambdaExpression addExpression(String expression) {
        this.expression = new JavaCodeTextExpression(this, expression);
        return this;
    }

    @OperationMeta(name={"addBlock", "block"})
    public JavaCodeBlock addBlock() {
        this.block = new JavaCodeBlock(this.getParent(), false, false, false, true, true);
        return this.block;
    }

    public JavaCodeLambdaExpression setBlock(JavaCodeBlock block) {
        this.block = block;
        return this;
    }

    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName) {
        return this.addCall(methodName, JavaCodeImportScope.NONE);
    }

    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName, JavaCodeImportScope scope) {
        this.expression = new JavaCodeMethodCall(this, methodName, scope, false, "");
        return (JavaCodeMethodCall)this.expression;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        JavaCodeLambdaExpression.setParent(this.expression, parent);
        JavaCodeLambdaExpression.setParent(this.block, parent);
    }

    @Override
    public void store(CodeWriter out) {
        if (this.variables == null) {
            out.print("()");
        } else {
            if (this.variables.size() > 1) {
                out.print("(");
            }
            out.print(IJavaCodeElement.toList(this.variables, ","));
            if (this.variables.size() > 1) {
                out.print(")");
            }
        }
        out.print(" -> ");
        if (this.block != null) {
            this.block.store(out);
        } else if (this.expression != null) {
            this.expression.store(out);
        }
    }

    @Override
    public JavaCodeLambdaExpression replaceVariable(String oldName, String newName) {
        if (this.block != null) {
            this.block.replaceVariable(oldName, newName);
        }
        if (this.expression != null) {
            this.expression.replaceVariable(oldName, newName);
        }
        if (this.variables != null) {
            int v = 0;
            while (v < this.variables.size()) {
                if (this.variables.get(v).equals(oldName)) {
                    this.variables.set(v, newName);
                }
                ++v;
            }
        }
        return this;
    }

    @Override
    public JavaCodeLambdaExpression replaceMethod(String oldName, String newName) {
        if (this.block != null) {
            this.block.replaceVariable(oldName, newName);
        }
        if (this.expression != null) {
            this.expression.replaceVariable(oldName, newName);
        }
        return this;
    }
}

