/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.AST2ArtifactVisitor;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAbstractVisibleElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAlternative;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotation;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAssignment;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlockInterface;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeDoLoop;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpressionStatement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeForLoop;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeJavadocComment;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParameterSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStatement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeSwitch;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeSynchronizedBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeThrow;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTryBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVariableDeclaration;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibility;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVisibleElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeWhileLoop;

public class JavaCodeMethod
extends JavaCodeAbstractVisibleElement
implements JavaCodeBlockInterface {
    private JavaCodeTypeSpecification type;
    private JavaCodeClass enclosing;
    private JavaCodeBlock block;
    private List<JavaCodeParameterSpecification> parameter;
    private List<JavaCodeTypeSpecification> exceptions;
    private boolean forceJavadoc;
    private boolean dflt;
    private List<String> generics;
    private boolean isSynchronized;
    private JavaCodeExpression dfltEx;

    protected JavaCodeMethod(String name, JavaCodeClass enclosing) {
        this(JavaCodeTypeSpecification.VOID, name, enclosing);
    }

    protected JavaCodeMethod(JavaCodeTypeSpecification type, String name, JavaCodeClass enclosing) {
        this(type, name, enclosing, null);
    }

    protected JavaCodeMethod(JavaCodeTypeSpecification type, String name, JavaCodeClass enclosing, String comment) {
        super(name, JavaCodeVisibility.PUBLIC, comment);
        this.enclosing = enclosing;
        this.type = type;
        this.block = new JavaCodeBlock(this, true, true);
    }

    public static JavaCodeMethod create() {
        return new JavaCodeMethod("", null);
    }

    @Invisible
    @Conversion
    public static JavaCodeMethod convert(Object text) throws VilException {
        JavaCodeMethod result = null;
        Object tmp = IVilType.convertVilValue((Object)text);
        if (tmp != null) {
            result = JavaCodeMethod.create(text.toString(), AST2ArtifactVisitor.vilExceptionConsumer());
        }
        return result;
    }

    private static JavaCodeMethod create(String text, AST2ArtifactVisitor.ProblemConsumer problemConsumer) throws VilException {
        return AST2ArtifactVisitor.parseCompilationUnit(text, problemConsumer).getMethod();
    }

    public static JavaCodeMethod create(String text) throws VilException {
        return JavaCodeMethod.create(text, AST2ArtifactVisitor.logConsumer());
    }

    public JavaCodeMethod setType(String type) {
        this.type = JavaCodeTypeSpecification.create(type, this.getClassParent());
        return this;
    }

    @Override
    @Invisible
    public IJavaCodeArtifact getArtifact() {
        return this.enclosing == null ? null : this.enclosing.getArtifact();
    }

    @Override
    @Invisible
    public JavaCodeClass getEnclosing() {
        return this.enclosing;
    }

    @OperationMeta(name={"addGeneric", "generic"})
    public JavaCodeMethod addGeneric(String generic, String comment) {
        if (generic != null && generic.length() > 0) {
            if (this.generics == null) {
                this.generics = new ArrayList<String>();
            }
            if ((generic = generic.trim()).startsWith("<")) {
                generic = generic.substring(1);
            }
            if (generic.endsWith(">")) {
                generic = generic.substring(0, generic.length() - 1);
            }
            JavaCodeTypeSpecification tmp = new JavaCodeTypeSpecification(generic, this);
            this.generics.add(generic);
            if (comment != null && comment.length() > 0) {
                this.getJavadocComment().addGenericComment(tmp.getOutputTypeName(), comment);
            }
        }
        return this;
    }

    public JavaCodeMethod setJavadocComment(String comment) {
        this.getJavadocComment().setComment(comment);
        return this;
    }

    public JavaCodeMethod addToJavadocComment(String comment) {
        JavaCodeJavadocComment c = this.getJavadocComment();
        c.setComment(c.getComment() + comment);
        return this;
    }

    @OperationMeta(name={"addOverrideAnnotation", "override"})
    public JavaCodeAnnotation addOverrideAnnotation() {
        return this.addAnnotation(Override.class.getSimpleName());
    }

    @OperationMeta(name={"addSuppressWarningsUncheckedAnnotation", "suppressUnchecked"})
    public JavaCodeAnnotation addSuppressWarningsUncheckedAnnotation() {
        return this.addSuppressWarningsAnnotation().addStringArgument("unchecked");
    }

    @OperationMeta(name={"addJunitTestAnnotation", "junitTest"})
    public JavaCodeAnnotation addJunitTestAnnotation() {
        return this.addAnnotation("org.junit.Test");
    }

    @OperationMeta(name={"addJunitAssertCall", "junitAssert"})
    public JavaCodeMethodCall addJunitAssertCall(String methodName) {
        return this.block.addJunitAssertCall(methodName);
    }

    @OperationMeta(name={"addJunitBeforeAnnotation", "junitBefore"})
    public JavaCodeAnnotation addJunitBeforeAnnotation() {
        return this.addAnnotation("org.junit.Before");
    }

    @OperationMeta(name={"addJunitAfterAnnotation", "junitAfter"})
    public JavaCodeAnnotation addJunitAfterAnnotation() {
        return this.addAnnotation("org.junit.After");
    }

    @OperationMeta(name={"addParameter", "param"})
    public JavaCodeParameterSpecification addParameter(String type, String name) {
        return this.addParameter(type, name, null);
    }

    @OperationMeta(name={"addParameter", "param"})
    public JavaCodeParameterSpecification addParameter(String type, String name, String comment) {
        return this.addParameter(new JavaCodeParameterSpecification(type, name, this), comment);
    }

    JavaCodeParameterSpecification addParameter(JavaCodeParameterSpecification param, String comment) {
        if (this.parameter == null) {
            this.parameter = new ArrayList<JavaCodeParameterSpecification>();
        }
        if (comment != null && this.getJavadocComment() != null) {
            this.getJavadocComment().addParameterComment(param.getName(), comment);
        }
        return IJavaCodeElement.add(this.parameter, param);
    }

    JavaCodeParameterSpecification addParameter(JavaCodeTypeSpecification type, String name, String comment) {
        if (this.parameter == null) {
            this.parameter = new ArrayList<JavaCodeParameterSpecification>();
        }
        if (comment != null && this.getJavadocComment() != null) {
            this.getJavadocComment().addParameterComment(name, comment);
        }
        return IJavaCodeElement.add(this.parameter, new JavaCodeParameterSpecification(type, name, this));
    }

    @OperationMeta(name={"addException", "addThrows", "throws"})
    public JavaCodeTypeSpecification addException(String type) {
        return this.addException(type, null);
    }

    @OperationMeta(name={"addException", "addThrows", "throws"})
    public JavaCodeTypeSpecification addException(String type, String comment) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<JavaCodeTypeSpecification>();
        }
        JavaCodeTypeSpecification typeSpec = new JavaCodeTypeSpecification(type, this.getEnclosing());
        if (comment != null && this.getJavadocComment() != null) {
            this.getJavadocComment().addExceptionComment(typeSpec.getOutputTypeName(), comment);
        }
        return IJavaCodeElement.add(this.exceptions, typeSpec);
    }

    @Override
    public JavaCodeMethod add(String text) {
        this.block.add(text);
        return this;
    }

    @Override
    @OperationMeta(name={"addAsStatement", "statement"})
    public JavaCodeMethod addAsStatement(String text) {
        this.block.addAsStatement(text);
        return this;
    }

    @Override
    public JavaCodeMethod add(JavaCodeStatement stmt) {
        this.block.add(stmt);
        return this;
    }

    @Override
    public JavaCodeMethod add(JavaCodeExpression expr) {
        this.block.add(expr);
        return this;
    }

    @Override
    public JavaCodeMethod addRaw(String text, boolean indent) {
        this.block.addRaw(text, indent);
        return this;
    }

    @Override
    @OperationMeta(name={"addDoLoop", "do"})
    public JavaCodeDoLoop addDoLoop(String condition) {
        return this.block.addDoLoop(condition);
    }

    @Override
    @OperationMeta(name={"addWhileLoop", "while"})
    public JavaCodeWhileLoop addWhileLoop(String condition) {
        return this.block.addWhileLoop(condition);
    }

    @Override
    @OperationMeta(name={"addForLoop", "for"})
    public JavaCodeForLoop addForLoop(String type, String variableName, String expression) {
        return this.block.addForLoop(type, variableName, expression);
    }

    JavaCodeForLoop addForLoop(JavaCodeTypeSpecification type, String variableName, String expression) {
        return this.block.addForLoop(type, variableName, expression);
    }

    @Override
    @OperationMeta(name={"addForLoop", "for"})
    public JavaCodeForLoop addForLoop(String type, String variableName, String initializer, String condition, String update) {
        return this.block.addForLoop(type, variableName, initializer, condition, update);
    }

    JavaCodeForLoop addForLoop(JavaCodeTypeSpecification type, String variableName, String initializer, String condition, String update) {
        return this.block.addForLoop(type, variableName, initializer, condition, update);
    }

    @Override
    @OperationMeta(name={"addIf", "if"})
    public JavaCodeAlternative addIf(String condition) {
        return this.block.addIf(condition);
    }

    @Override
    @OperationMeta(name={"addThrow", "throw"})
    public JavaCodeThrow addThrow(JavaCodeExpression expression) {
        return this.block.addThrow(expression);
    }

    @Override
    @OperationMeta(name={"addSwitch", "switch"})
    public JavaCodeSwitch addSwitch(JavaCodeExpression expression) {
        return this.block.addSwitch(expression);
    }

    @Override
    @OperationMeta(name={"addSynchronized", "synchronized"})
    public JavaCodeSynchronizedBlock addSynchronized(JavaCodeExpression objEx) {
        return this.block.addSynchronized(objEx);
    }

    @Override
    @OperationMeta(name={"addTry", "try"})
    public JavaCodeTryBlock addTry() {
        return this.block.addTry();
    }

    @Override
    public JavaCodeExpressionStatement addPostfixIncrement(String variable) {
        return this.block.addPostfixIncrement(variable);
    }

    @Override
    public JavaCodeExpressionStatement addPostfixDecrement(String variable) {
        return this.block.addPostfixDecrement(variable);
    }

    @Override
    @OperationMeta(name={"addAssignment", "addAssign", "assign"})
    public JavaCodeAssignment addAssignment(String variable) {
        return this.block.addAssignment(variable);
    }

    @Override
    @OperationMeta(name={"addAssignment", "addAssign", "assign"})
    public JavaCodeAssignment addAssignment(String variable, JavaCodeExpression expression) {
        return this.block.addAssignment(variable, expression);
    }

    @Override
    @OperationMeta(name={"addAssignment", "addAssign", "assign"})
    public JavaCodeAssignment addAssignment(String variable, String operator, JavaCodeExpression expression) {
        return this.block.addAssignment(variable, operator, expression);
    }

    @Override
    @OperationMeta(name={"addEmptyLine", "emptyLine"})
    public JavaCodeMethod addEmptyLine() {
        this.block.addEmptyLine();
        return this;
    }

    @Override
    @OperationMeta(name={"addSLComment", "SLComment"})
    public JavaCodeMethod addSLComment(String text) {
        this.block.addSLComment(text);
        return this;
    }

    @Override
    @OperationMeta(name={"addSuperCall", "super"})
    public JavaCodeMethodCall addSuperCall() {
        return this.block.addSuperCall();
    }

    @Override
    @OperationMeta(name={"addThisCall", "this"})
    public JavaCodeMethodCall addThisCall() {
        return this.block.addThisCall();
    }

    @Override
    @OperationMeta(name={"addSystemOutPrintlnCall", "SystemOutPrintln", "sysoutprintln"})
    public JavaCodeMethodCall addSystemOutPrintlnCall() {
        return this.block.addSystemOutPrintlnCall();
    }

    @Override
    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName) {
        return this.block.addCall(methodName);
    }

    @Override
    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName, JavaCodeImportScope scope) {
        return this.block.addCall(methodName, scope);
    }

    @Override
    @OperationMeta(name={"callQualified"})
    public JavaCodeMethodCall addCallQualified(String methodName) {
        return this.block.addCallQualified(methodName);
    }

    @Override
    @OperationMeta(name={"addVariable", "var"})
    public JavaCodeVariableDeclaration addVariable(String type, String variableName, JavaCodeExpression initializer) {
        return this.block.addVariable(type, variableName, initializer);
    }

    JavaCodeVariableDeclaration addVariable(JavaCodeTypeSpecification type, String variableName, JavaCodeExpression initializer) {
        return this.block.addVariable(type, variableName, initializer);
    }

    @Override
    @OperationMeta(name={"addVariable", "var"})
    public JavaCodeVariableDeclaration addVariable(String type, String variableName, boolean isFinal, JavaCodeExpression initializer) {
        return this.block.addVariable(type, variableName, isFinal, initializer);
    }

    JavaCodeVariableDeclaration addVariable(JavaCodeTypeSpecification type, String variableName, boolean isFinal, JavaCodeExpression initializer) {
        return this.block.addVariable(type, variableName, isFinal, initializer);
    }

    @Override
    public JavaCodeVariableDeclaration createVariable(String type, String variableName, JavaCodeExpression initializer) {
        return this.block.createVariable(type, variableName, false, initializer);
    }

    @Override
    public JavaCodeVariableDeclaration createVariable(String type, String variableName, boolean isFinal, JavaCodeExpression initializer) {
        return this.block.createVariable(type, variableName, isFinal, initializer);
    }

    @OperationMeta(name={"addBreak", "break"})
    public JavaCodeMethod addBreak() {
        this.block.addBreak();
        return this;
    }

    @OperationMeta(name={"addContinue", "continue"})
    public JavaCodeMethod addContinue() {
        this.block.addContinue();
        return this;
    }

    @OperationMeta(name={"addReturn", "return"})
    public JavaCodeMethod addReturn(JavaCodeExpression valueEx) {
        return this.addReturn(valueEx, null);
    }

    @OperationMeta(name={"addReturnClass", "returnClass"})
    public JavaCodeMethod addReturnClass(String cls) {
        return this.addReturnClass(cls, null);
    }

    @OperationMeta(name={"addReturnClass", "returnClass"})
    public JavaCodeMethod addReturnClass(String cls, String comment) {
        JavaCodeTypeSpecification type = JavaCodeTypeSpecification.toClassType(cls, this);
        if (type != null) {
            this.addReturn(new JavaCodeTypeExpression(this, type), null);
        }
        return this;
    }

    @OperationMeta(name={"addReturn", "return"})
    public JavaCodeMethod addReturn(JavaCodeExpression valueEx, String comment) {
        valueEx.setParent(this);
        this.block.addReturn(valueEx);
        if (comment != null) {
            this.ensureJavadocComment("");
            this.getJavadocComment().addReturnComment(comment);
        }
        return this;
    }

    @OperationMeta(name={"addBlock", "block"})
    public JavaCodeBlock addBlock(boolean outputWhitespaceBefore, boolean outputLnAfter, boolean isStatic, boolean withBrackets) {
        return this.block.addBlock(outputWhitespaceBefore, outputLnAfter, isStatic, withBrackets);
    }

    @OperationMeta(name={"addBlock", "block"})
    public JavaCodeBlock addBlock(JavaCodeBlock block) {
        return block.addBlock(block);
    }

    @Override
    @Invisible
    public void transferElementsTo(JavaCodeBlockInterface block) {
        block.transferElementsTo(this);
    }

    @Override
    @Invisible
    public void add(IJavaCodeElement element) {
        this.block.add(element);
    }

    @Override
    public JavaCodeMethod addAll(JavaCodeBlockInterface block) {
        this.block.addAll(block);
        return this;
    }

    @Override
    public JavaCodeMethod parse(String text) throws VilException {
        this.block.parse(text);
        return this;
    }

    public JavaCodeMethod setBlock(JavaCodeBlock block) {
        block.setBlock(block);
        return this;
    }

    public JavaCodeMethod forceJavadoc() {
        this.forceJavadoc = true;
        return this;
    }

    @Override
    protected boolean enableStoreComment() {
        return this.forceJavadoc || !this.hasAnnotation(Override.class.getSimpleName(), Override.class.getName());
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        boolean signatureOnly;
        boolean enclosingIsAnnotation;
        super.store(out);
        out.printwi(this.getModifier());
        boolean enclosingIsInterface = this.enclosing != null && this.enclosing.getKind() == JavaCodeClass.Kind.INTERFACE;
        boolean bl = enclosingIsAnnotation = this.enclosing != null && this.enclosing.getKind() == JavaCodeClass.Kind.ANNOTATION;
        if (!this.isConstructor()) {
            if (this.isSynchronized) {
                out.print("synchronized");
                out.print(" ");
            }
            if (enclosingIsInterface && this.isDefault()) {
                out.print("default");
                out.print(" ");
            }
            if (this.generics != null) {
                out.print("<");
                out.print(IJavaCodeElement.toList(this.generics, ", "));
                out.print("> ");
            }
            if (this.type != null) {
                this.type.store(out);
                out.print(" ");
            }
        }
        out.print(this.getName());
        out.print("(");
        IJavaCodeElement.storeList(this.parameter, ", ", out);
        out.print(")");
        if (enclosingIsAnnotation && this.dfltEx != null) {
            out.print(" default ");
            this.dfltEx.store(out);
        }
        IJavaCodeElement.storeList(" throws ", this.exceptions, ", ", out);
        boolean bl2 = signatureOnly = this.isAbstract() || enclosingIsInterface && (!this.isDefault() || !this.isStatic());
        if (signatureOnly |= enclosingIsAnnotation) {
            out.println(";");
        } else {
            this.block.store(out);
        }
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + ": " + this.getName();
    }

    @Override
    @OperationMeta(name={"setVisibility", "visibility"})
    public JavaCodeMethod setVisibility(String visibility) {
        super.setVisibility(visibility);
        return this;
    }

    @Override
    @OperationMeta(name={"setVisibility", "visibility"})
    public JavaCodeMethod setVisibility(JavaCodeVisibility visibility) {
        super.setVisibility(visibility);
        return this;
    }

    @Override
    @OperationMeta(name={"setPublic", "public"})
    public JavaCodeMethod setPublic() {
        super.setPublic();
        return this;
    }

    @Override
    @OperationMeta(name={"setPrivate", "private"})
    public JavaCodeMethod setPrivate() {
        super.setPrivate();
        return this;
    }

    @Override
    @OperationMeta(name={"setProtected", "protected"})
    public JavaCodeMethod setProtected() {
        super.setProtected();
        return this;
    }

    @Override
    @OperationMeta(name={"setPackage", "package"})
    public JavaCodeMethod setPackage() {
        super.setPackage();
        return this;
    }

    @Override
    @OperationMeta(name={"setStatic", "static"})
    public JavaCodeMethod setStatic(boolean isStatic) {
        super.setStatic(isStatic);
        return this;
    }

    @Override
    @OperationMeta(name={"setStatic", "static"})
    public JavaCodeMethod setStatic() {
        super.setStatic();
        return this;
    }

    @OperationMeta(name={"setSynchronized", "synchronized"})
    public JavaCodeVisibleElement setSynchronized() {
        this.setSynchronized(true);
        return this;
    }

    @OperationMeta(name={"setSynchronized", "synchronized"})
    public JavaCodeVisibleElement setSynchronized(boolean isSynchronized) {
        this.isSynchronized = isSynchronized;
        return this;
    }

    @Override
    public IJavaCodeElement getParent() {
        return this.enclosing;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        JavaCodeClass.setParent(parent, p -> {
            JavaCodeClass javaCodeClass = this.enclosing = p;
        });
        if (this.exceptions != null) {
            this.exceptions.forEach(e -> {
                e.setParent(this);
                if (this.getJavadocComment() != null) {
                    this.getJavadocComment().adjustException((JavaCodeTypeSpecification)e);
                }
            });
        }
        if (this.parameter != null) {
            this.parameter.forEach(p -> p.setParent(this));
        }
        if (this.block != null) {
            this.block.setParent(this);
        }
    }

    @Override
    public boolean isConstructor() {
        return this.type == null;
    }

    @Override
    public boolean isMethod() {
        return this.type != null;
    }

    public JavaCodeMethod addDefault(JavaCodeExpression expr) {
        this.dfltEx = expr;
        return this;
    }

    @OperationMeta(name={"setDefault", "dflt"})
    public void setDefault() {
        this.dflt = true;
    }

    @OperationMeta(name={"setDefault", "dflt"})
    public void setDefault(boolean isDefault) {
        this.dflt = isDefault;
    }

    public boolean isDefault() {
        return this.dflt;
    }

    public JavaCodeBlock getBlock() {
        return this.block;
    }

    public JavaCodeMethod deleteParameter(String name) {
        this.parameter.removeIf(p -> p.getName().equals(name));
        this.getJavadocComment().deleteParameterComment(name);
        return this;
    }
}

