/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeArgumentListExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeCallElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeConstructorCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeNewArrayExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParameterSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeQualifiableElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTextExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVariableDeclaration;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVariableExpression;

public class JavaCodeMethodCall
extends JavaCodeArgumentListExpression
implements JavaCodeCallElement,
JavaCodeQualifiableElement {
    private String methodName;
    private boolean indent;
    private String postfix;
    private JavaCodeMethodCall chained;
    private JavaCodeImportScope scope;
    private IJavaCodeElement qualification;

    public JavaCodeMethodCall(IJavaCodeElement parent, String methodName, JavaCodeImportScope scope, boolean indent, String postfix) {
        this(parent, null, methodName, scope, indent, postfix);
    }

    public JavaCodeMethodCall(IJavaCodeElement parent, IJavaCodeElement qualification, String methodName, JavaCodeImportScope scope, boolean indent, String postfix) {
        super(parent);
        this.scope = scope;
        this.methodName = this.validateName(parent, methodName, scope);
        this.indent = indent;
        this.postfix = postfix;
        this.qualification = qualification;
    }

    public static JavaCodeMethodCall create(String methodName) {
        return JavaCodeMethodCall.create(methodName, JavaCodeImportScope.NONE);
    }

    public static JavaCodeMethodCall create(JavaCodeVariableDeclaration qualification, String methodName) {
        return JavaCodeMethodCall.create(qualification, methodName, JavaCodeImportScope.NONE);
    }

    public static JavaCodeMethodCall create(IJavaCodeElement qualification, String methodName) {
        return JavaCodeMethodCall.create(qualification, methodName, JavaCodeImportScope.NONE);
    }

    public static JavaCodeMethodCall create(String methodName, JavaCodeImportScope scope) {
        return JavaCodeMethodCall.create(null, methodName, scope);
    }

    public static JavaCodeMethodCall create(JavaCodeVariableDeclaration qualification, String methodName, JavaCodeImportScope scope) {
        return JavaCodeMethodCall.create((IJavaCodeElement)qualification, methodName, scope);
    }

    public static JavaCodeMethodCall create(IJavaCodeElement qualification, String methodName, JavaCodeImportScope scope) {
        return new JavaCodeMethodCall(null, qualification, methodName, scope, false, "");
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected String validateName(IJavaCodeElement parent, String methodName, JavaCodeImportScope scope) {
        String result = methodName;
        if (parent != null && JavaCodeImportScope.NONE != scope && methodName.contains(".") && parent.getArtifact() != null) {
            result = parent.getArtifact().validateStaticName(methodName, scope);
        }
        return result;
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeMethodCall addArgument(Object arg) {
        return (JavaCodeMethodCall)super.addArgument(arg);
    }

    @Override
    public JavaCodeMethodCall addNullArgument() {
        return (JavaCodeMethodCall)super.addArgument("null");
    }

    @Override
    @OperationMeta(name={"addStringArgument", "stringArg"})
    public JavaCodeMethodCall addStringArgument(String val) {
        return (JavaCodeMethodCall)super.addStringArgument(val);
    }

    @Override
    @OperationMeta(name={"addStringArgumentNotEmpty", "stringArgNotEmpty"})
    public JavaCodeMethodCall addStringArgumentNotEmpty(String val) {
        return (JavaCodeMethodCall)super.addStringArgumentNotEmpty(val);
    }

    @Override
    @OperationMeta(name={"addClassArgument", "classArg"})
    public JavaCodeMethodCall addClassArgument(String cls) {
        return (JavaCodeMethodCall)super.addClassArgument(cls);
    }

    @Override
    public JavaCodeMethodCall addThisArgument() {
        return (JavaCodeMethodCall)super.addThisArgument();
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeMethodCall addArgument(String arg) {
        return (JavaCodeMethodCall)super.addArgument(arg);
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeMethodCall addArgument(JavaCodeExpression ex) {
        return (JavaCodeMethodCall)super.addArgument(ex);
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeMethodCall addArgument(JavaCodeVariableDeclaration var) {
        return (JavaCodeMethodCall)super.addArgument(var);
    }

    @Override
    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeMethodCall addArgument(JavaCodeParameterSpecification param) {
        return (JavaCodeMethodCall)super.addArgument(param);
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        this.methodName = this.validateName(parent, this.methodName, this.scope);
        JavaCodeMethodCall.setParent(this.qualification, this);
        JavaCodeMethodCall.setParent(this.chained, this);
    }

    @Override
    @OperationMeta(name={"addConstantArgument", "constArg"})
    public JavaCodeMethodCall addConstantArgument(String arg) {
        return (JavaCodeMethodCall)super.addConstantArgument(arg);
    }

    public JavaCodeMethodCall addCallArgumentNoArg(String methodName) {
        this.addCallArgument(methodName);
        return this;
    }

    public JavaCodeMethodCall addCallArgument(String methodName) {
        return this.addCallArgument(methodName, JavaCodeImportScope.NONE);
    }

    public JavaCodeMethodCall addCallArgument(String methodName, JavaCodeImportScope scope) {
        return this.addArgument(methodName, scope);
    }

    @OperationMeta(name={"addArgument", "arg"})
    public JavaCodeMethodCall addArgument(String methodName, JavaCodeImportScope scope) {
        return this.addArgumentImpl(new JavaCodeMethodCall(this, methodName, scope, false, ""));
    }

    @OperationMeta(name={"addNewArgument", "newArg"})
    public JavaCodeConstructorCall addNewArgument(String cls) {
        return this.addArgumentImpl(new JavaCodeConstructorCall(this, cls, false, ""));
    }

    @OperationMeta(name={"addNewArrayArgument", "newArrayArg"})
    public JavaCodeNewArrayExpression addNewArrayArgument(String type) {
        return this.addArgumentImpl(new JavaCodeNewArrayExpression(this, type));
    }

    public JavaCodeVariableExpression addVariableArgument(String variableName, JavaCodeImportScope scope) {
        variableName = this.validateName(this, variableName, scope);
        return this.addArgumentImpl(new JavaCodeVariableExpression((IJavaCodeElement)this, variableName));
    }

    public JavaCodeConstructorCall addNew(String cls) {
        return this.addArgumentImpl(new JavaCodeConstructorCall(this, cls, false, ""));
    }

    @Override
    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName) {
        return this.addCall(methodName, JavaCodeImportScope.NONE);
    }

    @Override
    @OperationMeta(name={"callQualified"})
    public JavaCodeMethodCall addCallQualified(String methodName) {
        return this.addCall(methodName, JavaCodeImportScope.METHOD_CLASS_IMPORT);
    }

    @Override
    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName, JavaCodeImportScope scope) {
        JavaCodeMethodCall result = new JavaCodeMethodCall(this, methodName, scope, false, this.postfix);
        if (this.chained == null) {
            this.chained = result;
            this.postfix = System.lineSeparator();
        } else {
            JavaCodeMethodCall last = this.chained;
            while (last.chained != null) {
                last = last.chained;
            }
            last.chained = result;
            result.postfix = last.postfix;
            last.postfix = System.lineSeparator();
        }
        return result;
    }

    @Override
    public JavaCodeMethodCall qualifiedBy(String qualification) {
        this.qualification = new JavaCodeTextExpression(this, qualification);
        return this;
    }

    @Override
    public JavaCodeMethodCall qualifiedByType(String type) {
        this.qualification = new JavaCodeTypeSpecification(type, this);
        return this;
    }

    @Override
    public JavaCodeMethodCall qualifiedBy(JavaCodeVariableDeclaration var) {
        this.qualification = new JavaCodeVariableExpression((IJavaCodeElement)this, var);
        return this;
    }

    @Override
    public void store(CodeWriter out) {
        if (this.indent) {
            out.printIndent();
        }
        this.storeBefore(out);
        out.print(this.methodName);
        this.storeAfterName(out);
        this.storeArgumentList(out);
        if (this.chained != null) {
            out.printIndent();
            out.printIndentStep();
            out.print(".");
            this.chained.store(out);
        }
    }

    protected void storeBefore(CodeWriter out) {
        if (this.qualification != null) {
            this.qualification.storeAsQualifier(out);
            out.print(".");
        }
    }

    protected void storeAfterName(CodeWriter out) {
    }

    @Override
    protected void storeArgumentList(CodeWriter out) {
        out.print("(");
        super.storeArgumentList(out);
        out.print(")" + this.postfix);
    }

    @Override
    public JavaCodeMethodCall replaceVariable(String oldName, String newName) {
        if (this.qualification != null) {
            this.qualification.replaceVariable(oldName, newName);
        }
        if (this.methodName.startsWith(oldName + ".")) {
            int pos = this.methodName.indexOf(46);
            this.methodName = newName + this.methodName.substring(pos);
        }
        super.replaceVariable(oldName, newName);
        return this;
    }

    @Override
    public JavaCodeMethodCall replaceMethod(String oldName, String newName) {
        if (this.qualification != null) {
            this.qualification.replaceMethod(oldName, newName);
        }
        if (this.chained != null) {
            this.chained.replaceMethod(oldName, newName);
        }
        if (this.methodName.equals(oldName)) {
            this.methodName = newName;
        } else if (this.methodName.endsWith("." + oldName)) {
            int pos = this.methodName.lastIndexOf(46);
            this.methodName = this.methodName.substring(pos + 1) + newName;
        }
        super.replaceMethod(oldName, newName);
        return this;
    }
}

