/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStringExpression;

public class JavaCodeSwitch
extends JavaCodeBlock {
    private JavaCodeExpression expression;

    public JavaCodeSwitch(IJavaCodeElement parent, JavaCodeExpression expression) {
        super(parent, true, false);
        this.expression = expression;
    }

    @OperationMeta(name={"addStringCase", "stringCase"})
    public JavaCodeBlock addStringCase(String expression, boolean asBlock, boolean withClosingBreak) {
        return this.add(new JavaCodeCaseBlock(this.getParent(), new JavaCodeStringExpression((IJavaCodeElement)this, expression), asBlock, withClosingBreak), this.caseAddPosition());
    }

    @OperationMeta(name={"addCase", "case"})
    public JavaCodeBlock addCase(JavaCodeExpression expression, boolean asBlock, boolean withClosingBreak) {
        return this.add(new JavaCodeCaseBlock(this.getParent(), expression, asBlock, withClosingBreak), this.caseAddPosition());
    }

    private int caseAddPosition() {
        int size = this.getElementsSize();
        return this.elementsStream().anyMatch(c -> ((JavaCodeCaseBlock)c).isDefault()) ? size - 1 : size;
    }

    @OperationMeta(name={"addDefault", "dflt"})
    public JavaCodeBlock addDefault(boolean asBlock, boolean withClosingBreak) {
        return this.addElement(new JavaCodeCaseBlock(this.getParent(), null, asBlock, withClosingBreak));
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        out.printwi("switch (");
        this.expression.store(out);
        out.print(")");
        super.store(out);
        out.println();
    }

    public class JavaCodeCaseBlock
    extends JavaCodeBlock {
        private JavaCodeExpression expression;
        private boolean withClosingBreak;

        private JavaCodeCaseBlock(IJavaCodeElement parent, JavaCodeExpression expression, boolean withBrackets, boolean withClosingBreak) {
            super(parent, withBrackets, true, false, withBrackets);
            this.expression = expression;
            this.withClosingBreak = withClosingBreak;
        }

        @Override
        @Invisible
        public void store(CodeWriter out) {
            if (this.expression == null) {
                out.printwi("default:");
            } else {
                out.printwi("case ");
                this.expression.store(out);
                out.print(":");
            }
            if (!this.withBrackets()) {
                out.println();
            }
            super.store(out);
        }

        @Override
        protected void storeBeforeBlockEnd(CodeWriter out) {
            if (this.withClosingBreak) {
                out.printlnwi("break;");
            }
        }

        @Override
        @Invisible(inherit=true)
        public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
            return this.expression == null ? "JavaCodeDefault" : "JavaCodeCase";
        }

        public boolean isDefault() {
            return this.expression == null;
        }
    }
}

