/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;

public enum JavaCodeVisibility implements IVilType
{
    PUBLIC(null, "public", "+"),
    PROTECTED(null, "protected", "#"),
    PRIVATE(null, "private", "-"),
    PACKAGE("", "package", "~");

    private String keyword;
    private String[] name;

    private JavaCodeVisibility(String keyword, String ... name) {
        this.keyword = keyword == null && name.length > 0 ? name[0] : keyword;
        this.name = name;
    }

    public boolean matches(String text) {
        boolean matches = false;
        int i = 0;
        while (!matches && i < this.name.length) {
            matches = this.name[i].equals(text);
            ++i;
        }
        return matches;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getPrefix() {
        return this.keyword.length() > 0 ? this.keyword + " " : this.keyword;
    }

    public static JavaCodeVisibility match(String text) {
        return JavaCodeVisibility.match(text, PUBLIC);
    }

    public static JavaCodeVisibility match(String text, JavaCodeVisibility dflt) {
        JavaCodeVisibility result = dflt;
        JavaCodeVisibility[] javaCodeVisibilityArray = JavaCodeVisibility.values();
        int n = javaCodeVisibilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaCodeVisibility v = javaCodeVisibilityArray[n2];
            if (v.matches(text)) {
                result = v;
                break;
            }
            ++n2;
        }
        return result;
    }
}

