/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.lxc.instantiators;

import au.com.jcloud.lxd.model.Image;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.lxc.instantiators.AbstractLxcInstantiator;

@Instantiator(value="lxcBuildImage")
public class LxcBuildImage
extends AbstractLxcInstantiator {
    public static String lxcBuildImage(Path baseDirectory, Path lxcTemplate, String imageName) throws VilException {
        String distrobuilderCmd = "distrobuilder build-lxd ";
        String flags = " --type=unified --import-into-lxd=";
        String templatePath = lxcTemplate.getAbsolutePath().toString();
        IInstantiatorTracer tracer = TracerFactory.getInstance().createInstantiatorTracerImpl();
        try {
            tracer.traceMessage("Building LXC image " + imageName + ". Please wait...");
            LxcBuildImage.createCmdClient().executeLinuxCmd("cd " + String.valueOf(baseDirectory) + " && sudo " + distrobuilderCmd + templatePath + flags + imageName);
            String imageFingerprint = ((Image)LxcBuildImage.createClient().loadImageMap().get(imageName)).getFingerprint();
            tracer.traceMessage("Building LXC image " + imageName + " completed: " + imageFingerprint);
            return imageFingerprint;
        }
        catch (Throwable e) {
            if (FAIL_ON_ERROR) {
                tracer.traceMessage("Building LXC image " + imageName + "failed: " + e.getMessage());
                throw new VilException(e.getMessage(), 50502);
            }
            return null;
        }
    }
}

