/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import de.uni_hildesheim.sse.ivml.ActualArgument;
import de.uni_hildesheim.sse.ivml.ActualArgumentList;
import de.uni_hildesheim.sse.ivml.AdditiveExpression;
import de.uni_hildesheim.sse.ivml.AdditiveExpressionPart;
import de.uni_hildesheim.sse.ivml.AssignmentExpression;
import de.uni_hildesheim.sse.ivml.AssignmentExpressionPart;
import de.uni_hildesheim.sse.ivml.Call;
import de.uni_hildesheim.sse.ivml.ContainerInitializer;
import de.uni_hildesheim.sse.ivml.ContainerOp;
import de.uni_hildesheim.sse.ivml.Declaration;
import de.uni_hildesheim.sse.ivml.Declarator;
import de.uni_hildesheim.sse.ivml.EqualityExpression;
import de.uni_hildesheim.sse.ivml.EqualityExpressionPart;
import de.uni_hildesheim.sse.ivml.Expression;
import de.uni_hildesheim.sse.ivml.ExpressionAccess;
import de.uni_hildesheim.sse.ivml.ExpressionListEntry;
import de.uni_hildesheim.sse.ivml.ExpressionListOrRange;
import de.uni_hildesheim.sse.ivml.ExpressionStatement;
import de.uni_hildesheim.sse.ivml.FeatureCall;
import de.uni_hildesheim.sse.ivml.IfExpression;
import de.uni_hildesheim.sse.ivml.ImplicationExpression;
import de.uni_hildesheim.sse.ivml.ImplicationExpressionPart;
import de.uni_hildesheim.sse.ivml.IvmlPackage;
import de.uni_hildesheim.sse.ivml.LetExpression;
import de.uni_hildesheim.sse.ivml.Literal;
import de.uni_hildesheim.sse.ivml.LogicalExpression;
import de.uni_hildesheim.sse.ivml.LogicalExpressionPart;
import de.uni_hildesheim.sse.ivml.MultiplicativeExpression;
import de.uni_hildesheim.sse.ivml.OptBlockExpression;
import de.uni_hildesheim.sse.ivml.PostfixExpression;
import de.uni_hildesheim.sse.ivml.PrimaryExpression;
import de.uni_hildesheim.sse.ivml.RelationalExpression;
import de.uni_hildesheim.sse.ivml.UnaryExpression;
import de.uni_hildesheim.sse.translation.AssignmentDetector;
import de.uni_hildesheim.sse.translation.RefByCheckVisitor;
import de.uni_hildesheim.sse.translation.TypeContext;
import de.uni_hildesheim.sse.translation.Utils;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.IIdentifiable;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.varModel.capabilities.DefaultReasonerAccess;
import net.ssehub.easy.varModel.capabilities.IReasonerCapability;
import net.ssehub.easy.varModel.capabilities.IvmlReasonerCapabilities;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.EmptyInitializer;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.NamedArgument;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ExplicitTypeVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.ICustomOperationAccessor;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.MetaTypeValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.AbstractVarModelWriter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ExpressionTranslator
extends net.ssehub.easy.dslCore.translation.ExpressionTranslator {
    public static final boolean WARN_IMPLICIT_REFBY = false;
    private AssignmentDetector assignmentDetector = new AssignmentDetector();
    private int level;
    private boolean hasTopLevelWarning;
    private RefByCheckVisitor refByChecker = new RefByCheckVisitor();

    void initLevel() {
        this.level = -1;
        this.hasTopLevelWarning = false;
    }

    void errorAboutTopLevelWarning(EObject cause, EStructuralFeature causingFeature) {
        if (this.hasTopLevelWarning) {
            this.error("warning not allowed here", cause, causingFeature, 20211);
        }
    }

    void error(IIdentifiable exception, EObject cause, EStructuralFeature causeFeature) {
        this.error(exception.getMessage(), cause, causeFeature, exception.getId());
    }

    void warning(IvmlException exception, EObject cause, EStructuralFeature causeFeature) {
        this.error(exception.getMessage(), cause, causeFeature, exception.getCode());
    }

    private ConstraintSyntaxTree handleBasicComment(EObject object, ConstraintSyntaxTree subtree) {
        ConstraintSyntaxTree result = subtree;
        return result;
    }

    public ConstraintSyntaxTree processExpression(Expression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        this.initLevel();
        return this.processExpression(null, expr, context, parent);
    }

    ConstraintSyntaxTree processBlockExpression(de.uni_hildesheim.sse.ivml.BlockExpression block, TypeContext context, IModelElement parent) throws TranslatorException {
        EList<ExpressionStatement> stmts = block.getExprs();
        ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[stmts.size()];
        int e = 0;
        while (e < stmts.size()) {
            exprs[e] = this.processExpression(((ExpressionStatement)stmts.get(e)).getExpr(), context, parent);
            ++e;
        }
        try {
            return new BlockExpression(exprs);
        }
        catch (CSTSemanticException e2) {
            throw new TranslatorException((IIdentifiable)e2, (EObject)block, (EStructuralFeature)IvmlPackage.Literals.BLOCK_EXPRESSION__EXPRS);
        }
    }

    private ConstraintSyntaxTree processExpression(IDatatype lhsType, OptBlockExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = null;
        if (expr.getBlock() != null) {
            result = this.processBlockExpression(expr.getBlock(), context, parent);
        } else if (expr.getExpr() != null) {
            result = this.processExpression(lhsType, expr.getExpr(), context, parent);
        }
        return result;
    }

    ConstraintSyntaxTree processExpression(IDatatype lhsType, Expression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = null;
        if (expr != null) {
            if (expr.getLet() != null) {
                ++this.level;
                LetExpression letEx = expr.getLet();
                IDatatype type = context.resolveType(letEx.getType());
                DecisionVariableDeclaration var = new DecisionVariableDeclaration(letEx.getName(), type, parent);
                context.pushLayer(parent);
                context.addToContext(var);
                try {
                    try {
                        var.setValue(this.processExpression(type, letEx.getValueExpr(), context, parent));
                        result = new Let(var, this.processExpression(type, letEx.getSubExpr(), context, parent));
                    }
                    catch (TranslatorException e) {
                        throw e;
                    }
                    catch (IvmlException e) {
                        this.error((IIdentifiable)e, expr.getLet(), (EStructuralFeature)IvmlPackage.Literals.LET_EXPRESSION__VALUE_EXPR);
                        context.popLayer();
                        --this.level;
                    }
                }
                finally {
                    context.popLayer();
                    --this.level;
                }
            } else if (expr.getExpr() != null) {
                result = this.processImplicationExpression(expr.getExpr(), context, parent);
            } else if (expr.getContainer() != null) {
                try {
                    result = this.processContainerInitializer(lhsType, expr, expr.getContainer(), context, parent);
                }
                catch (IvmlException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)expr, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION__CONTAINER);
                }
            }
        }
        return result;
    }

    private ConstraintSyntaxTree processAssignmentExpression(AssignmentExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processLogicalExpression(expr.getLeft(), context, parent);
        if (expr.getRight() != null) {
            IDatatype lhsType = this.inferDatatypeQuietly(result);
            ++this.level;
            for (AssignmentExpressionPart part : expr.getRight()) {
                ConstraintSyntaxTree rhs = null;
                if (part.getEx() != null) {
                    rhs = this.processLogicalExpression(part.getEx(), context, parent);
                } else if (part.getContainer() != null) {
                    try {
                        rhs = this.processContainerInitializer(result.inferDatatype(), expr, part.getContainer(), context, parent);
                    }
                    catch (IvmlException e) {
                        throw new TranslatorException((IIdentifiable)e, (EObject)expr, (EStructuralFeature)IvmlPackage.Literals.ASSIGNMENT_EXPRESSION__RIGHT);
                    }
                }
                if (rhs == null) continue;
                IDatatype rhsType = this.inferDatatypeQuietly(rhs);
                if (TypeQueries.isReference((IDatatype)lhsType) && !TypeQueries.isReference((IDatatype)rhsType)) {
                    this.warnImplicitRefBy(part.getEx(), (EStructuralFeature)IvmlPackage.Literals.ASSIGNMENT_EXPRESSION_PART__EX);
                }
                result = new OCLFeatureCall(result, part.getOp(), (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{rhs});
            }
            --this.level;
        }
        return result;
    }

    void warnImplicitRefBy(EObject cause, EStructuralFeature feature) {
    }

    private void checkForSameTypeWarning(ConstraintSyntaxTree lhs, String op, ConstraintSyntaxTree rhs, EObject cause, EStructuralFeature feature) {
        if ("<>".equals(op) || "!=".equals(op)) {
            try {
                IDatatype lhsType = lhs.inferDatatype();
                IDatatype rhsType = rhs.inferDatatype();
                if (!lhsType.isAssignableFrom(rhsType) && !rhsType.isAssignableFrom(lhsType)) {
                    this.warning("Evaluation may not be as expected, because types on both sides are different.", cause, feature, 20216);
                }
            }
            catch (CSTSemanticException cSTSemanticException) {
                // empty catch block
            }
        }
    }

    private IDatatype inferDatatypeQuietly(ConstraintSyntaxTree cst) {
        IDatatype result;
        try {
            result = cst.inferDatatype();
        }
        catch (CSTSemanticException e) {
            result = null;
        }
        return result;
    }

    private ConstraintSyntaxTree processImplicationExpression(ImplicationExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processAssignmentExpression(expr.getLeft(), context, parent);
        if (expr.getRight() != null) {
            ++this.level;
            for (ImplicationExpressionPart part : expr.getRight()) {
                if ("implies".equals(part.getOp())) {
                    this.checkForAssigment(result, true, expr, (EStructuralFeature)IvmlPackage.Literals.IMPLICATION_EXPRESSION__LEFT);
                }
                ConstraintSyntaxTree cst = this.processAssignmentExpression(part.getEx(), context, parent);
                this.checkForAssigment(cst, false, part, (EStructuralFeature)IvmlPackage.Literals.IMPLICATION_EXPRESSION_PART__EX);
                result = new OCLFeatureCall(result, part.getOp(), (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{cst});
            }
            --this.level;
        }
        return result;
    }

    private void checkForAssigment(ConstraintSyntaxTree cst, boolean error, EObject cause, EStructuralFeature causingFeature) {
        this.assignmentDetector.setMaxLevel(0);
        cst.accept((IConstraintTreeVisitor)this.assignmentDetector);
        if (this.assignmentDetector.isAssignment()) {
            if (error) {
                this.error("assignments are not allowed here", cause, causingFeature, 20209);
            } else {
                this.warning("discouraged use in expression as assignments are always true", cause, causingFeature, 20209);
            }
        }
        this.assignmentDetector.clear();
    }

    ConstraintSyntaxTree processLogicalExpression(LogicalExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processEqualityExpression(expr.getLeft(), context, parent);
        if (expr.getRight() != null) {
            ++this.level;
            if (!expr.getRight().isEmpty()) {
                this.checkForAssigment(result, false, expr, (EStructuralFeature)IvmlPackage.Literals.LOGICAL_EXPRESSION__LEFT);
            }
            for (LogicalExpressionPart part : expr.getRight()) {
                ConstraintSyntaxTree cst = this.processEqualityExpression(part.getEx(), context, parent);
                this.checkForAssigment(result, false, part, (EStructuralFeature)IvmlPackage.Literals.LOGICAL_EXPRESSION_PART__EX);
                result = new OCLFeatureCall(result, part.getOp(), (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{cst});
            }
            --this.level;
        }
        return result;
    }

    private ConstraintSyntaxTree processEqualityExpression(EqualityExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processRelationalExpression(expr.getLeft(), context, parent);
        EqualityExpressionPart right = expr.getRight();
        if (right != null) {
            ++this.level;
            String op = expr.getRight().getOp();
            if ("!=".equals(op)) {
                op = "<>";
                if (AbstractVarModelWriter.considerOclCompliance()) {
                    this.warning("OCL compliance: Please use <> instead of !=", right, (EStructuralFeature)IvmlPackage.Literals.EQUALITY_EXPRESSION_PART__OP, 20211);
                }
            }
            ConstraintSyntaxTree rhs = null;
            if (expr.getRight().getEx() != null) {
                rhs = this.processRelationalExpression(right.getEx(), context, parent);
                this.checkForAssigment(rhs, false, right, (EStructuralFeature)IvmlPackage.Literals.EQUALITY_EXPRESSION__RIGHT);
            } else if (right.getContainer() != null) {
                try {
                    rhs = this.processContainerInitializer(result.inferDatatype(), expr, right.getContainer(), context, parent);
                }
                catch (IvmlException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)right, (EStructuralFeature)IvmlPackage.Literals.ASSIGNMENT_EXPRESSION_PART__CONTAINER);
                }
            }
            if (rhs != null) {
                this.checkForSameTypeWarning(result, op, rhs, right, (EStructuralFeature)IvmlPackage.Literals.EQUALITY_EXPRESSION_PART__OP);
                result = new OCLFeatureCall(result, op, (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{rhs});
            }
            --this.level;
        }
        return result;
    }

    private ConstraintSyntaxTree processRelationalExpression(RelationalExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processAdditiveExpression(expr.getLeft(), context, parent);
        if (expr.getRight() != null) {
            ++this.level;
            this.checkForAssigment(result, false, expr, (EStructuralFeature)IvmlPackage.Literals.RELATIONAL_EXPRESSION__LEFT);
            String op = expr.getRight().getOp();
            ConstraintSyntaxTree cst = this.processAdditiveExpression(expr.getRight().getEx(), context, parent);
            this.checkForAssigment(cst, false, expr, (EStructuralFeature)IvmlPackage.Literals.RELATIONAL_EXPRESSION__RIGHT);
            OCLFeatureCall call1 = new OCLFeatureCall(result, op, (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{cst});
            result = call1;
            if (expr.getRight2() != null) {
                String op2 = expr.getRight2().getOp();
                ConstraintSyntaxTree cst2 = this.processAdditiveExpression(expr.getRight2().getEx(), context, parent);
                this.checkForAssigment(cst2, false, expr, (EStructuralFeature)IvmlPackage.Literals.RELATIONAL_EXPRESSION__RIGHT);
                OCLFeatureCall call2 = new OCLFeatureCall(cst, op2, (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{cst2});
                try {
                    result = new MultiAndExpression(new OCLFeatureCall[]{call1, call2});
                }
                catch (CSTSemanticException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)expr, (EStructuralFeature)IvmlPackage.Literals.RELATIONAL_EXPRESSION__RIGHT2);
                }
                if (AbstractVarModelWriter.considerOclCompliance()) {
                    this.warning("OCL compliance: chain of relational operations shall be written by a combination of binary comparisons and Boolean and operatoins", expr, (EStructuralFeature)IvmlPackage.Literals.RELATIONAL_EXPRESSION__RIGHT2, 20211);
                }
            }
            --this.level;
        }
        return result;
    }

    private ConstraintSyntaxTree processAdditiveExpression(AdditiveExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processMultiplicativeExpression(expr.getLeft(), context, parent);
        if (expr.getRight() != null) {
            ++this.level;
            if (!expr.getRight().isEmpty()) {
                this.checkForAssigment(result, false, expr, (EStructuralFeature)IvmlPackage.Literals.ADDITIVE_EXPRESSION__LEFT);
            }
            for (AdditiveExpressionPart part : expr.getRight()) {
                ConstraintSyntaxTree cst = this.processMultiplicativeExpression(part.getEx(), context, parent);
                this.checkForAssigment(cst, false, part, (EStructuralFeature)IvmlPackage.Literals.ADDITIVE_EXPRESSION_PART__EX);
                result = new OCLFeatureCall(result, part.getOp(), (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{cst});
            }
            --this.level;
        }
        return result;
    }

    private ConstraintSyntaxTree processMultiplicativeExpression(MultiplicativeExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processUnaryExpression(expr.getLeft(), context, parent);
        if (expr.getRight() != null) {
            ++this.level;
            this.checkForAssigment(result, false, expr, (EStructuralFeature)IvmlPackage.Literals.MULTIPLICATIVE_EXPRESSION__LEFT);
            ConstraintSyntaxTree cst = this.processUnaryExpression(expr.getRight().getExpr(), context, parent);
            this.checkForAssigment(cst, false, expr, (EStructuralFeature)IvmlPackage.Literals.MULTIPLICATIVE_EXPRESSION__RIGHT);
            result = new OCLFeatureCall(result, expr.getRight().getOp(), (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{cst});
            --this.level;
        }
        return result;
    }

    private ConstraintSyntaxTree processUnaryExpression(UnaryExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processPostfixExpression(expr.getExpr(), context, parent);
        if (expr.getOp() != null) {
            ++this.level;
            result = new OCLFeatureCall(result, expr.getOp(), (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[0]);
            --this.level;
        }
        return result;
    }

    private ConstraintSyntaxTree processFeatureCall(ConstraintSyntaxTree lhs, FeatureCall call, TypeContext context, IModelElement parent) throws TranslatorException {
        return this.processFeatureCallImpl(lhs, call, context, parent, true);
    }

    /*
     * Unable to fully structure code
     */
    private ConstraintSyntaxTree processFeatureCallImpl(ConstraintSyntaxTree lhs, ActualArgumentList call, TypeContext context, IModelElement parent, boolean checkOclCompliance) throws TranslatorException {
        ++this.level;
        regularFeatureCall = true;
        args = call.getArgs();
        callName = call.getName();
        if (args == null) {
            param = null;
            if (lhs != null) {
                try {
                    leftType = lhs.inferDatatype();
                    if (!leftType.isAssignableFrom(Compound.TYPE)) ** GOTO lbl45
                    isOp = false;
                    o = 0;
                    while (!isOp && o < leftType.getOperationCount()) {
                        isOp = leftType.getOperation(o).getName().equals(callName);
                        ++o;
                    }
                    if (!isOp) ** GOTO lbl45
                    this.checkForCompoundElement((Compound)leftType, callName, call);
                }
                catch (CSTSemanticException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)call, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__ARGS);
                }
            }
        } else {
            pListSize = args.size();
            if (pListSize == 0) {
                param = null;
            } else if (lhs == null) {
                lhs = this.processArgument(null, (ActualArgument)args.get(0), context, parent);
                if (pListSize - 1 > 0) {
                    param = new ConstraintSyntaxTree[pListSize - 1];
                    p = 1;
                    while (p < pListSize) {
                        param[p - 1] = this.processArgument(null, (ActualArgument)args.get(p), context, parent);
                        ++p;
                    }
                } else {
                    param = null;
                }
            } else {
                param = new ConstraintSyntaxTree[pListSize];
                p = 0;
                while (p < pListSize) {
                    param[p] = this.processArgument(null, (ActualArgument)args.get(p), context, parent);
                    ++p;
                }
            }
        }
lbl45:
        // 8 sources

        if (regularFeatureCall) {
            tmp = new OCLFeatureCall(lhs, callName, (ICustomOperationAccessor)context.getProject(), param);
            try {
                tmp.inferDatatype();
                op = tmp.getResolvedOperation();
                if (checkOclCompliance && AbstractVarModelWriter.considerOclCompliance()) {
                    if (op != null && TypeQueries.isContainer((IDatatype)op.getOperand()) && op.isContainerOperation()) {
                        this.warning("OCL compliance: Container operations shall be called by '->' rather than '.'", call, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__NAME, 20211);
                    }
                    this.checkOperationOclCompliance(op, call, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__NAME);
                }
            }
            catch (CSTSemanticException var11_15) {
                // empty catch block
            }
            lhs = tmp;
        }
        if ("warning".equals(callName)) {
            if (this.level > 1) {
                this.error("warning is not allowed in nested expressions", call, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__NAME, 20211);
            } else {
                this.hasTopLevelWarning = true;
            }
        }
        --this.level;
        return lhs;
    }

    private ConstraintSyntaxTree processArgument(IDatatype lhsType, ActualArgument arg, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result = this.processExpression(lhsType, arg.getArg(), context, parent);
        if (result != null && arg.getName() != null) {
            result = new NamedArgument(arg.getName(), result);
        }
        return result;
    }

    private void checkForCompoundElement(Compound comp, String name, ActualArgumentList call) throws TranslatorException {
        if (comp.getElement(name) != null) {
            throw new TranslatorException("compound slot '" + name + "' clashes with operation of same name", (EObject)call, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__NAME, 20210);
        }
    }

    private void processDeclaration(ConstraintSyntaxTree lhs, ContainerOp op, TypeContext context, IModelElement parent, Declaration declaration, List<DecisionVariableDeclaration> declarators) throws TranslatorException {
        boolean explicitType;
        ++this.level;
        Object type = null;
        if (declaration.getType() != null) {
            type = context.resolveType(declaration.getType());
            explicitType = true;
        } else {
            explicitType = false;
            try {
                IDatatype collectionType = lhs.inferDatatype();
                type = collectionType instanceof Container ? ((Container)collectionType).getContainedType() : new Set("", collectionType, null);
            }
            catch (IvmlException e) {
                this.error((IIdentifiable)e, op, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__ARGS);
            }
        }
        ConstraintSyntaxTree valueEx = declaration.getInit() != null ? this.processExpression((IDatatype)type, declaration.getInit(), context, parent) : null;
        if (type != null) {
            EList<String> ids = declaration.getId();
            int i = 0;
            while (i < ids.size()) {
                Object declarator = i == 0 && explicitType ? new ExplicitTypeVariableDeclaration((String)ids.get(i), type, parent) : new DecisionVariableDeclaration((String)ids.get(i), type, parent);
                if (valueEx != null) {
                    try {
                        declarator.setValue(valueEx);
                    }
                    catch (IvmlException e) {
                        this.error((IIdentifiable)e, op, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__ARGS);
                    }
                }
                declarators.add((DecisionVariableDeclaration)declarator);
                ++i;
            }
        }
        --this.level;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ConstraintSyntaxTree processContainerOp(ConstraintSyntaxTree lhs, ContainerOp op, TypeContext context, IModelElement parent) throws TranslatorException {
        Declarator declarator = op.getDecl();
        EList<ActualArgument> args = op.getArgs();
        if (declarator != null) {
            if (args == null) return this.processContainerOp(lhs, op, null, null, context, parent);
            if (args.size() == 1) {
                return this.processContainerOp(lhs, op, null, null, context, parent);
            }
        }
        if (declarator != null) throw new TranslatorException("An iterating container operation requires at most one expression", (EObject)op, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__ARGS, 20213);
        try {
            return this.processFeatureCallImpl(lhs, op, context, parent, false);
        }
        catch (TranslatorException e) {
            try {
                IDatatype lhsType = lhs.inferDatatype();
                if (!Container.TYPE.isAssignableFrom(lhsType)) return lhs;
                if (1 != lhsType.getGenericTypeCount()) return lhs;
                ArrayList<DecisionVariableDeclaration> decls = new ArrayList<DecisionVariableDeclaration>();
                DecisionVariableDeclaration decl = new DecisionVariableDeclaration("t", lhsType.getGenericType(0), (IModelElement)new Constraint(null));
                decls.add(decl);
                ConstraintSyntaxTree declEx = this.getAccessor((List<ActualArgument>)args, decl);
                if (declEx == null) throw e;
                return this.processContainerOp(lhs, op, decls, declEx, context, parent);
            }
            catch (CSTSemanticException e1) {
                throw e;
            }
            catch (TranslatorException e1) {
                throw e;
            }
        }
    }

    private ConstraintSyntaxTree getAccessor(List<ActualArgument> args, DecisionVariableDeclaration decl) {
        ActualArgument arg;
        ConstraintSyntaxTree result = null;
        if (1 == args.size() && (arg = args.get(0)) != null && arg.getArg() != null) {
            result = this.getAccessor(arg.getArg().getExpr(), decl);
        }
        return result;
    }

    private ConstraintSyntaxTree getAccessor(ImplicationExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLeft(), decl);
    }

    private ConstraintSyntaxTree getAccessor(AssignmentExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLeft(), decl);
    }

    private ConstraintSyntaxTree getAccessor(LogicalExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLeft(), decl);
    }

    private ConstraintSyntaxTree getAccessor(EqualityExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLeft(), decl);
    }

    private ConstraintSyntaxTree getAccessor(RelationalExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLeft(), decl);
    }

    private ConstraintSyntaxTree getAccessor(AdditiveExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLeft(), decl);
    }

    private ConstraintSyntaxTree getAccessor(MultiplicativeExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLeft(), decl);
    }

    private ConstraintSyntaxTree getAccessor(UnaryExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getExpr(), decl);
    }

    private ConstraintSyntaxTree getAccessor(PostfixExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLeft(), decl);
    }

    private ConstraintSyntaxTree getAccessor(PrimaryExpression ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getLit(), decl);
    }

    private ConstraintSyntaxTree getAccessor(Literal ex, DecisionVariableDeclaration decl) {
        return ex == null ? null : this.getAccessor(ex.getVal(), decl);
    }

    private ConstraintSyntaxTree getAccessor(de.uni_hildesheim.sse.ivml.Value ex, DecisionVariableDeclaration decl) {
        CompoundAccess result = null;
        if (ex != null && ex.getQValue() != null) {
            result = new CompoundAccess((ConstraintSyntaxTree)new Variable((AbstractVariable)decl), Utils.getQualifiedNameString(ex.getQValue()));
        }
        return result;
    }

    private ConstraintSyntaxTree processContainerOp(ConstraintSyntaxTree lhs, ContainerOp op, List<DecisionVariableDeclaration> declarators, ConstraintSyntaxTree declEx, TypeContext context, IModelElement parent) throws TranslatorException {
        ++this.level;
        if (declarators == null) {
            EList<Declaration> declarations = op.getDecl().getDecl();
            declarators = new ArrayList<DecisionVariableDeclaration>();
            int d = 0;
            while (d < declarations.size()) {
                Declaration declaration = (Declaration)declarations.get(d);
                EList<String> ids = declaration.getId();
                if (ids == null || ids.size() <= 0 || ids.get(0) == null) {
                    throw new TranslatorException("Iterating container operations require at least one declarator", (EObject)declaration, (EStructuralFeature)IvmlPackage.Literals.CONTAINER_OP__DECL, 20213);
                }
                this.processDeclaration(lhs, op, context, parent, declaration, declarators);
                ++d;
            }
        }
        context.pushLayer(parent);
        int declSize = declarators.size();
        DecisionVariableDeclaration[] decls = new DecisionVariableDeclaration[declSize];
        int ds = 0;
        while (ds < declSize) {
            decls[ds] = declarators.get(ds);
            context.addToContext(decls[ds]);
            ++ds;
        }
        try {
            try {
                EList<ActualArgument> args;
                if (declEx == null && ((args = op.getArgs()) == null || args.size() == 1)) {
                    String name = null;
                    Expression ex = null;
                    if (args != null) {
                        ActualArgument arg0 = (ActualArgument)args.get(0);
                        name = arg0.getName();
                        ex = arg0.getArg();
                    }
                    declEx = this.processExpression(null, ex, context, parent);
                    if (name != null) {
                        try {
                            declEx = new OCLFeatureCall((ConstraintSyntaxTree)new Variable(context.findVariable(name, null)), "=", new ConstraintSyntaxTree[]{declEx});
                        }
                        catch (ModelQueryException e) {
                            throw new TranslatorException((IIdentifiable)e, (EObject)op, (EStructuralFeature)IvmlPackage.Literals.CONTAINER_OP__DECL);
                        }
                    }
                }
                if (declEx == null) {
                    throw new TranslatorException("No iterating expression given", (EObject)op, (EStructuralFeature)IvmlPackage.Literals.CONTAINER_OP__DECL, 20213);
                }
                declEx.inferDatatype();
                ContainerOperationCall coc = new ContainerOperationCall(lhs, op.getName(), declEx, decls);
                coc.inferDatatype();
                this.checkOperationOclCompliance(coc.getResolvedOperation(), op, (EStructuralFeature)IvmlPackage.Literals.CONTAINER_OP__DECL);
                lhs = coc;
            }
            catch (TranslatorException e) {
                throw e;
            }
            catch (CSTSemanticException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)op, (EStructuralFeature)IvmlPackage.Literals.CONTAINER_OP__DECL);
            }
        }
        finally {
            context.popLayer();
        }
        --this.level;
        return lhs;
    }

    private void checkOperationOclCompliance(Operation op, EObject cause, EStructuralFeature feature) {
        Operation alias;
        if (AbstractVarModelWriter.considerOclCompliance() && (alias = Operation.getAlias((Operation)op)) != null) {
            this.warning("OCL compliance: Please use '" + alias.getSignature() + "' instead of '" + op.getSignature() + "'", cause, feature, 20211);
        }
    }

    private ConstraintSyntaxTree processPostfixExpression(PostfixExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree result;
        ++this.level;
        if (expr == null) {
            throw new TranslatorException("<consume>", (EObject)expr, (EStructuralFeature)IvmlPackage.Literals.POSTFIX_EXPRESSION__LEFT, 20101);
        }
        if (expr.getCall() != null) {
            result = this.processFeatureCall(null, expr.getCall(), context, parent);
            result = this.processCallsAndAccess(result, (List<Call>)expr.getFCalls(), expr.getAccess(), context, parent);
        } else if (expr.getLeft() != null) {
            result = this.processPrimaryExpression(expr.getLeft(), context, parent);
        } else {
            throw new TranslatorException("<consume>", (EObject)expr, (EStructuralFeature)IvmlPackage.Literals.POSTFIX_EXPRESSION__LEFT, 20101);
        }
        --this.level;
        return result;
    }

    private static IDatatype refType(IDatatype varType, TypeContext context) {
        IDatatype refType = Reference.TYPE.isAssignableFrom(varType) ? varType : context.findRefType(varType);
        return refType;
    }

    private ConstraintSyntaxTree processPrimaryExpression(PrimaryExpression expr, TypeContext context, IModelElement parent) throws TranslatorException {
        ++this.level;
        Parenthesis result = null;
        if (expr.getRefEx() != null) {
            ConstraintSyntaxTree refEx = this.processExpression(null, expr.getRefEx(), context, parent);
            try {
                if (refEx instanceof Variable) {
                    AbstractVariable var = ((Variable)refEx).getVariable();
                    IDatatype varType = var.getType();
                    if (TypeQueries.isReference((IDatatype)DerivedDatatype.resolveToBasis((IDatatype)varType))) {
                        result = new OCLFeatureCall(refEx, "refBy", new ConstraintSyntaxTree[0]);
                    }
                    IDatatype refType = ExpressionTranslator.refType(varType, context);
                    result = new ConstantValue(ValueFactory.createValue((IDatatype)refType, (Object[])new Object[]{var}));
                }
                IDatatype varType = refEx.inferDatatype();
                this.refByChecker.reset();
                refEx.accept((IConstraintTreeVisitor)this.refByChecker);
                if (this.refByChecker.canBeDereferenced()) {
                    IDatatype refType = ExpressionTranslator.refType(varType, context);
                    result = new ConstantValue(ValueFactory.createValue((IDatatype)refType, (Object[])new Object[]{refEx}));
                }
                throw new TranslatorException("Expression cannot be dereferenced", (EObject)expr, (EStructuralFeature)IvmlPackage.Literals.PRIMARY_EXPRESSION__REF_EX, 20212);
            }
            catch (IvmlException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)expr, (EStructuralFeature)IvmlPackage.Literals.PRIMARY_EXPRESSION__REF_EX);
            }
        } else if (expr.getEx() != null) {
            result = new Parenthesis(this.processExpression(null, expr.getEx(), context, parent));
        } else if (expr.getIfEx() != null) {
            IfExpression ifExpr = expr.getIfEx();
            result = new IfThen(this.processExpression(null, ifExpr.getIfEx(), context, parent), this.processExpression(null, ifExpr.getThenEx(), context, parent), this.processExpression(null, ifExpr.getElseEx(), context, parent));
        } else if (expr.getLit() != null) {
            de.uni_hildesheim.sse.ivml.Value value = expr.getLit().getVal();
            EReference causingFeature = IvmlPackage.Literals.PRIMARY_EXPRESSION__LIT;
            if (value.getBValue() != null) {
                causingFeature = IvmlPackage.Literals.PRIMARY_EXPRESSION__LIT;
            }
            result = context.resolveValue(value, parent, expr, (EStructuralFeature)causingFeature);
            result = this.handleBasicComment(expr.getLit(), (ConstraintSyntaxTree)result);
        }
        result = this.processCallsAndAccess((ConstraintSyntaxTree)result, (List<Call>)expr.getCalls(), expr.getAccess(), context, parent);
        --this.level;
        return result;
    }

    private ConstraintSyntaxTree processCallsAndAccess(ConstraintSyntaxTree lhs, List<Call> calls, ExpressionAccess access, TypeContext context, IModelElement parent) throws TranslatorException {
        ++this.level;
        ConstraintSyntaxTree result = lhs;
        if (calls != null) {
            for (Call call : calls) {
                if (call.getCall() != null) {
                    result = this.processFeatureCall(result, call.getCall(), context, parent);
                    continue;
                }
                if (call.getContainerOp() != null) {
                    result = this.processContainerOp(result, call.getContainerOp(), context, parent);
                    continue;
                }
                if (call.getArrayEx() == null) continue;
                result = new OCLFeatureCall(result, "[]", new ConstraintSyntaxTree[]{this.processExpression(null, call.getArrayEx(), context, parent)});
            }
        }
        if (access != null) {
            result = this.processAccess(result, access, context, parent);
        }
        --this.level;
        return result;
    }

    private boolean hasLiteral(Enum eenum, String name) {
        return eenum.get(name) != null;
    }

    private boolean hasSlot(Compound comp, String name) {
        boolean result = false;
        if (comp.getElement(name) != null) {
            result = true;
        } else {
            int r = 0;
            while (!result && r < comp.getRefinesCount()) {
                result = this.hasSlot(comp.getRefines(r), name);
                ++r;
            }
        }
        return result;
    }

    private ConstraintSyntaxTree processAccess(ConstraintSyntaxTree lhs, ExpressionAccess access, TypeContext context, IModelElement parent) throws TranslatorException {
        ++this.level;
        CompoundAccess result = null;
        String name = access.getName();
        try {
            IDatatype type = lhs.getContainedType();
            if (type == null) {
                type = lhs.inferDatatype();
            }
            if (TypeQueries.isCompound((IDatatype)(type = TypeQueries.resolveFully((IDatatype)type))) && this.hasSlot((Compound)type, name)) {
                result = new CompoundAccess(lhs, name);
                IDatatype lhsType = lhs.inferDatatype();
                if (!DefaultReasonerAccess.hasCapability((IReasonerCapability)IvmlReasonerCapabilities.QUALIFIED_COMPOUND_ACCESS) && MetaType.TYPE.isAssignableFrom(lhsType)) {
                    Value val;
                    IDatatype msgLhsType = lhsType;
                    if (lhs instanceof ConstantValue && (val = ((ConstantValue)lhs).getConstantValue()) instanceof MetaTypeValue) {
                        msgLhsType = ((MetaTypeValue)val).getValue();
                    }
                    this.warning("Qualified compound type '" + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)msgLhsType) + "' outside a compound is currently not supported in reasoning.", access, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_ACCESS__NAME, 20215);
                }
            } else if (TypeQueries.isEnum((IDatatype)type) && this.hasLiteral((Enum)type, name)) {
                result = new ConstantValue(ValueFactory.createValue((IDatatype)type, (Object[])new Object[]{name}));
                context.checkEnumOclCompliance(((Enum)type).getName() + "." + name, access, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_ACCESS__NAME);
            } else if (TypeQueries.isFreezeVariableType((IDatatype)type) && ((FreezeVariableType)type).getAttribute(name) != null) {
                result = new AttributeVariable(lhs, ((FreezeVariableType)type).getAttribute(name));
            } else {
                Attribute attr = ModelElement.findAttribute((IAttributeAccess)lhs, (String)name);
                if (attr == null) {
                    attr = ModelElement.findAttribute((IAttributeAccess)context.getProject(), (String)name);
                }
                if (attr != null) {
                    if (lhs instanceof ConstantValue) {
                        throw new TranslatorException("project attributes are templates to declare attributes of variables", (EObject)access, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_ACCESS__NAME, 10104);
                    }
                    result = new AttributeVariable(lhs, attr);
                }
            }
            if (result == null) {
                throw new TranslatorException("cannot resolve '" + access.getName() + "'", (EObject)access, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_ACCESS__NAME, 10104);
            }
            result = this.processCallsAndAccess((ConstraintSyntaxTree)result, (List<Call>)access.getCalls(), access.getAccess(), context, parent);
        }
        catch (IvmlException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)access, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_ACCESS__NAME);
        }
        --this.level;
        return result;
    }

    private ConstraintSyntaxTree processContainerInitializer(IDatatype lhsType, EObject expr, ContainerInitializer initializer, TypeContext context, IModelElement parent) throws TranslatorException, IvmlException {
        return this.processLiteralContainer(lhsType, initializer, context, parent);
    }

    private Object[] translateToValues(Object[] values) throws IvmlException {
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                if (values[i].getClass().isArray()) {
                    values[i] = this.translateToValues((Object[])values[i]);
                } else if (values[i] instanceof ConstantValue) {
                    values[i] = ((ConstantValue)values[i]).getConstantValue();
                } else if (values[i] instanceof ConstraintSyntaxTree) {
                    throw new ValueDoesNotMatchTypeException("only literal values are allowed here", 10201);
                }
            }
            ++i;
        }
        return values;
    }

    private IDatatype getSpecificType(IDatatype lhsType, ContainerInitializer initializer, TypeContext context) throws TranslatorException {
        IDatatype specificType = null;
        if (initializer.getType() != null) {
            try {
                String sTypeName = Utils.getQualifiedNameString(initializer.getType());
                specificType = context.findType(sTypeName, null);
                if (specificType == null) {
                    throw new TranslatorException("type '" + sTypeName + "' is not defined", (EObject)initializer, (EStructuralFeature)IvmlPackage.Literals.CONTAINER_INITIALIZER__TYPE, 20203);
                }
                if (lhsType != null && TypeQueries.isContainer((IDatatype)lhsType) && !lhsType.isAssignableFrom(specificType)) {
                    throw new TranslatorException("collection type '" + IvmlDatatypeVisitor.getQualifiedType((IDatatype)lhsType) + "' does not match specified entry type '" + sTypeName + "'", (EObject)initializer, (EStructuralFeature)IvmlPackage.Literals.CONTAINER_INITIALIZER__TYPE, 20203);
                }
            }
            catch (ModelQueryException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)initializer, (EStructuralFeature)IvmlPackage.Literals.CONTAINER_INITIALIZER__TYPE);
            }
        }
        return specificType;
    }

    private ConstraintSyntaxTree processLiteralContainer(IDatatype lhsType, ContainerInitializer initializer, TypeContext context, IModelElement parent) throws TranslatorException, CSTSemanticException, IvmlException {
        boolean allWithoutId;
        EList<ExpressionListEntry> entryList;
        ++this.level;
        EmptyInitializer result = null;
        IDatatype specificType = TypeQueries.resolveFully((IDatatype)this.getSpecificType(lhsType = TypeQueries.resolveFully((IDatatype)lhsType), initializer, context));
        if (specificType != null) {
            lhsType = specificType;
        }
        ExpressionListOrRange init = initializer.getInit();
        int withoutId = 0;
        int withId = 0;
        int entryCount = 0;
        boolean isConstraintContainer = Container.isConstraintContainer((IDatatype)lhsType);
        if (init != null) {
            entryList = init.getList();
            entryCount = entryList.size();
            int e = 0;
            while (e < entryCount) {
                ExpressionListEntry entry = (ExpressionListEntry)entryList.get(e);
                String name = entry.getName();
                if (name != null) {
                    if (isConstraintContainer) {
                        ++withoutId;
                    } else {
                        ++withId;
                    }
                } else {
                    ++withoutId;
                }
                ++e;
            }
        } else {
            entryCount = 0;
            entryList = null;
        }
        boolean allWithId = withId == entryCount;
        boolean bl = allWithoutId = withoutId == entryCount;
        if (!allWithId && !allWithoutId) {
            throw new TranslatorException("compound initializer value entries must either all have names or none", (EObject)init, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_OR_RANGE__LIST, 20202);
        }
        if (lhsType instanceof Container) {
            if (allWithId && entryCount > 0) {
                throw new TranslatorException("container initialization " + this.toString(entryList, true) + " must not have name-value assignments", (EObject)init, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_OR_RANGE__LIST, 20202);
            }
            result = this.processContainerInitializer(lhsType, context, parent, entryList);
        } else if (lhsType instanceof Compound) {
            if (allWithoutId && entryCount > 0) {
                throw new TranslatorException("compound initialization requires name-value assignments", (EObject)init, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_OR_RANGE__LIST, 20202);
            }
            result = this.processCompoundInitializer(lhsType, context, parent, specificType, entryList);
            IDatatype resType = result.inferDatatype();
            if (resType instanceof Compound && ((Compound)resType).isAbstract()) {
                throw new TranslatorException("Cannot instantiate abstract compound '" + resType.getName() + "'", (EObject)init, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_OR_RANGE__LIST, 10208);
            }
        } else {
            result = EmptyInitializer.INSTANCE;
        }
        --this.level;
        return result;
    }

    public String toString(EList<ExpressionListEntry> list, boolean withNames) {
        Object result = "[";
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                result = (String)result + ", ";
            }
            ExpressionListEntry e = (ExpressionListEntry)list.get(i);
            if (withNames) {
                result = (String)result + e.getName() + "=";
            }
            result = (String)result + "<" + (e.getValue() == null ? "null" : "value") + ">";
            ++i;
        }
        return (String)result + "]";
    }

    private ConstraintSyntaxTree processCompoundInitializer(IDatatype lhsType, TypeContext context, IModelElement parent, IDatatype specificType, EList<ExpressionListEntry> entryList) throws TranslatorException, CSTSemanticException, IvmlException, ValueDoesNotMatchTypeException {
        CompoundInitializer result;
        ++this.level;
        Compound comp = (Compound)lhsType;
        context.pushLayer((IModelElement)comp);
        context.addToContext(comp);
        int entryCount = entryList == null ? 0 : entryList.size();
        ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[entryCount];
        String[] slots = new String[entryCount];
        AbstractVariable[] slotDecls = new AbstractVariable[entryCount];
        int e = 0;
        while (e < entryCount) {
            ExpressionListEntry entry = (ExpressionListEntry)entryList.get(e);
            if (entry.getName() != null) {
                slots[e] = entry.getName();
                slotDecls[e] = comp.getElement(slots[e]);
                if (slotDecls[e] == null) {
                    throw new TranslatorException("field '" + slots[e] + "' does not exist in '" + lhsType.getName() + "'", (EObject)entry, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_ENTRY__VALUE, 20207);
                }
                if (entry.getAttrib() != null) {
                    int n = e;
                    slots[n] = String.valueOf(slots[n]) + "." + entry.getAttrib();
                    slotDecls[e] = this.findSlotOrAttribute(comp, slots[e]);
                    if (slotDecls[e] == null) {
                        this.warning("field/attribute '" + slots[e] + "' does not exist in '" + lhsType.getName() + "'", entry, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_ENTRY__VALUE, 20207);
                    }
                }
            }
            if (entry.getValue() != null) {
                exprs[e] = this.processImplicationExpression(entry.getValue(), context, parent);
                IDatatype exprType = exprs[e].inferDatatype();
                if (!(entry.getName() == null && entry.getAttrib() == null || slotDecls[e] == null || slotDecls[e].getType().isAssignableFrom(exprType) || Reference.dereference((IDatatype)slotDecls[e].getType()).isAssignableFrom(Reference.dereference((IDatatype)exprType)))) {
                    this.error("expression for slot '" + slots[e] + "' does not comply with '" + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)slotDecls[e].getType()) + "'", (EObject)entryList.get(e), (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_ENTRY__VALUE, 20203);
                }
            }
            if (entry.getContainer() != null) {
                exprs[e] = this.processLiteralContainer(slotDecls[e].getType(), entry.getContainer(), context, parent);
            }
            ++e;
        }
        if (ExpressionTranslator.allConstant(exprs)) {
            int pos = 0;
            Object[] obj = new Object[2 + 2 * entryCount];
            obj[pos++] = ".";
            obj[pos++] = specificType;
            int e2 = 0;
            while (e2 < exprs.length) {
                obj[pos++] = slots[e2];
                obj[pos++] = exprs[e2];
                ++e2;
            }
            result = new ConstantValue(ValueFactory.createValue((IDatatype)lhsType, (Object[])this.translateToValues(obj)));
        } else {
            result = new CompoundInitializer(comp, slots, slotDecls, exprs);
        }
        context.popLayer();
        --this.level;
        return result;
    }

    private AbstractVariable findSlotOrAttribute(Compound comp, String name) {
        DecisionVariableDeclaration decl;
        DecisionVariableDeclaration result = null;
        String check = name;
        String rest = null;
        int pos = name.indexOf(".");
        if (pos > 0) {
            check = name.substring(0, pos);
            rest = name.substring(pos + 1);
        }
        if ((decl = comp.getElement(check)) != null) {
            if (rest != null) {
                IDatatype type = decl.getType();
                if ((type = DerivedDatatype.resolveToBasis((IDatatype)type)) instanceof Compound) {
                    result = this.findSlotOrAttribute((Compound)type, rest);
                }
            } else {
                result = decl;
            }
        }
        return result;
    }

    private ConstraintSyntaxTree processContainerInitializer(IDatatype lhsType, TypeContext context, IModelElement parent, EList<ExpressionListEntry> entryList) throws TranslatorException, CSTSemanticException, IvmlException, ValueDoesNotMatchTypeException {
        net.ssehub.easy.varModel.cst.ContainerInitializer result;
        ++this.level;
        int entryCount = entryList == null ? 0 : entryList.size();
        ConstraintSyntaxTree[] exprs = new ConstraintSyntaxTree[entryCount];
        IDatatype contained = ((Container)lhsType).getContainedType();
        boolean isConstraintCollection = ConstraintType.TYPE.getType().equals(contained.getType());
        int e = 0;
        while (e < entryCount) {
            ExpressionListEntry entry = (ExpressionListEntry)entryList.get(e);
            if (entry.getValue() != null) {
                exprs[e] = this.processImplicationExpression(entry.getValue(), context, parent);
                if (exprs[e] != null) {
                    exprs[e].inferDatatype();
                }
                if (isConstraintCollection && entry.getName() != null) {
                    ConstraintSyntaxTree varTree = context.processQValue(entry.getName(), entry, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_ENTRY__NAME);
                    exprs[e] = new OCLFeatureCall(varTree, "=", (ICustomOperationAccessor)context.getProject(), new ConstraintSyntaxTree[]{exprs[e]});
                    this.warning("assignment is discouraged in constraint set as it is always true", entry, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_LIST_ENTRY__NAME, 20214);
                    exprs[e].inferDatatype();
                }
            }
            if (entry.getContainer() != null) {
                exprs[e] = this.processLiteralContainer(contained, entry.getContainer(), context, parent);
            }
            ++e;
        }
        if (ExpressionTranslator.allConstant(exprs)) {
            Object[] obj = new Object[exprs.length];
            int e2 = 0;
            while (e2 < obj.length) {
                obj[e2] = exprs[e2];
                ++e2;
            }
            Object[] values = this.translateToValues(obj);
            if (values != null && Container.isContainer((IDatatype)lhsType, (IDatatype[])new IDatatype[]{ConstraintType.TYPE})) {
                int v = 0;
                while (v < values.length) {
                    Object val = values[v];
                    if (!(val instanceof ConstraintValue) && isConstraintCollection) {
                        values[v] = ValueFactory.createValue((IDatatype)ConstraintType.TYPE, (Object[])new Object[]{new ConstantValue((Value)val)});
                    }
                    ++v;
                }
            }
            result = new ConstantValue(ValueFactory.createValue((IDatatype)lhsType, (Object[])values));
        } else {
            result = new net.ssehub.easy.varModel.cst.ContainerInitializer((Container)lhsType, exprs);
        }
        --this.level;
        return result;
    }

    private static boolean allConstant(ConstraintSyntaxTree[] exprs) {
        boolean allConst = true;
        int e = 0;
        while (allConst && e < exprs.length) {
            allConst = exprs[e] instanceof ConstantValue;
            ++e;
        }
        return allConst;
    }

    public void warnDiscouragedNames(String name, EObject cause, EStructuralFeature causingFeature) {
        if ("Version".equals(name)) {
            this.warning("'Version' is discouraged due to possible future language extensions", cause, causingFeature, 20214);
        }
    }
}

