/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.ssehub.easy.basics.Environment;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.os.UnixOperations;

public class JavaUtilities {
    public static final String JDK_PATH = JavaUtilities.determineJDKDir();
    public static final String[] JRE_CLASS_PATH = JavaUtilities.determineJREClassPath();

    private JavaUtilities() {
    }

    private static String determineJDKDir() {
        String jdkPath = System.getProperty("java.home");
        if (jdkPath == null || jdkPath.length() == 0) {
            jdkPath = System.getenv("JAVA_HOME");
        }
        try {
            if (jdkPath == null || !new File(jdkPath).exists()) {
                if (Environment.isWinOS()) {
                    String path = JavaUtilities.getCommandOutput("where javac");
                    if (path != null && !path.isEmpty()) {
                        File javacFile = new File(path);
                        File jdkInstallationDir = javacFile.getParentFile().getParentFile();
                        jdkPath = jdkInstallationDir.getAbsolutePath();
                    }
                } else {
                    int pathStartIndex;
                    String response = JavaUtilities.getCommandOutput("which javac");
                    if (response != null && (pathStartIndex = response.indexOf(47)) != -1) {
                        String path = response.substring(pathStartIndex, response.length());
                        try {
                            File javacFile = UnixOperations.resolveSymbolicLink((File)new File(path));
                            File jdkInstallationDir = javacFile.getParentFile().getParentFile();
                            jdkPath = jdkInstallationDir.getAbsolutePath();
                        }
                        catch (IOException e) {
                            EASyLoggerFactory.INSTANCE.getLogger(JavaUtilities.class, "net.ssehub.easy.instantiation.core").exception((Exception)e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            EASyLoggerFactory.INSTANCE.getLogger(JavaUtilities.class, "net.ssehub.easy.instantiation.core").exception(e);
        }
        return jdkPath;
    }

    private static String getCommandOutput(String command) {
        String output;
        block30: {
            output = null;
            Process process = null;
            BufferedReader reader = null;
            InputStreamReader streamReader = null;
            InputStream stream = null;
            try {
                try {
                    process = Runtime.getRuntime().exec(command);
                    stream = process.getInputStream();
                    streamReader = new InputStreamReader(stream);
                    reader = new BufferedReader(streamReader);
                    String currentLine = null;
                    StringBuilder commandOutput = new StringBuilder();
                    while ((currentLine = reader.readLine()) != null) {
                        commandOutput.append(currentLine);
                    }
                    int returnCode = process.waitFor();
                    if (returnCode == 0) {
                        output = commandOutput.toString();
                    }
                }
                catch (Exception e) {
                    EASyLoggerFactory.INSTANCE.getLogger(JavaUtilities.class, "net.ssehub.easy.instantiation.core").exception(e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException e2) {
                            EASyLoggerFactory.INSTANCE.getLogger(JavaUtilities.class, "net.ssehub.easy.instantiation.core").exception((Exception)e2);
                        }
                    }
                    if (streamReader != null) {
                        try {
                            streamReader.close();
                        }
                        catch (IOException e3) {
                            EASyLoggerFactory.INSTANCE.getLogger(JavaUtilities.class, "net.ssehub.easy.instantiation.core").exception((Exception)e3);
                        }
                    }
                    if (reader == null) break block30;
                    try {
                        streamReader.close();
                    }
                    catch (IOException e4) {
                        System.err.println("Cannot close stream input reader! " + String.valueOf(e4));
                    }
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(JavaUtilities.class, "net.ssehub.easy.instantiation.core").exception((Exception)e);
                    }
                }
                if (streamReader != null) {
                    try {
                        streamReader.close();
                    }
                    catch (IOException e) {
                        EASyLoggerFactory.INSTANCE.getLogger(JavaUtilities.class, "net.ssehub.easy.instantiation.core").exception((Exception)e);
                    }
                }
                if (reader != null) {
                    try {
                        streamReader.close();
                    }
                    catch (IOException e) {
                        System.err.println("Cannot close stream input reader! " + String.valueOf(e));
                    }
                }
            }
        }
        return output;
    }

    private static String[] determineJREClassPath() {
        String tmpClasspath = System.getProperty("java.class.path");
        String[] result = (tmpClasspath = tmpClasspath.replace("\\", "/")).split(File.pathSeparator);
        if (result == null) {
            String fallback = JDK_PATH + "lib/rt.jar";
            File f = new File(fallback);
            result = f.exists() ? new String[]{JDK_PATH + "lib/rt.jar"} : new String[]{};
        }
        return result;
    }

    public static boolean isJava9() {
        return System.getProperty("java.version").startsWith("9.");
    }
}

