/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.apache.commons.io.FilenameUtils;

public class FileUtils {
    private FileUtils() {
    }

    static void delete(File file) throws VilException {
        block7: {
            if (file.exists()) {
                try {
                    if (FileUtils.isDirectory(file)) {
                        try {
                            org.apache.commons.io.FileUtils.deleteDirectory((File)file);
                            break block7;
                        }
                        catch (IOException e) {
                            throw new VilException(e.getMessage(), 50001);
                        }
                    }
                    if (!file.delete()) {
                        throw new VilException("cannot delete " + file.getAbsolutePath(), 50001);
                    }
                }
                catch (SecurityException e) {
                    throw new VilException(e, 30001);
                }
            }
        }
    }

    static void rename(File file, File newFile) throws VilException {
        try {
            file.renameTo(newFile);
        }
        catch (SecurityException e) {
            throw new VilException(e, 30001);
        }
    }

    static void rename(File file, String name) throws VilException {
        FileUtils.rename(file, new File(name));
    }

    static List<IFileSystemArtifact> move(IFileSystemArtifact source, IFileSystemArtifact target) throws VilException {
        return FileUtils.copyOrMove(source, target, true);
    }

    static Set<IFileSystemArtifact> copyOrMove(Path source, IFileSystemArtifact target, boolean move) throws VilException {
        ArrayList<IFileSystemArtifact> result = new ArrayList<IFileSystemArtifact>();
        Path tp = target.getPath();
        File tf = tp.getAbsolutePath();
        if (!tf.exists() && FileUtils.isDirectory(tf)) {
            tf.mkdirs();
        }
        ArtifactModel tm = tp.getArtifactModel();
        Set<FileArtifact> artifacts = source.selectAll();
        if (artifacts.size() == 0 && FileUtils.hasFiles(source.getAbsolutePath())) {
            ArrayList arts = new ArrayList();
            ScanResult res = new ScanResult(arts);
            FileUtils.scan(source.getAbsolutePath(), null, 0L, res, FileArtifact.class);
            artifacts = new ListSet(arts, FileArtifact.class);
        }
        for (FileArtifact f : artifacts) {
            Path sp = f.getPath();
            File destinationFile = FileUtils.determineDestination(source, f, tf);
            ArtifactModel sm = move ? sp.getArtifactModel() : null;
            FileUtils.copyOrMove(sp.getAbsolutePath(), destinationFile, sm, tm, result);
        }
        return new ListSet<IFileSystemArtifact>(result, IFileSystemArtifact.class);
    }

    public static boolean hasFiles(File file) {
        boolean result = false;
        if (file.isFile()) {
            result = file.exists();
        } else if (file.isDirectory()) {
            File[] dir = file.listFiles();
            result = dir != null && dir.length > 0;
        }
        return result;
    }

    private static List<IFileSystemArtifact> copyOrMove(IFileSystemArtifact source, IFileSystemArtifact target, boolean move) throws VilException {
        ArrayList<IFileSystemArtifact> result = new ArrayList<IFileSystemArtifact>();
        Path sp = source.getPath();
        Path tp = target.getPath();
        if (!sp.isPattern() && !tp.isPattern()) {
            File sf = sp.getAbsolutePath();
            File tf = tp.getAbsolutePath();
            if (!tf.exists() && FileUtils.isDirectory(tf)) {
                tf.mkdirs();
            }
            ArtifactModel sm = move ? sp.getArtifactModel() : null;
            FileUtils.copyOrMove(sf, tf, sm, tp.getArtifactModel(), result);
        }
        return result;
    }

    private static void copyOrMove(File source, File target, ArtifactModel sourceModel, ArtifactModel targetModel, List<IFileSystemArtifact> artifacts) throws VilException {
        if (source.isDirectory()) {
            File[] files;
            if (target.isFile()) {
                target = target.getParentFile();
            }
            if ((files = source.listFiles()) != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        target = new File(target, f.getName());
                        target.mkdir();
                    }
                    FileUtils.copyOrMove(f, target, sourceModel, targetModel, artifacts);
                    ++n2;
                }
            }
        } else {
            boolean move;
            boolean bl = move = sourceModel != null;
            if (move) {
                sourceModel.delete(source);
            }
            try {
                if (target.isDirectory()) {
                    if (move) {
                        org.apache.commons.io.FileUtils.moveFileToDirectory((File)source, (File)target, (boolean)true);
                    } else {
                        org.apache.commons.io.FileUtils.copyFileToDirectory((File)source, (File)target, (boolean)false);
                    }
                    target = new File(target, source.getName());
                } else {
                    boolean executable = source.canExecute();
                    boolean writable = source.canWrite();
                    if (move) {
                        org.apache.commons.io.FileUtils.moveFile((File)source, (File)target);
                    } else {
                        org.apache.commons.io.FileUtils.copyFile((File)source, (File)target, (boolean)false);
                    }
                    target.setExecutable(executable);
                    target.setWritable(writable);
                }
            }
            catch (IOException e) {
                throw new VilException(e, 50001);
            }
            IFileSystemArtifact artifact = ArtifactFactory.createArtifact(IFileSystemArtifact.class, target, targetModel);
            if (artifacts != null) {
                artifacts.add(artifact);
            }
        }
    }

    static List<IFileSystemArtifact> copy(IFileSystemArtifact source, IFileSystemArtifact target) throws VilException {
        return FileUtils.copyOrMove(source, target, false);
    }

    public static boolean isFile(String path) {
        int lastDotPos;
        boolean isFile = true;
        int lastSepPos = (path = FilenameUtils.normalize((String)path, (boolean)true)).lastIndexOf(47);
        isFile = lastSepPos == path.length() - 1 ? false : (lastDotPos = path.lastIndexOf(46)) >= 0 && lastDotPos > lastSepPos;
        return isFile;
    }

    public static boolean isFile(File file) {
        boolean isFile = !file.exists() ? FileUtils.isFile(file.getAbsolutePath()) : file.isFile();
        return isFile;
    }

    public static boolean isDirectory(File file) {
        boolean isDirectory = !file.exists() ? !FileUtils.isFile(file.getAbsolutePath()) : file.isDirectory();
        return isDirectory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends IArtifact> void scan(File location, ArtifactModel model, long timestamp, ScanResult<T> result, Class<T> type) {
        if (location == null) return;
        if (location.isDirectory()) {
            File[] files = location.listFiles();
            if (files == null) return;
            int f = 0;
            while (f < files.length) {
                FileUtils.scan(files[f], model, timestamp, result, type);
                ++f;
            }
            return;
        } else {
            if (PathUtils.normalizeTime(location) < timestamp) return;
            try {
                T artifact = ArtifactFactory.createArtifact(type, location, model);
                if (result == null || result.result == null) return;
                result.result.add(artifact);
                return;
            }
            catch (VilException e) {
                if (result == null || result.errors == null) return;
                result.errors.add(e);
            }
        }
    }

    public static File getTempDirectory() {
        return org.apache.commons.io.FileUtils.getTempDirectory();
    }

    private static File determineDestination(Path sourcePath, FileArtifact sourceArtefakt, File targetFile) {
        String srcFile = sourceArtefakt.getPath().getPath();
        String relativeFile = sourcePath.getArtifactModel().makeRelative(srcFile);
        String relativeDir = sourcePath.getArtifactModel().makeRelative(sourcePath.getAbsolutePath());
        String[] segmentsDir = relativeDir.split("/");
        String[] segmentsFile = relativeFile.split("/");
        boolean constantPart = true;
        int variableSegment = 0;
        int i = 0;
        int end = Math.min(segmentsDir.length, segmentsFile.length);
        while (i < end && constantPart) {
            if (segmentsDir[i].equals(segmentsFile[i])) {
                ++variableSegment;
            } else {
                constantPart = false;
            }
            ++i;
        }
        StringBuffer variablePart = new StringBuffer();
        int i2 = variableSegment;
        while (i2 < segmentsFile.length) {
            variablePart.append(segmentsFile[i2]);
            variablePart.append("/");
            ++i2;
        }
        return new File(targetFile, variablePart.toString());
    }

    public static class ScanResult<T extends IArtifact> {
        private List<T> result;
        private List<VilException> errors;

        public ScanResult(List<T> result) {
            this(result, new ArrayList<VilException>());
        }

        public ScanResult(List<T> result, List<VilException> errors) {
            this.result = result;
            this.errors = errors;
        }

        public void checkForException() throws VilException {
            if (this.errors != null && !this.errors.isEmpty()) {
                throw new VilException(this.errors);
            }
        }
    }
}

