/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel;

import java.io.File;
import java.io.IOException;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.DefaultFolderArtifactCreator;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileSystemArtifactOperations;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactChangedListener;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.SimpleArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

@ArtifactCreator(value=DefaultFolderArtifactCreator.class)
public class FolderArtifact
extends SimpleArtifact
implements IFileSystemArtifact,
IArtifactChangedListener,
IActualValueProvider {
    @DefaultValue
    public static final FolderArtifact DEFAULT = new FolderArtifact();
    private Path path;
    private boolean isTemporary;

    FolderArtifact() {
    }

    protected FolderArtifact(Path path) {
        this.path = path;
    }

    protected FolderArtifact(File file, ArtifactModel model) {
        this.path = Path.createInstance(file, model);
    }

    public static FolderArtifact create() throws VilException {
        try {
            File file = File.createTempFile("folderArtifact", "");
            file.delete();
            file.mkdirs();
            file.deleteOnExit();
            FolderArtifact result = ArtifactFactory.createArtifact(FolderArtifact.class, file, null);
            result.isTemporary = true;
            return result;
        }
        catch (IOException e) {
            throw new VilException(e, 50001);
        }
    }

    @Override
    @OperationMeta(storeArtifactsBefore=true)
    public void delete() throws VilException {
        this.path.delete();
    }

    @Override
    public String getName() throws VilException {
        return this.path.getName();
    }

    @Override
    @OperationMeta(storeArtifactsBefore=true)
    public void rename(String name) throws VilException {
        this.path.getArtifactModel().beforeRename(this);
        this.path = this.path.rename(name);
        this.path.getArtifactModel().afterRename(this);
    }

    @Override
    public Text getText() throws VilException {
        return Text.CONSTANT_EMPTY;
    }

    @Override
    public Binary getBinary() throws VilException {
        return Binary.CONSTANT_EMPTY;
    }

    @Override
    public void accept(IArtifactVisitor visitor) {
        visitor.visitFolderArtifact(this);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    @ReturnGenerics(value={IFileSystemArtifact.class})
    @OperationMeta(storeArtifactsBefore=true)
    public Set<IFileSystemArtifact> move(IFileSystemArtifact target) throws VilException {
        return new ListSet<IFileSystemArtifact>(FileUtils.move(this, target), IFileSystemArtifact.class);
    }

    @Override
    @ReturnGenerics(value={IFileSystemArtifact.class})
    @OperationMeta(storeArtifactsBefore=true)
    public Set<IFileSystemArtifact> copy(IFileSystemArtifact target) throws VilException {
        return new ListSet<IFileSystemArtifact>(FileUtils.copy(this, target), IFileSystemArtifact.class);
    }

    public Set<FileArtifact> selectAll() throws VilException {
        return this.getPath().selectAll();
    }

    @Override
    public void artifactChanged(Object cause) throws VilException {
    }

    @Invisible
    @Conversion
    public static FolderArtifact convert(String val) {
        File file = new File(val);
        return new FolderArtifact(file, ArtifactFactory.findModel(file));
    }

    @Invisible
    @Conversion
    public static Path convert(FolderArtifact val) throws VilException {
        return val.getPath();
    }

    @Invisible
    @Conversion
    public static FolderArtifact convert(Path path) throws VilException {
        return new FolderArtifact(path);
    }

    @Override
    public long lastModification() {
        return this.path.lastModification();
    }

    @Override
    public boolean exists() {
        return this.path.exists();
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        String result = comparator != null && comparator.inTracer() && this.isTemporary() ? "<temp>" : this.path.getPath();
        return result;
    }

    @Override
    public void store() throws VilException {
    }

    @Override
    public boolean isTemporary() {
        return this.isTemporary && this.path.isTemporary();
    }

    @Override
    public void update() throws VilException {
    }

    @Override
    public Object determineActualValue(Object object) {
        FileArtifact file;
        Object result = object;
        if (object instanceof FileArtifact && !(file = (FileArtifact)object).exists()) {
            Path path = file.getPath();
            result = new FolderArtifact(path);
        }
        return result;
    }

    @Override
    public void setExecutable(boolean ownerOnly) throws VilException {
        FileSystemArtifactOperations.setExecutable(this, ownerOnly);
    }
}

