/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.representation;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactChangedListener;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.AbstractArtifactRepresentation;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import org.apache.commons.io.FileUtils;

public class Binary
extends AbstractArtifactRepresentation
implements IArtifactChangedListener,
IStringValueProvider {
    public static final Binary CONSTANT_EMPTY = new Binary(false);
    private byte[] data;
    private File file;

    public Binary(boolean modifiable) {
        super(modifiable);
        this.data = new byte[0];
    }

    public Binary(String text, boolean modifiable) throws VilException {
        super(modifiable);
        this.data = text.getBytes();
        this.updateContents();
    }

    public Binary(File file, boolean modifiable) throws VilException {
        super(modifiable);
        this.file = file;
        this.updateContents();
    }

    @Override
    public void updateContents() throws VilException {
        if (this.isModifiable() && this.file != null) {
            try {
                this.data = FileUtils.readFileToByteArray((File)this.file);
            }
            catch (IOException e) {
                throw new VilException(e, 50001);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public void artifactChanged(Object cause) throws VilException {
        this.updateContents();
    }

    @Invisible
    public void write(OutputStream out) throws IOException {
        out.write(this.data);
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "<binary>";
    }
}

