/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.artifactModel.xml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.io.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.xml.Dtd;

public class DtdParser {
    private static final String DOCTYPE = "<!DOCTYPE";

    public static Dtd extractDTD(File file) throws FileNotFoundException {
        return DtdParser.checkForDTD(DtdParser.readFile(file));
    }

    public static Dtd extractDTD(InputStream in) {
        return DtdParser.checkForDTD(DtdParser.readFile(in));
    }

    private static Dtd checkForDTD(List<String> stringList) {
        ArrayList<String> dtdContent = new ArrayList<String>();
        Dtd dtd = new Dtd();
        int openBrackets = 0;
        int current = 0;
        int start = -1;
        String string = "";
        Object subString = "";
        int i = 0;
        while (i < stringList.size()) {
            string = stringList.get(i);
            start = string.toLowerCase().indexOf(DOCTYPE.toLowerCase());
            if (start >= 0) {
                current = start + DOCTYPE.length();
                dtd.setLine(i);
                subString = DOCTYPE;
                ++openBrackets;
            }
            while (openBrackets > 0 && current < string.length()) {
                if (string.charAt(current) == '<') {
                    ++openBrackets;
                } else if (string.charAt(current) == '>') {
                    --openBrackets;
                }
                subString = (String)subString + string.charAt(current);
                ++current;
            }
            if (openBrackets > 0) {
                start = -1;
            }
            if (((String)subString).length() > 0) {
                dtdContent.add((String)subString);
            }
            subString = "";
            current = 0;
            ++i;
        }
        dtd.setContent(dtdContent);
        return dtd;
    }

    public static void writeDtd(File file, Dtd dtd) throws FileNotFoundException {
        List<String> oldContent = DtdParser.readFile(file);
        BufferedWriter writer = null;
        if (dtd != null && file != null) {
            try {
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    int i = 0;
                    while (i < oldContent.size()) {
                        if (i == dtd.getLine()) {
                            List<String> dtdContent = dtd.getContent();
                            int j = 0;
                            while (j < dtdContent.size()) {
                                writer.write(dtdContent.get(j));
                                writer.write("\r\n");
                                ++j;
                            }
                        }
                        writer.write(oldContent.get(i));
                        writer.write("\r\n");
                        ++i;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static List<String> readFile(File file) throws FileNotFoundException {
        List<String> result = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            result = DtdParser.readFile(fis);
            fis.close();
        }
        catch (IOException e) {
            FileUtils.closeQuietly(fis);
        }
        if (result == null) {
            result = new ArrayList<String>();
        }
        return result;
    }

    private static List<String> readFile(InputStream in) {
        ArrayList<String> stringList = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) {
                    if (stringList.size() <= 0) continue;
                    Object addString = (String)stringList.get(stringList.size() - 1);
                    addString = (String)addString + "\r\n";
                    stringList.remove(stringList.size() - 1);
                    stringList.add((String)addString);
                    continue;
                }
                stringList.add(line);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return stringList;
    }
}

