/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.net.URI;
import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Message;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.DefaultImportResolver;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VtlRule;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;

public class BuildLangImportResolver
extends DefaultImportResolver<Script> {
    protected void cannotResolveImport(ModelImport<Script> imp, List<IMessage> messages, URI modelURI, IRestrictionEvaluationContext context) {
        try {
            Template template = (Template)TemplateModel.INSTANCE.resolve(imp.getName(), imp.getVersionRestriction(), modelURI, context);
            if (template != null && 2 == template.getParameterCount()) {
                Script tmpScript = new Script(template.getName());
                int d = 0;
                while (d < template.getDefCount()) {
                    Def def = template.getDef(d);
                    if (!def.isProtected()) {
                        tmpScript.addRule(new VtlRule(def, tmpScript));
                    }
                    ++d;
                }
                int t = 0;
                while (t < template.getTypedefCount()) {
                    tmpScript.addTypedef(template.getTypedef(t));
                    ++t;
                }
                int c = 0;
                while (c < template.getCompoundCount()) {
                    tmpScript.addCompound(template.getCompound(c));
                    ++c;
                }
                imp.setResolved((IModel)tmpScript);
            } else {
                super.cannotResolveImport(imp, messages, modelURI, context);
            }
        }
        catch (ModelManagementException e) {
            messages.add((IMessage)new Message(e.getMessage(), Status.ERROR));
        }
    }
}

