/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class JoinExpression
extends Expression {
    private JoinVariableDeclaration[] joinVariables;
    private JoinVariableDeclaration[] visibleVariables;
    private Expression condition;
    private TypeDescriptor<?> type;

    public JoinExpression(JoinVariableDeclaration[] joinVariables, Expression condition) throws VilException {
        if (joinVariables == null || joinVariables.length == 0) {
            throw new VilException("no join variables given", 70001);
        }
        if (1 == joinVariables.length) {
            throw new VilException("not enough join variables given", 70001);
        }
        this.joinVariables = joinVariables;
        int visibleCount = 0;
        int j = 0;
        while (j < joinVariables.length) {
            if (!joinVariables[j].isExcluded()) {
                ++visibleCount;
            }
            ++j;
        }
        if (joinVariables.length == 0) {
            throw new VilException("at least one join variable must be visible (i.e., not all must be excluded)", 70001);
        }
        this.visibleVariables = new JoinVariableDeclaration[visibleCount];
        visibleCount = 0;
        j = 0;
        while (j < joinVariables.length) {
            if (!joinVariables[j].isExcluded()) {
                this.visibleVariables[visibleCount++] = joinVariables[j];
            }
            ++j;
        }
        if (condition != null) {
            this.condition = condition;
            if (!TypeRegistry.booleanType().isAssignableFrom(this.condition.inferType())) {
                throw new VilException("join expression must be boolean", 70001);
            }
        }
    }

    public int getVariablesCount() {
        return this.joinVariables.length;
    }

    public JoinVariableDeclaration getVariable(int index) {
        return this.joinVariables[index];
    }

    public int getVisibleVariablesCount() {
        return this.visibleVariables.length;
    }

    public JoinVariableDeclaration getVisibleVariable(int index) {
        return this.visibleVariables[index];
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        if (this.type == null) {
            TypeDescriptor<?>[] tmp = TypeDescriptor.createArray(this.visibleVariables.length);
            int j = 0;
            while (j < this.visibleVariables.length) {
                tmp[j] = this.visibleVariables[j].getType();
                if (tmp[j].getGenericParameterCount() > 0) {
                    tmp[j] = tmp[j].getGenericParameterType(0);
                }
                ++j;
            }
            this.type = TypeRegistry.getSequenceType(tmp);
        }
        return this.type;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IVisitor ? ((IVisitor)((Object)visitor)).visitJoinExpression(this) : visitor.visitExpression(this);
        return result;
    }
}

