/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class JoinVariableDeclaration
extends VariableDeclaration {
    private boolean exclude;

    public JoinVariableDeclaration(String name, Expression expr, boolean exclude) throws VilException {
        super(name, JoinVariableDeclaration.getJoinVariableType(expr), false, expr);
        this.exclude = exclude;
    }

    private static TypeDescriptor<?> getJoinVariableType(Expression expr) throws VilException {
        TypeDescriptor<?> exprType = expr.inferType();
        if (exprType.isCollection() && 1 != exprType.getGenericParameterCount()) {
            throw new VilException("parameter must be set or sequence with one generic type", 70001);
        }
        return exprType.getGenericParameterType(0);
    }

    public boolean isExcluded() {
        return this.exclude;
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitJoinVariableDeclaration(this);
    }
}

