/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ProjectElement;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;

public abstract class RuleBlock
extends ProjectElement
implements IRuleBlock {
    private IRuleElement[] body;

    protected RuleBlock(String name, IRuleElement[] body) {
        super(name);
        this.body = body;
    }

    @Override
    public int getBodyElementCount() {
        return this.body == null ? 0 : this.body.length;
    }

    @Override
    public IRuleElement getBodyElement(int index) {
        if (this.body == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.body[index];
    }

    protected void append(IRuleElement elt) {
        if (elt != null) {
            if (this.body == null) {
                this.body = new IRuleElement[1];
            } else {
                IRuleElement[] tmp = new IRuleElement[this.body.length + 1];
                System.arraycopy(this.body, 0, tmp, 0, this.body.length);
                this.body = tmp;
            }
            this.body[this.body.length - 1] = elt;
            if (elt instanceof ProjectElement) {
                ((ProjectElement)((Object)elt)).setParent(this);
            }
        }
    }

    public void setBody(IRuleElement[] body) {
        this.body = body;
        this.setParent(this.getParent());
    }

    public static IRuleElement[] addBodyElement(IRuleElement[] body, int index, IRuleElement elt) {
        ArrayList<IRuleElement> tmp = new ArrayList<IRuleElement>();
        if (body != null) {
            int i = 0;
            while (i < body.length) {
                tmp.add(body[i]);
                ++i;
            }
            tmp.add(index, elt);
        } else {
            tmp.add(elt);
        }
        body = new IRuleElement[tmp.size()];
        return tmp.toArray(body);
    }

    @Override
    public void addBodyElement(int index, IRuleElement elt) {
        this.body = RuleBlock.addBodyElement(this.body, index, elt);
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        int b = 0;
        while (b < this.getBodyElementCount()) {
            IRuleElement elt = this.getBodyElement(b);
            if (elt instanceof ProjectElement) {
                ((ProjectElement)((Object)elt)).setParent(this);
            }
            ++b;
        }
    }
}

