/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Resolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleExecutionContext;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class RuleExecutionResult
implements IVilType,
IStringValueProvider {
    public static final TypeDescriptor<?> TYPE;
    private Status status;
    private List<IArtifact> result;
    private List<IArtifact> allResults;
    private String failReason;
    private Integer failCode;
    private boolean hasChanges;

    static {
        TypeDescriptor<RuleExecutionResult> type;
        try {
            type = TypeRegistry.DEFAULT.registerType(RuleExecutionResult.class);
        }
        catch (VilException e) {
            type = TypeRegistry.voidType();
            EASyLoggerFactory.INSTANCE.getLogger(Resolver.class, "net.ssehub.easy.instantiation.core").exception((Exception)((Object)e));
        }
        TYPE = type;
    }

    public RuleExecutionResult(Status status, RuleExecutionContext context) {
        this.status = status;
        this.result = RuleExecutionResult.transfer(context.resultAsCollection());
        this.allResults = RuleExecutionResult.transfer(context.allResultsAsCollection());
        this.failReason = context.getFailReason();
        this.failCode = context.getFailCode();
    }

    private static List<IArtifact> transfer(Collection<IArtifact> in) {
        ArrayList<IArtifact> result = new ArrayList<IArtifact>(in.size());
        result.addAll(in);
        return result;
    }

    @ReturnGenerics(value={IArtifact.class})
    public Set<IArtifact> result() {
        return new ListSet<IArtifact>(this.result, IArtifact.class);
    }

    @ReturnGenerics(value={IArtifact.class})
    public Set<IArtifact> allResults() {
        return new ListSet<IArtifact>(this.allResults, IArtifact.class);
    }

    Collection<IArtifact> allResultsAsCollection() {
        return this.allResults;
    }

    Collection<IArtifact> resultAsCollection() {
        return this.result;
    }

    @Invisible
    public Status getStatus() {
        return this.status;
    }

    @Invisible
    public void fail() {
        this.status = Status.FAIL;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public Integer getFailCode() {
        return this.failCode;
    }

    public void setChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Invisible
    @Conversion
    @ReturnGenerics(value={IArtifact.class})
    public static Set<IArtifact> convert(RuleExecutionResult res) {
        return res.result();
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "RuleExecutionResult " + String.valueOf((Object)this.getStatus());
    }

    public static enum Status {
        SUCCESS,
        FAIL,
        NOT_APPLICABLE;


        public static Status toStatus(Object object) {
            Status result = object instanceof Status ? (Status)((Object)object) : (object != null ? SUCCESS : FAIL);
            return result;
        }
    }
}

