/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.io.Writer;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangWriter;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IBuildlangElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IEnumeratingLoop;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.ITraceFilter;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;

public class StreamTracer
extends net.ssehub.easy.instantiation.core.model.common.StreamTracer
implements ITracer {
    private boolean emitFailed;

    public StreamTracer(Writer out, String ... baseFolder) {
        super(out, baseFolder);
    }

    public StreamTracer(Writer out, boolean emitFailed, String ... baseFolder) {
        super(out, baseFolder);
        this.emitFailed = emitFailed;
    }

    @Override
    public void setTraceFilter(ITraceFilter filter) {
    }

    @Override
    public ITraceFilter getTraceFilter() {
        return null;
    }

    @Override
    public void visitRule(Rule rule, RuntimeEnvironment<?, ?> environment) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.print("-> " + rule.getName() + "(");
            int i = 0;
            while (i < rule.getParameterCount()) {
                if (i > 0) {
                    this.print(", ");
                }
                this.print(rule.getParameter(i).getType().getVilName());
                ++i;
            }
            this.print(")");
            if (rule.getParameterCount() > 0) {
                this.print(" with (");
                i = 0;
                while (i < rule.getParameterCount()) {
                    if (i > 0) {
                        this.print(", ");
                    }
                    try {
                        String arg = StringValueHelper.getStringValue(environment.getValue(rule.getParameter(i)), NORMALIZER);
                        this.print(this.makeRelative(arg));
                    }
                    catch (VilException e) {
                        this.print("<null>");
                    }
                    ++i;
                }
                this.print(")");
            }
            this.println();
            this.increaseIndentation();
        }
    }

    @Override
    public void visitedRule(Rule rule, RuntimeEnvironment<?, ?> environment, Object result) {
        if (this.isEnabled()) {
            this.decreaseIndentation();
        }
    }

    @Override
    public void visitLoop(IEnumeratingLoop loop, RuntimeEnvironment<?, ?> environment) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.print(loop.getElementName());
            this.println(" {");
            this.increaseIndentation();
        }
    }

    @Override
    public void visitIteratorAssignment(IEnumeratingLoop loop, VariableDeclaration var, Object value) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.print(loop.getElementName());
            this.print(": ");
            this.printValueDefined(var, null, value);
            this.println();
        }
    }

    @Override
    public void visitedLoop(IEnumeratingLoop loop, RuntimeEnvironment<?, ?> environment) {
        if (this.isEnabled()) {
            this.decreaseIndentation();
            this.printIndentation();
            this.println("}");
        }
    }

    @Override
    public Collection<?> adjustSequenceForMap(Collection<?> collection) {
        return StringValueHelper.sortCollection(collection, NORMALIZER);
    }

    @Override
    public Collection<Object> adjustSequenceForJoin(Collection<Object> collection) {
        return StringValueHelper.sortCollection(collection, NORMALIZER);
    }

    @Override
    public void visitSystemCall(String[] args) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.print("system call(");
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    this.print(", ");
                }
                this.print(args[i]);
                ++i;
            }
            this.println(")");
        }
    }

    @Override
    public void visitingInstantiator(String name) {
    }

    @Override
    public void visitedInstantiator(String name, Object result) {
    }

    @Override
    public void failedAt(IBuildlangElement element) {
        if (this.emitFailed && this.isEnabled()) {
            this.print("failed at: ");
            BuildlangWriter writer = new BuildlangWriter(this.getOut());
            try {
                element.accept(writer);
            }
            catch (VilException vilException) {
                // empty catch block
            }
            this.println();
        }
    }

    @Override
    protected ExpressionWriter getWriter(Writer out) {
        return new BuildlangWriter(this.getOut());
    }

    @Override
    public void visitScript(Script script, RuntimeEnvironment<?, ?> environment) {
    }

    @Override
    public void visitScriptBody(Script script, RuntimeEnvironment<?, ?> environment) {
    }

    @Override
    public void visitedScript(Script script) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void visitAlternative(boolean takeIf) {
        if (this.isEnabled()) {
            this.printIndentation();
            this.print("visit ");
            if (takeIf) {
                this.println("if-branch");
            } else {
                this.println("else-branch");
            }
        }
    }

    @Override
    public void visitWhileBody() {
        if (this.isEnabled()) {
            this.printIndentation();
            this.println("while body {");
            this.increaseIndentation();
        }
    }

    @Override
    public void visitedWhileBody() {
        if (this.isEnabled()) {
            this.decreaseIndentation();
            this.printIndentation();
            this.println("}");
        }
    }
}

