/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionVersionRestriction;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class Utils {
    private Utils() {
    }

    public static ExpressionVersionRestriction createSingleRestriction(Script parent, String operation, Version version) throws RestrictionEvaluationException {
        try {
            TypeDescriptor<?> versionType = TypeRegistry.versionType();
            VariableDeclaration var = new VariableDeclaration("version", versionType);
            ConstantExpression verExpr = new ConstantExpression(versionType, version, TypeRegistry.DEFAULT);
            CallExpression expr = new CallExpression((Object)parent, operation, new VariableExpression(var), verExpr);
            ((Expression)expr).inferType();
            return new ExpressionVersionRestriction(expr, var);
        }
        catch (VilException e) {
            throw new RestrictionEvaluationException(e.getMessage(), e.getId());
        }
    }

    public static ExpressionStatement findLastExpressionStatement(IRuleBlock block) {
        ExpressionStatement expr = null;
        int e = block.getBodyElementCount() - 1;
        while (expr == null && e >= 0) {
            IRuleElement elt = block.getBodyElement(e);
            if (elt instanceof ExpressionStatement) {
                expr = (ExpressionStatement)elt;
            }
            --e;
        }
        return expr;
    }

    public static Expression findLastExpression(IRuleBlock block) {
        ExpressionStatement stmt = Utils.findLastExpressionStatement(block);
        return stmt == null ? null : stmt.getExpression();
    }
}

