/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch;

import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactTypes;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.IMatchVisitor;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public abstract class AbstractRuleMatchExpression
extends Expression {
    public abstract TypeDescriptor<?> getEntryType();

    public abstract Object determineExpected(AbstractRuleMatchExpression var1, Object var2) throws VilException;

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IMatchVisitor ? this.accept((IMatchVisitor)((Object)visitor)) : visitor.visitExpression(this);
        return result;
    }

    protected abstract Object accept(IMatchVisitor var1) throws VilException;

    public abstract boolean contributesTo(AbstractRuleMatchExpression var1);

    public TypeDescriptor<? extends Collection<? extends IArtifact>> inferType() throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = ArtifactTypes.artifactType();
        return AbstractRuleMatchExpression.ensureType(TypeRegistry.getCollectionType(param));
    }

    public abstract Collection<?> evaluate(IExpressionVisitor var1) throws VilException;

    protected static TypeDescriptor<? extends Collection<? extends IArtifact>> ensureType(TypeDescriptor<?> type) throws VilException {
        TypeDescriptor<?> result;
        if (!type.isCollection()) {
            throw new VilException(type.getVilName() + "is not a collection", 70001);
        }
        if (type.getGenericParameterCount() != 1) {
            throw new VilException("collection in " + type.getVilName() + "is not generic over one type", 70001);
        }
        if (!ArtifactTypes.artifactType().isAssignableFrom(type.getGenericParameterType(0))) {
            throw new VilException("collection in " + type.getVilName() + "is not generic over one type", 70001);
        }
        try {
            result = type;
        }
        catch (ClassCastException e) {
            throw new VilException(e.getMessage(), 70001);
        }
        return result;
    }
}

