/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.execution;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.NoTracer;
import net.ssehub.easy.instantiation.core.model.common.ITraceFilter;
import net.ssehub.easy.instantiation.core.model.common.NoTraceFilter;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;

public abstract class TracerFactory {
    public static final TracerFactory DEFAULT = new DefaultTracerFactory();
    public static final Map<Thread, ITracer> TEMPLATELANG_TRACERS = new HashMap<Thread, ITracer>();
    public static final Map<Thread, net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer> BUILDLANG_TRACERS = new HashMap<Thread, net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer>();
    public static final Map<ProgressObserver, TaskData> PROGRESS_OBSERVERS = new HashMap<ProgressObserver, TaskData>();
    public static final IInstantiatorTracer EMPTY_INSTANTIATOR_TRACER = new IInstantiatorTracer(){

        @Override
        public void traceMessage(String message) {
        }

        @Override
        public void traceError(String message) {
        }
    };
    private static TracerFactory defaultFactory = DEFAULT;
    private static Map<Long, TracerFactory> instances = new HashMap<Long, TracerFactory>();
    private static ITraceFilter filter = NoTraceFilter.INSTANCE;

    public static TracerFactory getDefaultInstance() {
        return defaultFactory;
    }

    public static void setDefaultInstance(TracerFactory factory) {
        if (factory != null) {
            defaultFactory = factory;
        }
    }

    public static void setInstance(TracerFactory newInstance) {
        long threadId = Thread.currentThread().getId();
        if (newInstance != null) {
            instances.put(threadId, newInstance);
        } else {
            instances.remove(threadId);
        }
    }

    public static TracerFactory getInstance() {
        TracerFactory result = instances.get(Thread.currentThread().getId());
        if (result == null) {
            result = defaultFactory;
        }
        return result;
    }

    public static ITraceFilter setTraceFilter(ITraceFilter fInstance) {
        ITraceFilter result = filter;
        if (fInstance != null) {
            filter = fInstance;
        }
        return result;
    }

    public static ITraceFilter getTraceFilter() {
        return filter;
    }

    public abstract ITracer createTemplateLanguageTracerImpl();

    public abstract net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer createBuildLanguageTracerImpl();

    public abstract IInstantiatorTracer createInstantiatorTracerImpl();

    public static ITracer createTemplateLanguageTracer() {
        ITracer result = TracerFactory.getInstance().createTemplateLanguageTracerImpl();
        if (result == null) {
            result = DEFAULT.createTemplateLanguageTracerImpl();
        }
        result.setTraceFilter(filter);
        return result;
    }

    public static net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer createBuildLanguageTracer() {
        net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer result = TracerFactory.getInstance().createBuildLanguageTracerImpl();
        if (result == null) {
            result = DEFAULT.createBuildLanguageTracerImpl();
        }
        result.setTraceFilter(filter);
        return result;
    }

    public static IInstantiatorTracer createInstantiatorTracer() {
        IInstantiatorTracer result = TracerFactory.getInstance().createInstantiatorTracerImpl();
        if (result == null) {
            result = DEFAULT.createInstantiatorTracerImpl();
        }
        return result;
    }

    public static void registerBuildLanguageTracer(net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer tracer) {
        if (tracer != null) {
            BUILDLANG_TRACERS.put(Thread.currentThread(), tracer);
        }
    }

    public static void unregisterBuildLanguageTracer(net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer tracer) {
        if (tracer != null) {
            BUILDLANG_TRACERS.remove(Thread.currentThread());
        }
    }

    public static net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer getRegisteredBuildLanguageTracer() {
        return BUILDLANG_TRACERS.get(Thread.currentThread());
    }

    public static void registerTemplateLanguageTracer(ITracer tracer) {
        if (tracer != null) {
            TEMPLATELANG_TRACERS.put(Thread.currentThread(), tracer);
        }
    }

    public static void unregisterTemplateLanguageTracer(ITracer tracer) {
        if (tracer != null) {
            TEMPLATELANG_TRACERS.remove(Thread.currentThread());
        }
    }

    public static ITracer getRegisteredTemplateLanguageTracer() {
        return TEMPLATELANG_TRACERS.get(Thread.currentThread());
    }

    public static void progress(int actual, int max, String description) {
        for (Map.Entry<ProgressObserver, TaskData> entry : PROGRESS_OBSERVERS.entrySet()) {
            ProgressObserver obs = entry.getKey();
            TaskData task = entry.getValue();
            boolean newTask = false;
            if (task == null) {
                newTask = true;
            } else if (actual == max) {
                obs.notifyEnd(task.task);
                newTask = true;
            }
            if (newTask) {
                task = new TaskData();
                task.taskDescription = description == null ? "..." : description;
                task.task = obs.registerTask(task.taskDescription);
                entry.setValue(task);
                obs.notifyStart(task.task, max);
                continue;
            }
            obs.notifyProgress(task.task, actual, max);
            if (description == null || description.equals(task.taskDescription)) continue;
            if (task.subtasks.get(description) == null) {
                for (Map.Entry<String, ProgressObserver.ISubtask> e : task.subtasks.entrySet()) {
                    obs.notifyEnd(task.task, e.getValue());
                }
                task.subtasks.clear();
            }
            TracerFactory.progressSubTask(actual, max, description);
        }
    }

    public static void progressSubTask(int actual, int max, String taskName) {
        for (Map.Entry<ProgressObserver, TaskData> entry : PROGRESS_OBSERVERS.entrySet()) {
            ProgressObserver obs = entry.getKey();
            TaskData task = entry.getValue();
            if (task == null) continue;
            ProgressObserver.ISubtask sub = task.subtasks.get(taskName);
            if (sub == null) {
                sub = obs.registerSubtask(taskName);
                task.subtasks.put(taskName, sub);
            }
            obs.notifyProgress(task.task, sub, actual, max);
            if (actual != max) continue;
            obs.notifyEnd(task.task, sub);
            task.subtasks.remove(taskName);
        }
    }

    public static void ensureTasks(String description) {
        for (Map.Entry<ProgressObserver, TaskData> entry : PROGRESS_OBSERVERS.entrySet()) {
            ProgressObserver obs = entry.getKey();
            TaskData task = entry.getValue();
            if (task != null) continue;
            task = new TaskData();
            task.taskDescription = description == null ? "..." : description;
            task.task = obs.registerTask(task.taskDescription);
            entry.setValue(task);
        }
    }

    public static void closeTasks(String description) {
        for (Map.Entry<ProgressObserver, TaskData> entry : PROGRESS_OBSERVERS.entrySet()) {
            ProgressObserver obs = entry.getKey();
            TaskData task = entry.getValue();
            if (description == null || task.taskDescription.equals(description)) continue;
            obs.notifyEnd(task.task);
            entry.setValue(null);
        }
    }

    public static void registerProgressObserver(ProgressObserver observer) {
        if (observer != null && !PROGRESS_OBSERVERS.containsKey(observer)) {
            PROGRESS_OBSERVERS.put(observer, null);
        }
    }

    public static void unregisterProgressObserver(ProgressObserver observer) {
        TaskData task;
        if (observer != null && (task = PROGRESS_OBSERVERS.remove(observer)) != null && task.task != null) {
            observer.notifyEnd(task.task);
        }
    }

    public static class DefaultTracerFactory
    extends TracerFactory {
        @Override
        public ITracer createTemplateLanguageTracerImpl() {
            return net.ssehub.easy.instantiation.core.model.templateModel.NoTracer.INSTANCE;
        }

        @Override
        public net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer createBuildLanguageTracerImpl() {
            return NoTracer.INSTANCE;
        }

        @Override
        public IInstantiatorTracer createInstantiatorTracerImpl() {
            return EMPTY_INSTANTIATOR_TRACER;
        }
    }

    private static class TaskData {
        private ProgressObserver.ITask task;
        private String taskDescription;
        private Map<String, ProgressObserver.ISubtask> subtasks = new HashMap<String, ProgressObserver.ISubtask>();

        private TaskData() {
        }
    }
}

