/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.ResolutionListener;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualTypeProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypedModel;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public abstract class AbstractCallExpression
extends Expression
implements IArgumentProvider {
    private static final ResolutionListener RESLIST = new ResolutionListener(){

        @Override
        public void resolved(VarModelIdentifierExpression ex) {
            ex.markAsResolved();
        }
    };
    private String name;
    private String prefix;

    protected AbstractCallExpression() {
    }

    protected AbstractCallExpression(String name, boolean unqualify) throws VilException {
        int pos;
        this.name = name;
        if (unqualify && name != null && (pos = name.lastIndexOf("::")) > 0) {
            this.prefix = name.substring(0, pos);
            this.name = name.substring(pos + 2, name.length());
            if (this.name.length() == 0) {
                throw new VilException("illegal qualified name " + name, 70000);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        Object result = this.prefix == null ? this.name : this.prefix + "::" + this.name;
        return result;
    }

    protected static IMetaType getParameterType(IMetaOperation operation, int index, CallArgument[] arguments, int unnamedArgsCount) {
        IMetaParameterDeclaration pDecl;
        IMetaType result = index < unnamedArgsCount ? operation.getParameterType(index) : (index < arguments.length ? ((pDecl = operation.getParameter(arguments[index].getName())) != null ? pDecl.getType() : null) : operation.getParameterType(index));
        return result;
    }

    private static void candidatesOnImports(ITypedModel model, String name, int unnamedArgsCount, List<IMetaOperation> candidates, boolean inInsert, boolean all) {
        int i = 0;
        while (i < model.getImportsCount()) {
            ModelImport imp = model.getImport(i);
            if (imp.getResolved() instanceof ITypedModel) {
                ITypedModel res = (ITypedModel)imp.getResolved();
                if (imp.isWildcard() && imp.isInsert()) {
                    AbstractCallExpression.candidatesOnImports(res, name, unnamedArgsCount, candidates, true, all);
                } else if (inInsert) {
                    candidates.addAll(res.getCandidates(name, unnamedArgsCount));
                }
            }
            ++i;
        }
    }

    public static List<IMetaOperation> assignableCandidates(IMetaType operand, String name, CallArgument[] arguments, int unnamedArgsCount, boolean allowAny, boolean all) throws VilException {
        ArrayList<IMetaOperation> result = new ArrayList<IMetaOperation>();
        IMetaType[] argumentTypes = AbstractCallExpression.toTypeDescriptors(arguments);
        List<IMetaOperation> candidates = operand.getCandidates(name, unnamedArgsCount);
        if (operand instanceof ITypedModel) {
            AbstractCallExpression.candidatesOnImports((ITypedModel)operand, name, unnamedArgsCount, candidates, false, all);
        }
        if (all) {
            result.addAll(candidates);
        } else {
            int o = 0;
            while (o < candidates.size()) {
                IMetaOperation desc = candidates.get(o);
                boolean allEqual = true;
                int p = 0;
                while (allEqual && p < arguments.length) {
                    IMetaOperation funcOp;
                    IMetaType aType;
                    IMetaType pType = AbstractCallExpression.getParameterType(desc, p, arguments, unnamedArgsCount);
                    if (pType != null && !(allEqual &= TypeRegistry.equals(pType, aType = argumentTypes[p])) && (funcOp = AbstractCallExpression.resolveResolvableOperation(null, pType, aType, arguments[p].getExpression(), RESLIST)) != null) {
                        arguments[p].resolveOperation((TypeDescriptor)pType, funcOp);
                        allEqual = true;
                    }
                    ++p;
                }
                if (allEqual) {
                    result.add(desc);
                }
                ++o;
            }
            if (result.isEmpty()) {
                int minAssignables = 0;
                int o2 = 0;
                while (o2 < candidates.size()) {
                    IMetaOperation desc = candidates.get(o2);
                    boolean allAssignable = true;
                    int aCount = 0;
                    TypeDescriptor<?> any = TypeRegistry.anyType();
                    int p = 0;
                    while (allAssignable && p < arguments.length) {
                        IMetaType pType = AbstractCallExpression.getParameterType(desc, p, arguments, unnamedArgsCount);
                        IMetaType aType = argumentTypes[p];
                        if (pType != null) {
                            if (pType.isAssignableFrom(aType) || allowAny && any == pType) {
                                aCount += pType != aType ? 1 : 0;
                            } else {
                                allAssignable = false;
                            }
                        }
                        ++p;
                    }
                    if (allAssignable) {
                        if (minAssignables == 0 || aCount < minAssignables) {
                            result.clear();
                            minAssignables = aCount;
                        }
                        if (aCount == minAssignables) {
                            AbstractCallExpression.addAndPruneByType(result, desc, argumentTypes, arguments, unnamedArgsCount);
                        }
                    }
                    ++o2;
                }
            }
            if (result.size() > 1) {
                throw new VilException(AbstractCallExpression.toSignatures(result) + " are ambiguous", 70003);
            }
        }
        return result;
    }

    private static String toSignatures(Iterable<IMetaOperation> operations) {
        StringBuilder tmp = new StringBuilder();
        for (IMetaOperation op : operations) {
            if (tmp.length() > 0) {
                tmp.append(",");
            }
            tmp.append(op.getSignature());
        }
        return tmp.toString();
    }

    public static IMetaOperation resolveResolvableOperation(IMetaType operand, IMetaType pType, IMetaType aType, Expression initExpression, ResolutionListener listener) throws VilException {
        IMetaOperation result = null;
        if (initExpression instanceof VarModelIdentifierExpression) {
            CallArgument[] args;
            String opName;
            List<IMetaOperation> ops;
            VarModelIdentifierExpression varModelIdEx = (VarModelIdentifierExpression)initExpression;
            if (operand == null) {
                operand = varModelIdEx.getModel();
            }
            if (TypeRegistry.resolvableOperationType().isAssignableFrom(pType) && IvmlTypes.ivmlElement().isAssignableFrom(aType) && operand instanceof IModel && 1 == (ops = AbstractCallExpression.assignableCandidates(operand, opName = varModelIdEx.getIdentifier(), args = AbstractCallExpression.toTypeDescriptors(pType, 1), args.length, false, false)).size()) {
                IMetaOperation functionOp = ops.get(0);
                TypeDescriptor<?> ret = pType.getGenericParameterType(pType.getGenericParameterCount() - 1);
                if (ReflectionTypeDescriptor.VOID == ret || ret.isAssignableFrom(functionOp.getReturnType())) {
                    result = functionOp;
                    listener.resolved(varModelIdEx);
                }
            }
        }
        return result;
    }

    private static CallArgument[] toTypeDescriptors(IMetaType type, int exclude) {
        CallArgument[] result = new CallArgument[Math.max(0, type.getGenericParameterCount() - exclude)];
        int a = 0;
        while (a < result.length) {
            result[a] = new CallArgument(type.getGenericParameterType(a));
            ++a;
        }
        return result;
    }

    private static IMetaType[] toTypeDescriptors(CallArgument[] args) throws VilException {
        IMetaType[] result = new IMetaType[args.length];
        int a = 0;
        while (a < args.length) {
            result[a] = args[a].inferType();
            ++a;
        }
        return result;
    }

    private static void addAndPruneByType(List<IMetaOperation> candidates, IMetaOperation toAdd, IMetaType[] argTypes, CallArgument[] arguments, int unnamedArgsCount) {
        if (!candidates.isEmpty()) {
            int toAddDiff = AbstractCallExpression.calcTypeDiff(toAdd, argTypes, arguments, unnamedArgsCount);
            int i = candidates.size() - 1;
            while (i >= 0) {
                IMetaOperation op = candidates.get(i);
                int opDiff = AbstractCallExpression.calcTypeDiff(op, argTypes, arguments, unnamedArgsCount);
                if (toAddDiff < opDiff) {
                    candidates.remove(i);
                }
                --i;
            }
        }
        if (candidates.isEmpty()) {
            candidates.add(toAdd);
        }
    }

    private static int calcTypeDiff(IMetaOperation operation, IMetaType[] argTypes, CallArgument[] arguments, int unnamedArgsCount) {
        int diff = 0;
        int p = 0;
        while (p < argTypes.length) {
            IMetaType aType;
            IMetaType pType = AbstractCallExpression.getParameterType(operation, p, arguments, unnamedArgsCount);
            if (!TypeRegistry.equals(pType, aType = argTypes[p])) {
                diff += AbstractCallExpression.calcSuperDiffRec(aType, pType);
            }
            ++p;
        }
        return diff;
    }

    private static int calcSuperDiffRec(IMetaType iter, IMetaType reference) {
        int diff = AbstractCallExpression.calcSuperDiff(iter, reference);
        if (iter.getGenericParameterCount() == reference.getGenericParameterCount()) {
            int p = 0;
            while (p < iter.getGenericParameterCount()) {
                diff += AbstractCallExpression.calcSuperDiffRec(iter.getGenericParameterType(p), reference.getGenericParameterType(p));
                ++p;
            }
        }
        return diff;
    }

    private static int calcSuperDiff(IMetaType iter, IMetaType reference) {
        int diff = 0;
        while (iter != null && !TypeRegistry.equals(iter, reference)) {
            ++diff;
            iter = iter.getSuperType();
        }
        if (iter == null) {
            diff = 100;
        }
        return diff;
    }

    private static List<ConvertibleOperation> convertibleCandidates(IMetaType operand, String name, CallArgument[] arguments, int unnamedArgsCount) throws VilException {
        List<ConvertibleOperation> result = new ArrayList<ConvertibleOperation>();
        List<IMetaOperation> candidates = operand.getCandidates(name, unnamedArgsCount);
        int o = 0;
        while (o < candidates.size()) {
            IMetaOperation desc = candidates.get(o);
            int conversionCount = 0;
            Object[] conversionOps = new IMetaOperation[arguments.length];
            boolean allParamOk = true;
            int p = 0;
            while (allParamOk && p < desc.getParameterCount()) {
                TypeDescriptor<?> argType;
                IMetaType pType = AbstractCallExpression.getParameterType(desc, p, arguments, unnamedArgsCount);
                TypeDescriptor<?> typeDescriptor = argType = p < arguments.length ? arguments[p].inferType() : null;
                if (argType != null && pType != null && !pType.isAssignableFrom(argType)) {
                    conversionOps[p] = TypeHelper.findConversion(argType, pType);
                    if (conversionOps[p] != null) {
                        if (argType.checkConversion(pType, (IMetaOperation)conversionOps[p])) {
                            ++conversionCount;
                        } else {
                            conversionOps[p] = null;
                        }
                    }
                    allParamOk = conversionOps[p] != null;
                }
                ++p;
            }
            if (allParamOk && conversionCount > 0) {
                assert (conversionOps != null && conversionOps.length == arguments.length);
                result.add(new ConvertibleOperation(desc, (IMetaOperation[])conversionOps));
                conversionOps = new IMetaOperation[arguments.length];
            } else {
                Arrays.fill(conversionOps, null);
            }
            ++o;
        }
        if (result.size() > 1 && (result = AbstractCallExpression.selectAmongMultipleCandidates(result, arguments, unnamedArgsCount)).size() > 1) {
            StringBuilder tmp = new StringBuilder();
            for (ConvertibleOperation op : result) {
                if (tmp.length() > 0) {
                    tmp.append(",");
                }
                tmp.append(op.operation.getSignature());
            }
            throw new VilException(String.valueOf(tmp) + " are ambiguous", 70003);
        }
        return result;
    }

    private static List<ConvertibleOperation> selectAmongMultipleCandidates(List<ConvertibleOperation> candidates, CallArgument[] arguments, int unnamedArgsCount) throws VilException {
        ConvertibleOperation op = null;
        int opCount = 0;
        int minScore = Integer.MAX_VALUE;
        int c = 0;
        while (c < candidates.size()) {
            ConvertibleOperation tmp = candidates.get(c);
            int score = tmp.getScore(arguments, unnamedArgsCount);
            if (op == null || score < minScore) {
                op = tmp;
                minScore = score;
                opCount = 1;
            } else if (minScore == score) {
                ++opCount;
            }
            ++c;
        }
        if (opCount == 1) {
            candidates.clear();
            candidates.add(op);
        }
        return candidates;
    }

    public static IMetaOperation resolveOperation(IMetaType operand, String name, CallArgument ... arguments) throws VilException {
        IMetaOperation op = null;
        try {
            op = AbstractCallExpression.resolveOperation(operand, name, arguments, true, false);
        }
        catch (VilException e) {
            try {
                if (arguments != null && arguments.length > 0 && !(operand instanceof IModel)) {
                    TypeDescriptor<?> opType = arguments[0].inferType();
                    if (2 == arguments.length) {
                        op = AbstractCallExpression.tryOpConversionToSecond(opType, name, arguments);
                    }
                    if (op == null && (op = AbstractCallExpression.resolveFallbacks(opType, name, arguments)) == null) {
                        throw e;
                    }
                }
                throw e;
            }
            catch (VilException e1) {
                throw e;
            }
        }
        return op;
    }

    private static IMetaOperation resolveFallbacks(IMetaType opType, String name, CallArgument[] arguments) {
        IMetaOperation op = null;
        ArrayList fallback = new ArrayList();
        fallback.add(TypeRegistry.stringType());
        if (IvmlTypes.decisionVariableType().isAssignableFrom(opType)) {
            fallback.add(TypeRegistry.booleanType());
            fallback.add(TypeRegistry.realType());
            fallback.add(TypeRegistry.integerType());
        }
        IMetaOperation convOp = null;
        int f = 0;
        while (op == null && f < fallback.size()) {
            IMetaType fType = (IMetaType)fallback.get(f);
            convOp = TypeHelper.findConversion(opType, fType);
            if (convOp != null) {
                try {
                    op = AbstractCallExpression.resolveOperation(fType, name, arguments, true, false);
                    if (opType == TypeRegistry.anyType()) {
                        arguments[0].insertConversion(convOp);
                    }
                }
                catch (VilException vilException) {
                    // empty catch block
                }
            }
            ++f;
        }
        return op;
    }

    public static IMetaOperation resolveOperation(IMetaType operand, boolean checkMetaForFirstArgField, String name, CallArgument[] arguments) throws VilException {
        FieldAccessExpression fae;
        TypeDescriptor<?> fOperand;
        IMetaOperation op = null;
        if (arguments.length > 0 && checkMetaForFirstArgField && arguments[0].getExpression() instanceof FieldAccessExpression && (fOperand = (fae = (FieldAccessExpression)arguments[0].getExpression()).getField().getMetaType()) != null) {
            CallArgument[] args = new CallArgument[arguments.length];
            args[0] = new CallArgument(fOperand);
            int a = 1;
            while (a < arguments.length) {
                args[a] = arguments[a];
                ++a;
            }
            try {
                try {
                    op = AbstractCallExpression.resolveOperation(fOperand, name, args);
                }
                catch (VilException e) {
                    op = AbstractCallExpression.resolveOperationOnModel(operand, name, args, new HashSet<Object>());
                }
                if (op != null && args[0].getExpression() == null) {
                    fae.enableMetaAccess();
                } else {
                    op = null;
                }
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        if (op == null) {
            op = AbstractCallExpression.resolveOperation(operand, name, arguments);
        }
        return op;
    }

    private static IMetaOperation resolveOperationOnModel(Object operand, String name, CallArgument[] arguments, Set<Object> done) throws VilException {
        ITypedModel model;
        IMetaOperation op = null;
        if (operand instanceof ITypedModel && !done.contains(model = (ITypedModel)operand)) {
            done.add(model);
            try {
                op = AbstractCallExpression.resolveOperation((IMetaType)model, name, arguments);
            }
            catch (VilException vilException) {
                // empty catch block
            }
            int i = 0;
            while (op == null && i < model.getImportsCount()) {
                try {
                    op = AbstractCallExpression.resolveOperationOnModel(model.getImport(i).getResolved(), name, arguments, done);
                }
                catch (VilException vilException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return op;
    }

    private static IMetaOperation tryOpConversionToSecond(IMetaType opType, String name, CallArgument[] arguments) throws VilException {
        IMetaOperation op = null;
        TypeDescriptor<?> sndArgType = arguments[1].inferType();
        IMetaOperation convOp = TypeHelper.findConversion(opType, sndArgType);
        if (convOp != null) {
            try {
                op = AbstractCallExpression.resolveOperation(sndArgType, name, arguments, true, false);
                if (!op.getReturnType().isAssignableFrom(sndArgType)) {
                    arguments[0].insertConversion(convOp);
                }
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return op;
    }

    private static IMetaOperation resolveOperation(IMetaType operand, String name, CallArgument[] arguments, boolean allowConversion, boolean allowAny) throws VilException {
        IMetaOperation resolved = null;
        int unnamedArgsCount = CallArgument.countUnnamedArguments(arguments);
        List<IMetaOperation> candidates = AbstractCallExpression.assignableCandidates(operand, name, arguments, unnamedArgsCount, allowAny, false);
        if (1 == candidates.size()) {
            resolved = candidates.get(0);
        } else if (allowConversion) {
            List<ConvertibleOperation> convertible = AbstractCallExpression.convertibleCandidates(operand, name, arguments, unnamedArgsCount);
            if (convertible.size() == 0 && operand.getBaseType() != null) {
                convertible = AbstractCallExpression.convertibleCandidates(operand.getBaseType(), name, arguments, unnamedArgsCount);
            }
            if (1 == convertible.size()) {
                ConvertibleOperation found = convertible.get(0);
                resolved = found.operation;
                int i = 0;
                while (i < unnamedArgsCount) {
                    IMetaOperation conversionOp = found.conversions[i];
                    if (conversionOp != null) {
                        arguments[i].insertConversion(conversionOp);
                    }
                    ++i;
                }
            }
        }
        if (resolved == null) {
            resolved = operand.addPlaceholderOperation(name, unnamedArgsCount, arguments.length - unnamedArgsCount > 0);
        }
        if (resolved == null) {
            throw new VilException("cannot resolve operation " + AbstractCallExpression.getSignature(name, arguments), 70002);
        }
        int optionalNamed = 0;
        int i = unnamedArgsCount;
        while (i < arguments.length) {
            if (resolved.getParameter(arguments[i].getName()) == null) {
                ++optionalNamed;
            }
            ++i;
        }
        if (optionalNamed > 0 && !resolved.acceptsNamedParameters()) {
            throw new VilException(resolved.getJavaSignature() + " does not accept (optional) named parameters", 70002);
        }
        return resolved;
    }

    public static final String getSignature(String name, CallArgument[] arguments) {
        StringBuilder signature = new StringBuilder(name);
        signature.append("(");
        int a = 0;
        while (a < arguments.length) {
            CallArgument arg = arguments[a];
            if (arg.hasName()) {
                signature.append(arg.getName());
                signature.append(" = ");
            }
            try {
                signature.append(arguments[a].inferType().getName());
            }
            catch (VilException e) {
                signature.append("<unknown>");
            }
            if (a < arguments.length - 1) {
                signature.append(",");
            }
            ++a;
        }
        signature.append(")");
        return signature.toString();
    }

    private static IMetaType determineActualType(IMetaType type, Object object, TypeRegistry registry) {
        TypeDescriptor<?> tmpType;
        IDatatype actualType;
        TypeDescriptor<?> result = type;
        if (object instanceof IActualTypeProvider && (actualType = ((IActualTypeProvider)object).determineActualTypeName()) != null && (tmpType = registry.getType(actualType)) != null && tmpType.isActualTypeOf(type)) {
            result = tmpType;
        }
        return result;
    }

    private static IMetaType getEnumType(TypeRegistry registry, EnumValue val) {
        TypeDescriptor<?> tmp = registry.getType(val.getDatatype());
        if (tmp == null) {
            tmp = registry.getType(EnumValue.class);
        }
        return tmp;
    }

    public static <O extends IMetaOperation> O dynamicDispatch(O operation, Object[] args, Class<O> cls, TypeRegistry registry, IArgumentProvider arguments, IMetaType operandOverride) {
        Object result = operation;
        int offset = 0;
        if (operation.isFirstParameterOperand()) {
            offset = 1;
        }
        if (args.length >= offset) {
            boolean forceResolve;
            TypeDescriptor<?> operand = AbstractCallExpression.getOperand(operation, operandOverride);
            boolean bl = forceResolve = operation.getDeclaringType() != operand;
            if (operand != null && operand.enableDynamicDispatch()) {
                CallArgument[] types = new CallArgument[args.length - offset];
                boolean allSame = true;
                boolean failure = false;
                int a = 0;
                while (!failure && a < operation.getRequiredParameterCount()) {
                    String argName = arguments.getArgument(a).getName();
                    if (args[a] == null) {
                        if (a - offset < 0) {
                            failure = true;
                            continue;
                        }
                        types[a - offset] = new CallArgument(argName, (TypeDescriptor)operation.getParameterType(a));
                        ++a;
                        continue;
                    }
                    IMetaType tmp = args[a] instanceof EnumValue ? AbstractCallExpression.getEnumType(registry, (EnumValue)args[a]) : registry.obtainTypeDescriptor(args[a]);
                    if ((tmp = AbstractCallExpression.determineActualType(tmp, args[a], registry)) == null) {
                        tmp = operation.getParameterType(a);
                    } else {
                        allSame &= tmp == operation.getParameterType(a);
                    }
                    if (a == 0 && offset > 0) {
                        operand = tmp;
                    } else if (tmp instanceof TypeDescriptor) {
                        types[a - offset] = new CallArgument(argName, (TypeDescriptor<?>)tmp);
                    } else {
                        failure = true;
                    }
                    ++a;
                }
                while (!failure && a < types.length) {
                    types[a] = new CallArgument("name", null);
                    ++a;
                }
                if (!(allSame && !forceResolve || failure)) {
                    try {
                        IMetaOperation op = AbstractCallExpression.resolveOperation((IMetaType)operand, operation.getName(), types, false, true);
                        if (cls.isInstance(op)) {
                            result = (IMetaOperation)cls.cast(op);
                        }
                    }
                    catch (VilException vilException) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    private static <O extends IMetaOperation> IMetaType getOperand(O operation, IMetaType operandOverride) {
        IMetaType operand = operation.getDeclaringType();
        if (operandOverride != null && operand.isAssignableFrom(operandOverride)) {
            operand = operandOverride;
        }
        return operand;
    }

    protected static boolean isPlaceholder(IMetaOperation operation) {
        boolean isPlaceholder;
        if (operation == null) {
            isPlaceholder = true;
        } else {
            isPlaceholder = operation.isPlaceholder();
            if (!isPlaceholder) {
                isPlaceholder = operation.getReturnType().isPlaceholder();
                int p = 0;
                while (!isPlaceholder && p < operation.getParameterCount()) {
                    isPlaceholder = operation.getParameterType(p).isPlaceholder();
                    ++p;
                }
            }
        }
        return isPlaceholder;
    }

    protected String getVilSignature(IMetaOperation operation) {
        Object result = operation == null ? this.name + "(?)" : operation.getSignature();
        return result;
    }

    public abstract boolean isPlaceholder();

    public abstract String getVilSignature();

    public boolean isOclCompliant() {
        return true;
    }

    public boolean isIteratingCollectionOperation() {
        return false;
    }

    @Override
    public abstract int getArgumentsCount();

    @Override
    public abstract CallArgument getArgument(int var1);

    private static class ConvertibleOperation {
        private IMetaOperation operation;
        private IMetaOperation[] conversions;

        ConvertibleOperation(IMetaOperation operation, IMetaOperation[] conversions) {
            this.operation = operation;
            this.conversions = conversions;
        }

        public int getScore(CallArgument[] arguments, int unnamedArgsCount) throws VilException {
            int score = 0;
            int step = this.operation.getParameterCount();
            int c = 0;
            while (c < this.conversions.length) {
                IMetaType pType = AbstractCallExpression.getParameterType(this.operation, c, arguments, unnamedArgsCount);
                if (this.conversions[c] == null) {
                    TypeDescriptor<?> aType = arguments[c].inferType();
                    if (pType != aType) {
                        ++score;
                    }
                } else {
                    IMetaType cType = this.conversions[c].getReturnType();
                    score = pType == cType ? (score += step) : (score += step * step);
                }
                ++c;
            }
            return score;
        }
    }
}

