/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class AbstractWriter {
    private StringBuilder actualIndentation = new StringBuilder();
    private char whitespace = (char)32;
    private String indentation = "    ";
    private PrintWriter out;

    public AbstractWriter(Writer out) {
        this.out = new PrintWriter(out);
    }

    protected Writer getOut() {
        return this.out;
    }

    protected void print(String string) {
        this.out.print(string);
    }

    protected void printJavaEscaped(String string) {
        this.print(StringEscapeUtils.escapeJava((String)string));
    }

    protected void println(String string) {
        this.out.println(string);
    }

    protected void print(char ch) {
        this.out.print(ch);
    }

    protected void println(char ch) {
        this.out.print(ch);
    }

    protected void print(int value) {
        this.out.print(value);
    }

    protected void println(int value) {
        this.out.println(value);
    }

    protected void print(Object object) {
        this.out.print(object);
    }

    protected void println(Object object) {
        this.out.println(object);
    }

    protected void println() {
        this.out.println();
    }

    protected final void printIndentation() {
        this.out.print(this.actualIndentation);
    }

    protected final void printWhitespace() {
        this.out.print(this.whitespace);
    }

    public final void flush() throws IOException {
        this.out.flush();
    }

    public void setIndentation(String indentation) {
        assert (indentation != null);
        this.indentation = indentation;
    }

    protected void increaseIndentation() {
        this.actualIndentation.append(this.indentation);
    }

    protected void decreaseIndentation() {
        this.actualIndentation.delete(0, this.indentation.length());
    }
}

