/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class CallArgument {
    private String name;
    private Expression expr;
    private TypeDescriptor<?> type;
    private Object fixedValue;
    private boolean fixed;

    CallArgument() {
    }

    public CallArgument(TypeDescriptor<?> type) {
        this.type = type;
        this.name = null;
        this.expr = null;
    }

    public CallArgument(Expression expr) {
        this(null, expr);
    }

    public CallArgument(String name, Expression expr) {
        assert (name == null || name.length() > 0);
        this.name = name;
        this.expr = expr;
    }

    public CallArgument(String name, TypeDescriptor<?> type) {
        this.name = name;
        this.type = type;
    }

    public static CallArgument[] createUnnamedArguments(Expression ... arguments) {
        CallArgument[] result = new CallArgument[arguments.length];
        int a = 0;
        while (a < arguments.length) {
            result[a] = new CallArgument(arguments[a]);
            ++a;
        }
        return result;
    }

    public static int countUnnamedArguments(CallArgument[] arguments) {
        int count = 0;
        int a = 0;
        while (a < arguments.length) {
            if (!arguments[a].hasName()) {
                ++count;
            }
            ++a;
        }
        return count;
    }

    public static CallArgument[] getUnnamedArguments(CallArgument[] arguments) {
        CallArgument[] result;
        int count = CallArgument.countUnnamedArguments(arguments);
        if (count == arguments.length) {
            result = arguments;
        } else {
            result = new CallArgument[count];
            int pos = 0;
            int a = 0;
            while (a < arguments.length) {
                if (!arguments[a].hasName()) {
                    result[pos++] = arguments[a];
                }
                ++a;
            }
        }
        return result;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public TypeDescriptor<?> inferType() throws VilException {
        TypeDescriptor<?> result = this.expr == null ? (this.type == null ? TypeRegistry.voidType() : this.type) : this.expr.inferType();
        return result;
    }

    void insertConversion(OperationDescriptor operation) throws VilException {
        this.expr = new CallExpression(operation, new CallArgument(this.expr));
    }

    void insertConversion(IMetaOperation operation) throws VilException {
        if (!(operation instanceof OperationDescriptor)) {
            throw new VilException(operation.getJavaSignature() + " is not a valid conversion", 70002);
        }
        this.insertConversion((OperationDescriptor)operation);
    }

    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result;
        if (this.fixed) {
            result = this.fixedValue;
        } else {
            if (this.expr == null) {
                throw new VilException("expr is null", 70000);
            }
            result = this.expr.accept(visitor);
        }
        return result;
    }

    public Object fixValue(IExpressionVisitor visitor) throws VilException {
        this.fixedValue = this.accept(visitor);
        this.fixed = true;
        return this.fixedValue;
    }

    public CallArgument fixValue(Object fixedValue) {
        this.fixedValue = fixedValue;
        this.fixed = true;
        return this;
    }

    public void resolveOperation(TypeDescriptor<?> type, IMetaOperation operation) {
        this.expr = new ResolvableOperationExpression(type, operation);
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    public String toString() {
        try {
            this.inferType();
        }
        catch (VilException e) {
            e.printStackTrace();
        }
        return this.type != null ? this.type.getName() : "<unknown type>";
    }
}

