/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.VilTypeExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class CallExpression
extends AbstractCallExpression
implements IArgumentProvider {
    private Object parent;
    private CallArgument[] arguments;
    private OperationDescriptor resolved;
    private TypeDescriptor<?> type;
    private CallType callType = CallType.NORMAL;
    private boolean dotRight;

    protected CallExpression() throws VilException {
        super(null, true);
    }

    public CallExpression(Object parent, String name, Expression ... arguments) throws VilException {
        this(parent, name, false, CallArgument.createUnnamedArguments(arguments));
    }

    public CallExpression(Object parent, String name, CallArgument ... arguments) throws VilException {
        this(parent, name, false, arguments);
    }

    public CallExpression(Object parent, String name, boolean dotRight, CallArgument ... arguments) throws VilException {
        super(name, true);
        if (this.doZeroArgumentTest() && arguments.length == 0) {
            throw new VilException("at least one argument must be provided to '" + name + "'(owner)", 70000);
        }
        this.parent = parent;
        this.dotRight = dotRight;
        this.arguments = arguments;
    }

    public CallExpression(OperationDescriptor operation, CallArgument arg) throws VilException {
        super(operation.getName(), false);
        if (1 != operation.getParameterCount()) {
            throw new VilException("operation " + operation.getJavaSignature() + " does not accept exactly one parameter", 70000);
        }
        if (TypeRegistry.voidType() == operation.getReturnType()) {
            throw new VilException("operation " + operation.getJavaSignature() + " does not return a return value", 70000);
        }
        this.resolved = operation;
        this.callType = CallType.TRANSPARENT;
        this.arguments = new CallArgument[1];
        this.arguments[0] = arg;
    }

    public CallExpression(IMetaOperation operation, CallArgument ... param) throws VilException {
        super(operation.getName(), false);
        if (!(operation instanceof OperationDescriptor)) {
            throw new VilException("operation is of wrong type", 70000);
        }
        this.resolved = (OperationDescriptor)operation;
        this.callType = CallType.EXTERNAL;
        this.arguments = param;
    }

    public Object getParent() {
        return this.parent;
    }

    protected boolean doZeroArgumentTest() {
        return true;
    }

    public boolean isDotRightExpression() {
        return this.dotRight;
    }

    public OperationDescriptor getResolved() {
        return this.resolved;
    }

    public CallType getCallType() {
        return this.callType;
    }

    protected TypeDescriptor<?> determineOperand() throws VilException {
        TypeDescriptor<?> operand = null;
        int p = 0;
        while (p < this.arguments.length) {
            TypeDescriptor<?> tmp = this.arguments[p].inferType();
            if (p == 0) {
                operand = tmp;
            }
            ++p;
        }
        if (this.arguments.length == 0) {
            throw new VilException("cannot resolve call without a parameter: " + CallExpression.getSignature(this.getName(), this.arguments), 70000);
        }
        return operand;
    }

    protected boolean checkMetaForFirstArgField() {
        return true;
    }

    private TypeDescriptor<?>[] checkUseParameter() throws VilException {
        TypeDescriptor<?>[] result = null;
        int useParam = this.resolved.useParameterAsReturn();
        if (useParam == Integer.MAX_VALUE) {
            TypeDescriptor<?> op = this.determineOperand();
            if (op.getGenericParameterCount() < 1) {
                result = TypeDescriptor.createArray(1);
            } else {
                result = TypeDescriptor.createArray(op.getGenericParameterCount());
                int i = 0;
                while (i < result.length) {
                    result[i] = op.getGenericParameterType(i);
                    ++i;
                }
            }
        } else {
            result = TypeDescriptor.createArray(1);
            if (useParam >= 0 && ++useParam >= 0 && useParam < this.arguments.length) {
                Expression param = this.arguments[useParam].getExpression();
                if (param instanceof ExpressionEvaluator) {
                    param = ((ExpressionEvaluator)param).getExpression();
                }
                result[0] = param.inferType();
            }
        }
        return result;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        if (this.type == null) {
            TypeDescriptor<?> arg0Type;
            int genParamCount;
            if (this.resolved == null) {
                IMetaOperation op = CallExpression.resolveOperation(this.determineOperand(), true, this.getName(), this.arguments);
                if (op instanceof OperationDescriptor) {
                    this.resolved = (OperationDescriptor)op;
                } else {
                    throw new VilException(op.getJavaSignature() + " is not a valid operation", 70002);
                }
            }
            TypeDescriptor<?> result = this.considerIteratorResult((TypeDescriptor<?>)this.resolved.getReturnType());
            TypeDescriptor<?>[] returnGenerics = null;
            int useParam = this.resolved.useGenericParameterAsReturn();
            if (this.resolved.isTypeSelect() && this.arguments[1].getExpression() instanceof VilTypeExpression) {
                returnGenerics = TypeDescriptor.createArray(1);
                returnGenerics[0] = ((VilTypeExpression)this.arguments[1].getExpression()).getResolved();
            } else if (this.resolved.isGenericCollectionOperation() && (genParamCount = (arg0Type = this.arguments[0].getExpression().inferType()).getGenericParameterCount()) > 0 && (returnGenerics = this.checkUseParameter())[0] == null) {
                useParam = useParam >= 0 && useParam < genParamCount ? useParam : 0;
                returnGenerics[0] = arg0Type.getGenericParameterType(useParam);
                useParam = -1;
            }
            if (((TypeDescriptor)this.resolved.getReturnType()).isMap() && 2 == this.resolved.getParameterCount() && ((TypeDescriptor)this.resolved.getParameterType(0)).isCollection() && ((TypeDescriptor)this.resolved.getParameterType(1)).isCollection()) {
                arg0Type = this.arguments[0].getExpression().inferType();
                TypeDescriptor<?> arg1Type = this.arguments[1].getExpression().inferType();
                if (arg0Type.getGenericParameterCount() > 0 && arg1Type.getGenericParameterCount() > 0) {
                    returnGenerics = TypeDescriptor.createArray(2);
                    returnGenerics[0] = arg0Type.getGenericParameterType(0);
                    returnGenerics[1] = arg1Type.getGenericParameterType(0);
                }
            }
            if (result.isMap() && result.getGenericParameterCount() == 0 && (arg0Type = this.arguments[0].getExpression().inferType()).isMap() && 2 == arg0Type.getGenericParameterCount()) {
                result = arg0Type;
            }
            if (useParam >= 0 && this.resolved.getDeclaringType() != null && this.arguments.length > 0 && useParam < this.arguments[0].inferType().getGenericParameterCount()) {
                result = this.arguments[0].inferType().getGenericParameterType(useParam);
            }
            if (!this.resolved.isStatic() && TypeRegistry.anyType() == result && !this.resolved.useAny() && 1 == (arg0Type = this.arguments[0].getExpression().inferType()).getGenericParameterCount()) {
                result = arg0Type.getGenericParameterType(0);
            }
            this.type = this.considerReturnGenerics(result, returnGenerics);
            if (this.type != null && this.resolved.flatten()) {
                this.type = this.type.flatten();
            }
        }
        return this.type;
    }

    private TypeDescriptor<?> considerReturnGenerics(TypeDescriptor<?> type, TypeDescriptor<?>[] returnGenerics) {
        TypeDescriptor<Object> result = type;
        if (returnGenerics == null && this.resolved.useOperandTypeAsParameter() && this.arguments.length > 0 && this.arguments[0].getExpression() instanceof VilTypeExpression) {
            VilTypeExpression vte = (VilTypeExpression)this.arguments[0].getExpression();
            returnGenerics = TypeDescriptor.createArray(1);
            returnGenerics[0] = vte.getResolved();
        }
        if (returnGenerics != null) {
            try {
                result = result.isSet() ? TypeRegistry.getSetType(returnGenerics) : (result.isSequence() ? TypeRegistry.getSequenceType(returnGenerics) : (result.isCollection() ? TypeRegistry.getCollectionType(returnGenerics) : TypeRegistry.getMapType(returnGenerics)));
            }
            catch (VilException e) {
                EASyLoggerFactory.INSTANCE.getLogger(CallExpression.class, "net.ssehub.easy.instantiation.core").exception((Exception)((Object)e));
            }
        }
        return result;
    }

    @Override
    public int getArgumentsCount() {
        return this.arguments == null ? 0 : this.arguments.length;
    }

    @Override
    public CallArgument getArgument(int index) {
        if (this.arguments == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.arguments[index];
    }

    @Override
    public boolean isPlaceholder() {
        return CallExpression.isPlaceholder(this.resolved);
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitCallExpression(this);
    }

    @Override
    public String getVilSignature() {
        return this.getVilSignature(this.resolved);
    }

    public boolean isIteratorCall() {
        return this.resolved != null && this.getArgumentsCount() >= 2 && this.getArgument(1).getExpression() instanceof ExpressionEvaluator;
    }

    private TypeDescriptor<?> considerIteratorResult(TypeDescriptor<?> result) throws VilException {
        if (this.isIteratorCall()) {
            ExpressionEvaluator eval = (ExpressionEvaluator)this.getArgument(1).getExpression();
            TypeDescriptor<?> evalType = eval.getResultType();
            boolean allowsAggregation = this.resolved.allowsAggregation();
            if (evalType != null) {
                result = evalType;
                if (!allowsAggregation) {
                    throw new VilException("operation " + this.resolved.getSignature() + " does not support aggregating iterators", 30017);
                }
            } else if (allowsAggregation) {
                result = TypeRegistry.voidType();
            }
        }
        return result;
    }

    @Override
    public boolean isOclCompliant() {
        return this.resolved != null ? this.resolved.isOclCompliant() : true;
    }

    @Override
    public boolean isIteratingCollectionOperation() {
        return this.resolved != null ? this.resolved.isIteratingCollectionOperation() : false;
    }

    public static enum CallType {
        NORMAL,
        TRANSPARENT,
        EXTERNAL;

    }
}

