/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ContainerInitializerExpression
extends Expression {
    private Expression[] initExpressions;
    private TypeDescriptor<?> type;

    public ContainerInitializerExpression() {
        this(null);
    }

    public ContainerInitializerExpression(Expression[] initExpressions) {
        this.initExpressions = initExpressions;
    }

    protected ContainerInitializerExpression(Expression[] initExpressions, TypeDescriptor<?> type) {
        this.initExpressions = initExpressions;
        this.type = type;
    }

    public Expression getInitExpression(int index) {
        return this.initExpressions[index];
    }

    public void setInitExpression(int index, Expression expr) {
        this.initExpressions[index] = expr;
    }

    public int getInitExpressionsCount() {
        return this.initExpressions == null ? 0 : this.initExpressions.length;
    }

    private static TypeDescriptor<?> moreCommon(TypeDescriptor<?> t1, TypeDescriptor<?> t2) {
        TypeDescriptor<?> result = t1.isAssignableFrom(t2) ? t1 : (t2.isAssignableFrom(t1) ? t2 : TypeRegistry.anyType());
        return result;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        if (this.type == null) {
            TypeDescriptor<?>[] parameter;
            if (this.getInitExpressionsCount() > 0) {
                ArrayList params = new ArrayList();
                ArrayList local = new ArrayList();
                int e = 0;
                while (e < this.getInitExpressionsCount()) {
                    Expression ex = this.getInitExpression(e);
                    local.clear();
                    if (ex instanceof ContainerInitializerExpression) {
                        ContainerInitializerExpression initEx = (ContainerInitializerExpression)ex;
                        int i = 0;
                        while (i < initEx.getInitExpressionsCount()) {
                            local.add(initEx.getInitExpression(i).inferType());
                            ++i;
                        }
                    } else {
                        local.add(ex.inferType());
                    }
                    if (e == 0) {
                        params.addAll(local);
                    } else {
                        if (params.size() != local.size()) {
                            throw new VilException("parameter size does not match", 70001);
                        }
                        int p = 0;
                        while (p < params.size()) {
                            params.set(p, ContainerInitializerExpression.moreCommon((TypeDescriptor)params.get(p), (TypeDescriptor)local.get(p)));
                            ++p;
                        }
                    }
                    ++e;
                }
                parameter = TypeDescriptor.createArray(params.size());
                params.toArray(parameter);
            } else {
                parameter = null;
            }
            this.type = TypeRegistry.getSequenceType(parameter);
        }
        return this.type;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitContainerInitializerExpression(this);
    }

    public boolean isImplicit() {
        return false;
    }

    protected ContainerInitializerExpression createInitExpression(Expression[] initExpressions, TypeDescriptor<?> type) {
        return new ContainerInitializerExpression(initExpressions, type);
    }

    public ContainerInitializerExpression toSet() throws VilException {
        TypeDescriptor<?>[] parameter = TypeDescriptor.createArray(this.type.getGenericParameterCount());
        int p = 0;
        while (p < parameter.length) {
            parameter[p] = this.type.getGenericParameterType(p);
            ++p;
        }
        return this.createInitExpression(this.initExpressions, TypeRegistry.getSetType(parameter));
    }
}

