/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import net.ssehub.easy.basics.DefaultLocale;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractWriter;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionWriter;
import net.ssehub.easy.instantiation.core.model.expressions.ITracer;
import net.ssehub.easy.instantiation.core.model.vilTypes.Constants;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.varModel.model.values.NullValue;

public abstract class StreamTracer
extends AbstractWriter
implements ITracer {
    protected static final IStringValueProvider.StringComparator NORMALIZER = new IStringValueProvider.StringComparator(){

        @Override
        public int compare(String o1, String o2) {
            int result = o1 == null ? (o2 == null ? 0 : 1) : o1.compareTo(o2);
            return result;
        }

        @Override
        public boolean inTracer() {
            return true;
        }
    };
    private Locale locale = DefaultLocale.getDefaultLocale();
    private String[] baseFolder;
    private RuntimeEnvironment<?, ?> environment;
    private Stack<String> callStack = new Stack();

    public StreamTracer(Writer out, String ... baseFolder) {
        super(out);
        this.baseFolder = baseFolder;
    }

    protected String makeRelative(Object object) {
        return this.makeRelative(StringValueHelper.getStringValue(object, NORMALIZER));
    }

    protected String makeRelative(String string) {
        String result = string;
        if (this.baseFolder != null && result != null) {
            int s = 0;
            while (s < this.baseFolder.length) {
                result = result.replace(this.baseFolder[s] + "/", "").replace(this.baseFolder[s], "");
                ++s;
            }
        }
        return result;
    }

    protected String makeRelative(URI uri) {
        File file = new File(uri);
        return this.makeRelative(file.getAbsolutePath());
    }

    @Override
    public void visitingCallExpression(OperationDescriptor descriptor, CallExpression.CallType callType, Object[] args) {
        if (CallExpression.CallType.TRANSPARENT != callType) {
            Object text = "-> ";
            text = (String)text + descriptor.getName();
            if (descriptor.isConstructor() && descriptor.getReturnType() != null) {
                text = (String)text + " ";
                text = (String)text + ((TypeDescriptor)descriptor.getReturnType()).getVilName();
            }
            text = (String)text + "(";
            if (args != null) {
                int p = 0;
                while (p < descriptor.getParameterCount()) {
                    if (p > 0) {
                        text = (String)text + ", ";
                    }
                    text = (String)text + ((TypeDescriptor)descriptor.getParameterType(p)).getName();
                    ++p;
                }
            }
            text = (String)text + ") with (";
            if (args != null) {
                int a = 0;
                while (a < args.length) {
                    if (a > 0) {
                        text = (String)text + ", ";
                    }
                    Map<?, ?> tmp = args[a];
                    if (descriptor.acceptsImplicitParameters() && a == args.length - 1 && tmp instanceof Map) {
                        tmp = this.skipImplicitArguments(tmp);
                    }
                    text = (String)text + this.makeRelative(tmp);
                    ++a;
                }
            }
            text = (String)text + ")";
            this.callStack.push((String)text);
        }
    }

    @Override
    public void visitedCallExpression(OperationDescriptor descriptor, CallExpression.CallType callType, Object[] args, Object result) {
        if (CallExpression.CallType.TRANSPARENT != callType) {
            this.printIndentation();
            this.print(this.callStack.pop());
            if (NullValue.VALUE != result) {
                this.print(" = ");
                this.print(this.makeRelative(result));
            }
            this.println();
        }
    }

    private Map<?, ?> skipImplicitArguments(Map<?, ?> inMap) {
        HashMap outMap = new HashMap();
        for (Map.Entry<?, ?> ent : inMap.entrySet()) {
            boolean skip = false;
            if (ent.getKey() instanceof String && Constants.IMPLICIT_PARAMETER.contains(ent.getKey())) {
                skip = true;
            }
            if (skip) continue;
            outMap.put(ent.getKey(), ent.getValue());
        }
        return outMap;
    }

    @Override
    public void failedAt(Expression expression) {
        this.print("failed expression: ");
        ExpressionWriter writer = this.getWriter(this.getOut());
        try {
            expression.accept(writer);
        }
        catch (VilException vilException) {
            // empty catch block
        }
    }

    protected abstract ExpressionWriter getWriter(Writer var1);

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    @Override
    public void setRuntimeEnvironment(RuntimeEnvironment<?, ?> environment) {
        this.environment = environment;
    }

    @Override
    public RuntimeEnvironment<?, ?> getRuntimeEnvironment() {
        return this.environment;
    }
}

