/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.List;
import java.util.Stack;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.IMessageHandler;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestrictionValidator;
import net.ssehub.easy.instantiation.core.model.expressions.IStringParserFactory;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceCommand;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceForCommand;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceIfCommand;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceImportCommand;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceVarDeclCommand;
import net.ssehub.easy.instantiation.core.model.expressions.Resolver;
import net.ssehub.easy.instantiation.core.model.expressions.VariableEx;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public abstract class StringParser<P, I extends VariableDeclaration, R extends Resolver<I>> {
    private StringBuilder text;
    private int pos;
    private int curStart;
    private int innerBracketLevel;
    private IStringParserFactory<I> factory;
    private Stack<InPlaceCommand<I>> commandStack;
    private R resolver;

    protected StringParser(String text, R resolver, IStringParserFactory<I> factory) {
        this.text = text != null ? new StringBuilder(text) : null;
        this.resolver = resolver;
        this.factory = factory;
        if (factory != null) {
            this.commandStack = new Stack();
        }
    }

    protected IStringParserFactory<I> getFactory() {
        return this.factory;
    }

    protected R getResolver() {
        return this.resolver;
    }

    public P parse() throws VilException {
        this.pos = 0;
        this.curStart = 0;
        State state = State.TEXT;
        while (this.pos < this.text.length()) {
            char c = this.text.charAt(this.pos);
            switch (state) {
                case TEXT: {
                    if ('$' == c) {
                        if (this.pos > 0 && '\\' == this.text.charAt(this.pos - 1)) {
                            this.handleQuote(this.pos - 1);
                            state = State.TEXT;
                        } else {
                            state = State.VARIABLE_START;
                        }
                    }
                    if (this.pos != this.text.length() - 1 || state != State.TEXT) break;
                    this.handleTextEnd(this.curStart, this.pos);
                    break;
                }
                case VARIABLE_START: {
                    if ('{' == c) {
                        state = State.EXPRESSION;
                        this.setCurStart(this.handleVariableStartExpression(this.curStart, this.pos));
                        break;
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        state = State.VARIABLE;
                        this.setCurStart(this.handleVariableStartVariable(this.curStart, this.pos));
                        break;
                    }
                    state = State.TEXT;
                    break;
                }
                case VARIABLE: {
                    if (Character.isJavaIdentifierPart(c) && c != '$') break;
                    if (this.pos > this.curStart && ':' == c && this.pos + 1 < this.text.length() && ':' == this.text.charAt(this.pos + 1)) {
                        this.pos += 2;
                        break;
                    }
                    this.setCurStart(this.handleVariable(this.curStart, this.pos));
                    state = State.TEXT;
                    --this.pos;
                    break;
                }
                case EXPRESSION: {
                    if ('{' == c) {
                        ++this.innerBracketLevel;
                        break;
                    }
                    if ('}' != c) break;
                    if (this.innerBracketLevel == 0) {
                        this.setCurStart(this.handleExpression(this.curStart, this.pos));
                        state = State.TEXT;
                        if (this.isNonEmptyCommandStack()) {
                            this.notifyBracketsClosed(this.commandStack.peek(), this.pos);
                        }
                        --this.pos;
                        break;
                    }
                    --this.innerBracketLevel;
                    break;
                }
                default: {
                    this.getLogger().error("illegal string parsing state " + String.valueOf((Object)state));
                }
            }
            ++this.pos;
        }
        return this.completeParsing(state);
    }

    protected Expression handleInPlaceCommands(String expressionString, int curStart, int pos) throws VilException {
        Expression result = null;
        if (this.factory != null && Character.isUpperCase(expressionString.charAt(0))) {
            boolean clear = true;
            if (expressionString.startsWith("IF ")) {
                expressionString = this.removePrefix(expressionString, "IF", true);
                this.push(new InPlaceIfCommand(this.parseExpression(expressionString)), curStart, pos);
            } else if (expressionString.startsWith("FOR ")) {
                expressionString = this.handleInPlaceForStart(expressionString, curStart, pos);
            } else if (expressionString.startsWith("VAR ")) {
                expressionString = this.handleInPlaceVarDecl(expressionString, curStart, pos);
                result = this.close(curStart, pos);
            } else if (expressionString.startsWith("IMPORT ")) {
                expressionString = this.handleInPlaceImport(expressionString, curStart, pos);
                result = this.close(curStart, pos);
            } else if (expressionString.equals("ELSE")) {
                this.advanceState(curStart, pos);
            } else if (expressionString.equals("ENDIF")) {
                result = this.close(curStart, pos);
            } else if (expressionString.equals("ENDFOR")) {
                result = this.close(curStart, pos);
                ((Resolver)this.resolver).popLevel();
            } else {
                clear = false;
            }
            if (clear) {
                expressionString = null;
            }
        }
        if (expressionString != null) {
            result = this.parseExpression(expressionString);
            if (this.isNonEmptyCommandStack()) {
                this.commandStack.peek().append(result);
                result = null;
            }
        }
        return result;
    }

    private String handleInPlaceForStart(String expressionString, int curStart, int pos) {
        String result;
        try {
            result = this.removePrefix(expressionString, "FOR", true);
            result = this.consumeWhitespaces(result);
            int pos1 = this.consumeJavaIdentifierPart(result);
            String iterName = result.substring(0, pos1);
            result = this.consumeWhitespaces(result.substring(pos1));
            if (result.startsWith("=")) {
                result = this.consume(result, '=');
            } else if (result.startsWith(":")) {
                result = this.consume(result, ':');
            }
            result = this.consumeWhitespaces(result);
            pos1 = result.indexOf(" SEPARATOR");
            Expression separatorEx = null;
            Expression endSeparatorEx = null;
            if (pos1 > 0) {
                String separatorString = result.substring(pos1 + 1).trim();
                int pos2 = (separatorString = this.removePrefix(separatorString, "SEPARATOR", true)).indexOf(" END");
                if (pos2 > 0) {
                    String endSeparatorString = separatorString.substring(pos2 + 1).trim();
                    endSeparatorString = this.removePrefix(endSeparatorString, "END", true);
                    endSeparatorEx = this.parseExpression(endSeparatorString);
                    separatorString = separatorString.substring(0, pos2).trim();
                }
                separatorEx = this.parseExpression(separatorString);
                result = result.substring(0, pos1).trim();
            }
            Expression init = this.parseExpression(result);
            I iterator = this.factory.createVariable(iterName, init, true);
            this.push(new InPlaceForCommand<I>(iterator, init, separatorEx, endSeparatorEx), curStart, pos);
            ((Resolver)this.resolver).pushLevel();
            ((Resolver)this.resolver).add(iterator);
        }
        catch (VilException e) {
            this.warnParsingIgnoring(expressionString, (Throwable)((Object)e));
            result = expressionString;
        }
        return result;
    }

    private String handleInPlaceVarDecl(String expressionString, int curStart, int pos) {
        String result;
        try {
            Expression init;
            result = this.removePrefix(expressionString, "VAR", true);
            int pos1 = this.consumeJavaIdentifierPart(result);
            String varName = result.substring(0, pos1);
            result = this.consumeWhitespaces(result.substring(pos1));
            if (result.startsWith("=")) {
                result = this.consume(result, '=');
            }
            if ((init = this.parseExpression(result = this.consumeWhitespaces(result))) == null) {
                throw new VilException("Initialization expression missing / not resolved.", 30003);
            }
            I var = this.factory.createVariable(varName, init, false);
            this.push(new InPlaceVarDeclCommand<I>(var), curStart, pos);
        }
        catch (VilException e) {
            this.warnParsingIgnoring(expressionString, (Throwable)((Object)e));
            result = expressionString;
        }
        return result;
    }

    private String handleInPlaceImport(final String expressionString, int curStart, int pos) {
        String result;
        try {
            result = this.removePrefix(expressionString, "IMPORT", true);
            int pos1 = this.consumeJavaIdentifierPart(result);
            String name = result.substring(0, pos1);
            result = this.consumeWhitespaces(result.substring(pos1));
            IVersionRestriction restriction = null;
            if (result.startsWith("WITH")) {
                result = result.substring(4);
                I var = this.factory.createVariableDeclaration("version", TypeRegistry.versionType());
                ((Resolver)this.resolver).pushLevel();
                ((Resolver)this.resolver).add(var);
                Expression expression = this.parseExpression(result);
                ((Resolver)this.resolver).popLevel();
                ExpressionVersionRestrictionValidator validator = new ExpressionVersionRestrictionValidator(new IMessageHandler(){

                    public void handle(String message, boolean error, int code) {
                        StringParser.this.getLogger().warn("While parsing/resolving '" + expressionString + "': " + message + ". Ignoring.");
                    }
                });
                expression.accept(validator);
                restriction = this.factory.createVersionRestriction(expression, var);
                result = this.consumeWhitespaces(result);
            }
            this.push(new InPlaceImportCommand(name, restriction), curStart, pos);
        }
        catch (VilException e) {
            this.warnParsingIgnoring(expressionString, (Throwable)((Object)e));
            result = expressionString;
        }
        return result;
    }

    protected Expression join(Expression expr) {
        Expression result = expr;
        return result;
    }

    protected Expression parseExpression(String expressionString) throws VilException {
        Expression result = this.parseExpressionImpl(expressionString);
        if (result instanceof VariableExpression) {
            VariableExpression e = (VariableExpression)result;
            result = new VariableEx(e.getDeclaration(), e.getQualifiedName());
        }
        return result;
    }

    protected abstract Expression parseExpressionImpl(String var1) throws VilException;

    protected Expression createConstantStringExpression(String string) throws VilException {
        return new ConstantExpression(TypeRegistry.stringType(), string, ((Resolver)this.getResolver()).getTypeRegistry());
    }

    private void advanceState(int curStart, int pos) {
        if (this.isNonEmptyCommandStack()) {
            InPlaceCommand<I> cur = this.commandStack.peek();
            cur.advanceState();
            this.notifyStartInPlaceCommand(cur, curStart, pos);
        }
    }

    private Expression close(int curStart, int pos) throws VilException {
        Expression result = null;
        if (this.isNonEmptyCommandStack()) {
            InPlaceCommand<I> cur = this.commandStack.pop();
            result = cur.close(this.factory);
            if (result != null && this.isNonEmptyCommandStack()) {
                this.commandStack.peek().replace(cur, result);
            }
            this.notifyEndInPlaceCommand(cur, result, curStart, pos);
        }
        return result;
    }

    protected void clearStatementStack(List<Expression> expressions) {
        if (this.commandStack != null) {
            while (!this.commandStack.isEmpty()) {
                this.popFromCommandStack(expressions);
            }
        }
    }

    protected void popFromCommandStack(List<Expression> expressions) {
        InPlaceCommand<I> cmd = this.commandStack.pop();
        if (cmd.holdsResolverLevel()) {
            ((Resolver)this.resolver).popLevel();
        }
        if (this.commandStack.isEmpty()) {
            cmd.append(expressions);
        }
    }

    protected void addExpression(Expression expr, List<Expression> expressions) {
        if (expr != null) {
            if (this.isNonEmptyCommandStack()) {
                this.commandStack.peek().append(expr);
            } else {
                expressions.add(expr);
            }
        }
    }

    protected boolean isNonEmptyCommandStack() {
        return this.commandStack != null && !this.commandStack.isEmpty();
    }

    private void push(InPlaceCommand<I> cmd, int curStart, int pos) {
        if (this.commandStack != null) {
            if (!this.commandStack.isEmpty()) {
                this.commandStack.peek().append(cmd);
            }
            this.commandStack.push(cmd);
            this.notifyStartInPlaceCommand(cmd, curStart, pos);
        }
    }

    protected InPlaceCommand<I> getCurrentInPlaceCommand() {
        InPlaceCommand<I> result = this.isNonEmptyCommandStack() ? this.commandStack.peek() : null;
        return result;
    }

    protected void notifyStartInPlaceCommand(InPlaceCommand<I> cmd, int curStart, int pos) {
    }

    protected void notifyBracketsClosed(InPlaceCommand<I> cmd, int pos) {
    }

    protected void notifyEndInPlaceCommand(InPlaceCommand<I> cmd, Expression expr, int curStart, int pos) {
    }

    protected int consumeJavaIdentifierPart(String string) {
        int pos = 0;
        while (pos < string.length() && Character.isJavaIdentifierPart(string.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    protected String removePrefix(String text, String prefix, boolean consumeFollowingWhitespaces) {
        String result = text;
        if (result.startsWith(prefix)) {
            result = result.substring(prefix.length());
            if (consumeFollowingWhitespaces) {
                result = this.consumeWhitespaces(result);
            }
        }
        return result;
    }

    protected String consumeWhitespaces(String text) {
        return this.consume(text, ' ');
    }

    protected String consume(String text, char ch) {
        String result = text;
        int pos = 0;
        while (pos < result.length() && ch == result.charAt(pos)) {
            ++pos;
        }
        if (pos > 0) {
            result = result.substring(pos);
        }
        return result;
    }

    private P completeParsing(State state) throws VilException {
        switch (state) {
            case VARIABLE: {
                this.handleVariable(this.curStart, this.pos);
                break;
            }
            case EXPRESSION: {
                if (this.pos >= this.text.length() || '}' != this.text.charAt(this.pos) || this.innerBracketLevel != 0) break;
                this.handleExpression(this.curStart, this.pos);
                break;
            }
            default: {
                this.handleEndOfText(this.curStart, this.pos, state);
            }
        }
        return this.createParseResult();
    }

    protected EASyLoggerFactory.EASyLogger getLogger() {
        return EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core");
    }

    protected void warnParsingIgnoring(String detail, Throwable th) {
        this.getLogger().warn("While parsing/resolving '" + detail + "': " + th.getMessage() + ". Ignoring.");
    }

    private void setCurStart(int pos) {
        if (pos >= 0) {
            this.curStart = pos;
        }
    }

    protected int setPos(int pos) {
        this.pos = pos;
        return this.pos;
    }

    protected String toText() {
        return this.text.toString();
    }

    protected String substring(int start, int end) {
        return this.text.substring(start, end);
    }

    protected void deleteCharAt(int pos) {
        this.text.deleteCharAt(pos);
    }

    protected void delete(int start, int end) {
        this.text.delete(start, end);
    }

    protected int length() {
        return this.text.length();
    }

    protected char charAt(int pos) {
        return this.text.charAt(pos);
    }

    protected int replace(int start, int end, String value) {
        int valueLen = value.length();
        int inTextLen = end - start;
        int result = end;
        if (inTextLen < valueLen) {
            result += valueLen - inTextLen;
        } else if (inTextLen > valueLen) {
            result -= inTextLen - valueLen;
        }
        this.text.replace(start, end, value);
        return result;
    }

    protected abstract void handleQuote(int var1) throws VilException;

    protected abstract void handleTextEnd(int var1, int var2) throws VilException;

    protected abstract int handleVariableStartExpression(int var1, int var2) throws VilException;

    protected abstract int handleVariableStartVariable(int var1, int var2) throws VilException;

    protected abstract int handleEndOfText(int var1, int var2, State var3) throws VilException;

    protected abstract P createParseResult() throws VilException;

    protected abstract int handleVariable(int var1, int var2) throws VilException;

    protected abstract int handleExpression(int var1, int var2) throws VilException;

    protected static enum State {
        TEXT,
        VARIABLE_START,
        VARIABLE,
        EXPRESSION;

    }
}

