/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypedModel;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;

public class VarModelIdentifierExpression
extends Expression {
    private String identifier;
    private TypeDescriptor<?> type;
    private ITypedModel model;

    public VarModelIdentifierExpression(String identifier, TypeDescriptor<?> type, IModel model) {
        this(identifier, type, model instanceof ITypedModel ? (ITypedModel)model : null);
    }

    public VarModelIdentifierExpression(String identifier, TypeDescriptor<?> type, ITypedModel model) {
        this.identifier = identifier;
        this.type = type == null ? TypeRegistry.DEFAULT.getType(IvmlElement.class) : type;
        this.model = model;
    }

    public ITypedModel getModel() {
        return this.model;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public TypeDescriptor<?> getType() {
        return this.type;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return this.type;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitVarModelIdentifierExpression(this);
    }

    public void markAsResolved() {
        this.identifier = "";
    }

    public boolean isMarkedAsResolved() {
        return this.identifier != null && this.identifier.length() == 0;
    }
}

