/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class VariableExpression
extends Expression {
    private VariableDeclaration variable;
    private String qualifiedName;

    VariableExpression() {
    }

    public VariableExpression(VariableDeclaration variable) {
        this(variable, null);
    }

    public VariableExpression(VariableDeclaration variable, String qualifiedName) {
        this.variable = variable;
        this.qualifiedName = qualifiedName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getName() {
        return this.variable.getName();
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return this.variable.getType();
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitVariableExpression(this);
    }

    public VariableDeclaration getDeclaration() {
        return this.variable;
    }

    public static String composeUnkownVariableWarning(String name) {
        return "'" + name + "' is unknown, shall be a VIL variable, a VIL type or an IVML variable / annotation - may lead to a runtime error";
    }
}

