/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class BuilderBlockExpression
extends Expression
implements IArgumentProvider {
    private VariableDeclaration var;
    private TemplateBlock block;
    private Mode mode;

    public BuilderBlockExpression(VariableDeclaration var, Mode mode, TemplateBlock block) {
        this.mode = mode;
        this.var = var;
        this.block = block;
    }

    public VariableDeclaration getVariable() {
        return this.var;
    }

    public TemplateBlock getBlock() {
        return this.block;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return this.var.getType();
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        if (visitor instanceof ITemplateLangVisitor) {
            return ((ITemplateLangVisitor)visitor).visitBuilderBlockExpression(this);
        }
        return null;
    }

    @Override
    public int getArgumentsCount() {
        return 1;
    }

    @Override
    public CallArgument getArgument(int index) {
        return new CallArgument(this.var.getExpression());
    }

    public static enum Mode {
        NONE,
        NAME,
        TYPE_NAME;

    }
}

