/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionIterator;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.InContentExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ContentLoopExpression
extends InContentExpression
implements IExpressionIterator {
    private VariableDeclaration iterator;
    private Expression init;
    private Expression separator;
    private Expression endSeparator;
    private List<Expression> body;

    public ContentLoopExpression(VariableDeclaration iterator, Expression init, Expression separator, Expression endSeparator, List<Expression> body) throws VilException {
        this.iterator = iterator;
        this.init = init;
        this.separator = separator;
        this.endSeparator = endSeparator;
        this.assertSeparatorEx(this.separator, "Separator");
        this.assertSeparatorEx(this.endSeparator, "End separator");
        this.body = body;
    }

    private void assertSeparatorEx(Expression ex, String text) throws VilException {
        if (ex != null && !TypeRegistry.stringType().isAssignableFrom(ex.inferType())) {
            throw new VilException(text + " expression must evaluate to String", 30006);
        }
    }

    public VariableDeclaration getIterator() {
        return this.iterator;
    }

    public Expression getInit() {
        return this.init;
    }

    public Expression getSeparator() {
        return this.separator;
    }

    public Expression getEndSeparator() {
        return this.endSeparator;
    }

    @Override
    public int getExpressionsCount() {
        return this.body.size();
    }

    @Override
    public Expression getExpression(int index) {
        return this.body.get(index);
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IVisitor ? ((IVisitor)((Object)visitor)).visitContentLoopExpression(this) : null;
        return result;
    }
}

