/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.ExtensionClassLoaders;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class JavaExtension {
    private String name;
    private ClassWrapper resolved;
    private boolean isDefault;

    JavaExtension() {
    }

    public JavaExtension(String name, TypeRegistry registry) throws VilException {
        this.name = name;
        int l = ExtensionClassLoaders.getLoaderCount() - 1;
        while (this.resolved == null && l >= 0) {
            try {
                this.resolved = new ClassWrapper(ExtensionClassLoaders.getLoader(l).loadClass(name), registry);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            --l;
        }
        if (this.resolved == null) {
            throw new VilException("extension class " + name + " not found (class loader registered?)", 50005);
        }
    }

    public JavaExtension(Class<?> extension, TypeRegistry registry) throws VilException {
        this.name = extension.getName();
        this.resolved = new ClassWrapper(extension, registry);
        this.isDefault = true;
    }

    public IMetaType getResolved() {
        return this.resolved;
    }

    public String getName() {
        return this.name;
    }

    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitJavaExtension(this);
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

