/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.messages.AbstractException;
import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactTypes;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ExecutionVisitor;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.ITerminatable;
import net.ssehub.easy.instantiation.core.model.common.ModelCallExpression;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionParserRegistry;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionParser;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringReplacer;
import net.ssehub.easy.instantiation.core.model.templateModel.AlternativeStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.BuilderBlockExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentAlternativeExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentFormatter;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentImportExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentLoopExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentVarDeclExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.FlushStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;
import net.ssehub.easy.instantiation.core.model.templateModel.InContentExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.IndentationUtils;
import net.ssehub.easy.instantiation.core.model.templateModel.JavaExtension;
import net.ssehub.easy.instantiation.core.model.templateModel.LoopStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.NoTracer;
import net.ssehub.easy.instantiation.core.model.templateModel.Resolver;
import net.ssehub.easy.instantiation.core.model.templateModel.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.templateModel.SwitchStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateCallExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.templateModel.WhileStatement;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;

public class TemplateLangExecution
extends ExecutionVisitor<Template, Def, VariableDeclaration, Resolver>
implements ITemplateLangVisitor,
ITerminatable {
    public static final ExpressionParserRegistry.ILanguage<Resolver> LANGUAGE = new ExpressionParserRegistry.ILanguage<Resolver>(){

        @Override
        public String getName() {
            return "VTL";
        }
    };
    public static final String DEFAULT_MAIN_TEMPLATE = "main";
    public static final String PARAM_CONFIG = "config";
    public static final String PARAM_TARGET = "target";
    public static final String INTERNAL_PARAM_PREFIX = "$$";
    public static final String PARAM_CONFIG_SURE = "$$config";
    public static final String PARAM_TARGET_SURE = "$$target";
    private static final List<JavaExtension> DEFAULT_EXTENSIONS = new ArrayList<JavaExtension>();
    private static final String EMPTY_CONTENT = "\u0000\u0001\u0000";
    private RuntimeEnvironment environment;
    private Writer mainOut;
    private PrintWriter out;
    private String mainName;
    private ITracer tracer;
    private boolean stop = false;
    private int contentNestingLevel;
    private int lastContentNestingLevel = -1;
    private boolean lastContentFormatted = false;
    private Stack<String> defContentStack = new Stack();
    private ContentStatement lastContent = null;
    private ContentStatement.LineEndType lastContentLineEndType = ContentStatement.LineEndType.DEFAULT;
    private ContentFormatter contentFormatter;

    public TemplateLangExecution(ITracer tracer, Writer out, Map<String, Object> parameter) {
        this(tracer, out, DEFAULT_MAIN_TEMPLATE, parameter);
    }

    public TemplateLangExecution(ITracer tracer, Writer out, String mainName, Map<String, Object> parameter) {
        super(new RuntimeEnvironment(), tracer, parameter);
        this.environment = (RuntimeEnvironment)this.getRuntimeEnvironment();
        this.mainOut = out;
        this.out = new PrintWriter(out);
        this.mainName = mainName;
        this.tracer = tracer;
        this.enableArtifactAutoStoreOnParameters(false);
    }

    TemplateLangExecution(RuntimeEnvironment environment) {
        super(environment, NoTracer.INSTANCE, new HashMap<String, Object>());
        this.environment = environment;
        this.out = new PrintWriter(new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(char[] arg0, int arg1, int arg2) throws IOException {
            }
        });
        this.mainName = DEFAULT_MAIN_TEMPLATE;
        this.tracer = NoTracer.INSTANCE;
    }

    @Override
    public void release(boolean releaseDefault) {
        this.enableArtifactAutoStoreOnParameters(true);
        super.release(releaseDefault);
    }

    public static void registerDefaultExtension(Class<?> extension) {
        if (extension != null) {
            EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(TemplateLangExecution.class, "net.ssehub.easy.instantiation.core");
            try {
                DEFAULT_EXTENSIONS.add(new JavaExtension(extension, TypeRegistry.DEFAULT));
                logger.info("registered default VTL extension " + extension.getName());
            }
            catch (VilException e) {
                logger.exception((Exception)((Object)e));
            }
        }
    }

    public static int getDefaultExtensionCount() {
        return DEFAULT_EXTENSIONS.size();
    }

    public static JavaExtension getDefaultExtension(int index) {
        return DEFAULT_EXTENSIONS.get(index);
    }

    @Override
    public Object visitTemplate(Template template) throws VilException {
        this.environment.switchContext(template);
        this.tracer.visitTemplate(template);
        this.visitModelHeader(template);
        this.contentFormatter = new ContentFormatter();
        this.contentFormatter.setFormattingConfiguration(this.getFormattingConfiguration());
        this.contentFormatter.setIndentationConfiguration(this.environment.getIndentationConfiguration());
        Def main = null;
        int d = 0;
        while (main == null && d < template.getDefCount()) {
            Def def = template.getDef(d);
            if (def.getName().equals(this.mainName) && template.getParameterCount() == def.getParameterCount()) {
                main = def;
                int p = 0;
                while (main != null && p < template.getParameterCount()) {
                    if (!template.getParameter(p).getType().isAssignableFrom(def.getParameter(p).getType())) {
                        main = null;
                    }
                    ++p;
                }
            }
            ++d;
        }
        if (main == null) {
            throw new VilException("no '" + this.mainName + "' template found with suitable parameters", 50003);
        }
        Object result = this.executeMain(template, main);
        this.tracer.visitedTemplate(template);
        return result;
    }

    @Override
    public Object visitDef(Def def) throws VilException {
        Object result;
        this.defContentStack.push("");
        if (def.isPlaceholder()) {
            result = null;
        } else {
            this.tracer.visitDef(def, this.environment);
            result = this.visitTemplateBlock(def);
            if (this.lastContent != null && this.lastContent.needsLineEnd(this.contentNestingLevel == 0)) {
                this.appendContent(this.getLineEnd());
            }
            this.lastContent = null;
            this.tracer.visitedDef(def, this.environment, result);
        }
        String content = this.defContentStack.pop();
        if (this.contentNestingLevel == 0) {
            if (this.defContentStack.isEmpty()) {
                this.emit(content);
            } else {
                this.appendContent(content);
            }
        }
        return result;
    }

    private void emit(String content) {
        if (this.contentFormatter != null) {
            content = this.contentFormatter.format(content);
        }
        if (content != null) {
            this.out.print(content);
        }
    }

    private void increaseIndentation(ITemplateElement element) {
        if (!element.isBlock()) {
            this.environment.increaseIndentation();
        }
    }

    private void decreaseIndentation(ITemplateElement element) {
        if (!element.isBlock()) {
            this.environment.decreaseIndentation();
        }
    }

    @Override
    public Object visitTemplateBlock(TemplateBlock block) throws VilException {
        boolean ok = true;
        boolean returns = !TypeRegistry.voidType().isSame(block.inferType());
        Object value = null;
        Object lastValue = null;
        this.environment.increaseIndentation();
        int count = block.getBodyElementCount();
        int e = 0;
        while (ok && !this.stop && e < count) {
            ITemplateElement elt = block.getBodyElement(e);
            value = elt.accept(this);
            if (elt.isLoop() && elt.endsWithContentStatement() && value == EMPTY_CONTENT && lastValue instanceof String) {
                value = lastValue;
            }
            if ((!returns || returns && e + 1 < count) && this.mayFail(elt)) {
                ok = this.checkConditionResult(value, block, ExecutionVisitor.ConditionTest.DONT_CARE);
            }
            if (!ok) {
                this.tracer.failedAt(block.getBodyElement(e));
                value = null;
            }
            lastValue = value;
            ++e;
        }
        this.environment.decreaseIndentation();
        return value;
    }

    @Override
    public Object visitAlternative(AlternativeStatement alternative) throws VilException {
        Object value = null;
        Expression cond = alternative.getCondition();
        Object condValue = cond.accept(this);
        if (this.checkConditionResult(condValue, cond, ExecutionVisitor.ConditionTest.DONT_CARE)) {
            ITemplateElement ifStmt = alternative.getIfStatement();
            this.increaseIndentation(ifStmt);
            this.tracer.visitAlternative(true);
            value = ifStmt.accept(this);
            this.decreaseIndentation(ifStmt);
            value = this.checkContentStatement(value, null, alternative.getIfStatement());
        } else if (alternative.getElseStatement() != null) {
            ITemplateElement elseStmt = alternative.getElseStatement();
            this.increaseIndentation(elseStmt);
            this.tracer.visitAlternative(false);
            value = elseStmt.accept(this);
            this.decreaseIndentation(elseStmt);
            value = this.checkContentStatement(value, null, alternative.getElseStatement());
        } else {
            boolean isIfContentStatement = TemplateLangExecution.isContentStatement(alternative.getIfStatement());
            if (isIfContentStatement) {
                value = !this.defContentStack.isEmpty() ? this.defContentStack.peek() : "";
            }
            value = this.checkContentStatement(value, null, isIfContentStatement);
        }
        return value;
    }

    private String getSeparatorFromExpression(Expression expression) throws VilException {
        String separator = expression != null ? StringValueHelper.getStringValue(expression.accept(this), null) : null;
        return separator;
    }

    @Override
    public Object visitLoop(LoopStatement loop) throws VilException {
        Expression expr = loop.getContainerExpression();
        Object object = this.convertToContainer(expr, expr.accept(this), "loop");
        String separator = this.getSeparatorFromExpression(loop.getSeparatorExpression());
        String finalSeparator = this.getSeparatorFromExpression(loop.getFinalSeparatorExpression());
        Object bodyResult = NullValue.VALUE;
        if (object instanceof net.ssehub.easy.instantiation.core.model.vilTypes.Collection) {
            VariableDeclaration iterVar = loop.getIteratorVariable();
            this.environment.pushLevel();
            net.ssehub.easy.instantiation.core.model.vilTypes.Collection collection = (net.ssehub.easy.instantiation.core.model.vilTypes.Collection)object;
            Iterator iter = collection.iterator();
            this.tracer.visitLoop(iterVar);
            while (iter.hasNext() && !this.stop) {
                Object value = iter.next();
                this.environment.addValue(iterVar, value);
                this.tracer.valueDefined(iterVar, null, value);
                ITemplateElement loopStmt = loop.getLoopStatement();
                this.increaseIndentation(loopStmt);
                bodyResult = loopStmt.accept(this);
                this.decreaseIndentation(loopStmt);
                if (separator != null && iter.hasNext()) {
                    this.appendContent(separator);
                }
                if (finalSeparator == null || iter.hasNext()) continue;
                this.appendContent(finalSeparator);
            }
            this.tracer.visitedLoop(iterVar);
            this.environment.popLevel();
        } else if (object != null) {
            throw new VilException("loop must iterate over collection", 70001);
        }
        return this.checkContentStatement(bodyResult, NullValue.VALUE, loop.getLoopStatement());
    }

    private Object checkContentStatement(Object currentValue, Object noValue, ITemplateElement check) {
        return this.checkContentStatement(currentValue, noValue, TemplateLangExecution.isContentStatement(check));
    }

    private Object checkContentStatement(Object currentValue, Object noValue, boolean isContentStatement) {
        Object result = currentValue;
        if (noValue == currentValue && isContentStatement) {
            result = EMPTY_CONTENT;
        }
        return result;
    }

    private static final boolean isContentStatement(ITemplateElement elt) {
        return elt == null ? false : elt.endsWithContentStatement();
    }

    private void appendContent(String string) {
        Object topContent = this.defContentStack.pop();
        topContent = topContent == null ? string : (String)topContent + string;
        this.defContentStack.push((String)topContent);
    }

    @Override
    public Object visitSwitch(SwitchStatement swtch) throws VilException {
        this.environment.pushLevel();
        Object select = swtch.getSwitchExpression().accept(this);
        this.environment.addValue(swtch.getImplicitVariable(), select);
        int found = -1;
        Object value = null;
        int a = 0;
        while (found < 0 && a < swtch.getAlternativeCount()) {
            SwitchStatement.Alternative alt = swtch.getAlternative(a);
            boolean take = alt.isDefault();
            if (!take) {
                Expression cond = alt.getCondition();
                Object condValue = cond.accept(this);
                take = this.equals(condValue, select);
            }
            if (take) {
                value = alt.getValue().accept(this);
                found = a;
            }
            ++a;
        }
        this.tracer.visitedSwitch(select, found, value);
        this.environment.popLevel();
        return value;
    }

    private boolean equals(Object condValue, Object exprValue) {
        boolean result = condValue.equals(exprValue);
        if (!result && exprValue instanceof IvmlElement) {
            IvmlElement iElt = (IvmlElement)exprValue;
            if (condValue instanceof String) {
                result = condValue.equals(iElt.getStringValue());
            } else if (condValue instanceof Integer) {
                result = condValue.equals(iElt.getIntegerValue());
            } else if (condValue instanceof Boolean) {
                result = condValue.equals(iElt.getBooleanValue());
            } else if (condValue instanceof Double) {
                result = condValue.equals(iElt.getRealValue());
            } else if (condValue instanceof EnumValue) {
                result = condValue.equals(iElt.getEnumValue());
            }
        }
        return result;
    }

    @Override
    public Object visitContentStatement(ContentStatement cnt) throws VilException {
        ++this.contentNestingLevel;
        this.lastContentFormatted = false;
        if (this.lastContent != null && this.lastContent.needsLineEnd(true)) {
            this.appendContent(this.getLineEnd());
        }
        this.lastContent = null;
        String content = (String)cnt.getContent().accept(this);
        if (content != null) {
            content = TemplateLangExecution.cleanLineEnd(content, true);
        }
        if (content != null) {
            String topContent;
            int forced = 0;
            if (cnt.getIndentExpression() != null) {
                Object val = cnt.getIndentExpression().accept(this);
                if (val instanceof Integer) {
                    forced = (Integer)val;
                } else {
                    throw new VilException("indentation value is no integer", 70001);
                }
            }
            if (forced >= 0) {
                int indentation = this.environment.getIndentation();
                if (indentation > 0) {
                    int indent = indentation + this.getAdditionalIndentation();
                    content = IndentationUtils.removeIndentation(content, indent, this.getTabEmulation());
                }
                if (forced > 0) {
                    content = IndentationUtils.insertIndentation(content, forced, this.contentNestingLevel > 1);
                    this.lastContentFormatted = true;
                }
            }
            topContent = (topContent = this.defContentStack.pop()).length() == 0 || forced < 0 ? content : IndentationUtils.appendWithLastIndentation(topContent, content, this.contentNestingLevel == 1 || this.lastContentNestingLevel == this.contentNestingLevel);
            this.defContentStack.push(topContent);
            content = topContent;
        }
        this.lastContentNestingLevel = this.contentNestingLevel--;
        this.lastContent = cnt;
        this.lastContentLineEndType = cnt.getLineEndType();
        return content;
    }

    @Override
    protected boolean lastContentReplaceEmptyLine() {
        boolean result = this.lastContentLineEndType == ContentStatement.LineEndType.NO_LINE_END;
        this.lastContentLineEndType = null;
        return result;
    }

    private static String cleanLineEnd(String content, boolean includeIndentation) {
        int pos;
        do {
            int start;
            if ((pos = ((String)content).indexOf(EMPTY_CONTENT)) < 0) continue;
            int end = pos + EMPTY_CONTENT.length();
            if (includeIndentation) {
                while (end < ((String)content).length() && IndentationUtils.isLineEnd(((String)content).charAt(end))) {
                    ++end;
                }
            }
            if ((start = pos) > 0) {
                --start;
                if (includeIndentation) {
                    while (start >= 0 && IndentationUtils.isIndentationChar(((String)content).charAt(start))) {
                        --start;
                    }
                }
                if (start < 0) {
                    start = 0;
                }
            }
            content = ((String)content).substring(0, start) + ((String)content).substring(end);
        } while (pos >= 0);
        return content;
    }

    @Override
    protected String appendInCompositeExpression(String s1, Expression e1, Object v1, String s2, Expression e2) {
        String result;
        boolean format = false;
        boolean clear = false;
        boolean isS1 = false;
        IndentationConfiguration config = this.environment.getIndentationConfiguration();
        if (e1 instanceof ConstantExpression && e2 instanceof TemplateCallExpression) {
            boolean bl = format = !this.lastContentFormatted;
            if (format && s1.length() > 0) {
                char last = s1.charAt(s1.length() - 1);
                format = IndentationUtils.isLineEnd(last) || IndentationUtils.isIndentationChar(last);
            }
        } else if (e2 instanceof InContentExpression) {
            clear = config != null && s2.isEmpty();
        } else if (e1 instanceof InContentExpression && v1.toString().isEmpty() && IndentationUtils.isIndentationString(s2)) {
            format = false;
            isS1 = true;
        }
        String hint = e2.getFormattingHint();
        boolean clearLE = false;
        if (hint != null) {
            if ("e".equals(hint)) {
                if (s2.length() == 0) {
                    clear = true;
                    clearLE = true;
                } else {
                    format = true;
                }
            } else if ("<".equals(hint)) {
                s1 = IndentationUtils.removeLastIndentation(s1, false);
                clear = false;
                format = false;
                isS1 = false;
            }
        }
        if (format) {
            int indent;
            int indentation = this.environment.getIndentation();
            if ((indentation -= this.getIndentationStep()) > 0 && IndentationUtils.allLinesStartWith(s2, indent = indentation + this.getAdditionalIndentation())) {
                s2 = IndentationUtils.removeIndentation(s2, indent, this.getTabEmulation());
            }
            result = IndentationUtils.appendWithLastIndentation(s1, s2, false);
        } else {
            result = clear ? IndentationUtils.removeLastIndentation(s1, clearLE) : (isS1 ? s1 : super.appendInCompositeExpression(s1, e1, v1, s2, e2));
        }
        return result;
    }

    private int getAdditionalIndentation() {
        IndentationConfiguration icfg = this.environment.getIndentationConfiguration();
        return icfg == null ? 0 : icfg.getAdditional();
    }

    private int getTabEmulation() {
        IndentationConfiguration icfg = this.environment.getIndentationConfiguration();
        return icfg == null ? 0 : icfg.getTabEmulation();
    }

    private int getIndentationStep() {
        IndentationConfiguration icfg = this.environment.getIndentationConfiguration();
        return icfg == null ? 0 : icfg.getIndentationStep();
    }

    private String getLineEnd() {
        return FormattingConfiguration.getLineEnding(this.getFormattingConfiguration());
    }

    private FormattingConfiguration getFormattingConfiguration() {
        FormattingConfiguration cfg = null;
        IResolvableModel model = this.environment.getContextModel();
        if (model instanceof Template) {
            Template template = (Template)model;
            cfg = template.getFormattingConfiguration();
        }
        return cfg;
    }

    @Override
    public Object visitConstantExpression(ConstantExpression cst) throws VilException {
        Object result = cst.getValue();
        if (result instanceof String) {
            result = StringReplacer.substitute(result.toString(), new Resolver(this.environment), this.getExpressionParser(), this, null);
        }
        return result;
    }

    @Override
    public Object visitJavaExtension(JavaExtension ext) throws VilException {
        return null;
    }

    @Override
    public Object visitTemplateCallExpression(TemplateCallExpression call) throws VilException {
        Object result;
        if (this.stop) {
            result = null;
        } else {
            int indentation = this.environment.getIndentation();
            this.environment.setIndentationSteps(1);
            result = this.visitModelCallExpression(call);
            this.environment.setIndentation(indentation);
        }
        return result;
    }

    @Override
    protected Object executeModelCall(Def def) throws VilException {
        return def.accept(this);
    }

    @Override
    protected ModelCallExpression<VariableDeclaration, Template, Def> createModelCall(Template model, Def operation, CallArgument ... arguments) throws VilException {
        return new TemplateCallExpression(model, operation, arguments);
    }

    @Override
    protected Def dynamicDispatch(Def operation, Object[] args, IArgumentProvider argumentProvider, boolean enableParentScope) {
        return AbstractCallExpression.dynamicDispatch(operation, args, Def.class, this.environment.getTypeRegistry(), argumentProvider, enableParentScope ? this.environment.getMostSpecificContextModel() : null);
    }

    @Override
    protected void handleParameterInSequence(IResolvableModel<VariableDeclaration, Template> model, Map<String, VariableDeclaration> varMap) throws VilException {
        if (model.getParameterCount() >= 2) {
            boolean ok = IvmlTypes.configurationType().isAssignableFrom(((VariableDeclaration)model.getParameter(0)).getType());
            if (ok &= ArtifactTypes.artifactType().isAssignableFrom(((VariableDeclaration)model.getParameter(1)).getType())) {
                this.assignModelParameter(model, model);
                int p = 0;
                while (p < 2) {
                    varMap.remove(((VariableDeclaration)model.getParameter(p)).getName());
                    ++p;
                }
            }
        }
        varMap.remove(PARAM_CONFIG_SURE);
        varMap.remove(PARAM_TARGET_SURE);
    }

    @Override
    protected void assignModelParameter(IResolvableModel<VariableDeclaration, Template> targetModel, IResolvableModel<VariableDeclaration, Template> srcModel) throws VilException {
        if (srcModel.getParameterCount() >= 1) {
            this.setModelArgument((VariableDeclaration)srcModel.getParameter(0), this.getParameter(PARAM_CONFIG_SURE));
        }
        if (srcModel.getParameterCount() >= 2) {
            this.setModelArgument((VariableDeclaration)srcModel.getParameter(1), this.getParameter(PARAM_TARGET_SURE));
        }
        this.evaluateModelParameter(targetModel, srcModel, 2);
    }

    @Override
    protected IExpressionParser<Resolver> getExpressionParser() {
        return ExpressionParserRegistry.getExpressionParser(LANGUAGE);
    }

    @Override
    public Object visitResolvableOperationCallExpression(ResolvableOperationCallExpression ex) throws VilException {
        Object result;
        Object val = this.environment.getValue(ex.getVariable());
        int indentation = this.environment.getIndentation();
        this.environment.setIndentationSteps(1);
        if (val instanceof Def) {
            Def def = (Def)val;
            result = this.proceedModelCall(def, (Template)this.environment.getContextModel(), ex, ex.isPlaceholder(), false);
        } else {
            result = super.visitResolvableOperationCallExpression(ex);
        }
        this.environment.setIndentation(indentation);
        return result;
    }

    @Override
    public Object visitTypedef(Typedef typedef) throws VilException {
        return null;
    }

    @Override
    public Object visitWhile(WhileStatement stmt) throws VilException {
        Expression condition = stmt.getConditionExpression();
        boolean executeLoop = false;
        this.environment.pushLevel();
        Object bodyResult = NullValue.VALUE;
        do {
            Object conditionResult;
            boolean bl = executeLoop = (conditionResult = condition.accept(this)) instanceof Boolean && (Boolean)conditionResult != false;
            if (!executeLoop) continue;
            this.tracer.visitWhileBody();
            ITemplateElement loopStmt = stmt.getLoopStatement();
            this.increaseIndentation(loopStmt);
            bodyResult = loopStmt.accept(this);
            if (bodyResult == null) {
                executeLoop = false;
            }
            this.decreaseIndentation(loopStmt);
            this.tracer.visitedWhileBody();
        } while (executeLoop && !this.stop);
        this.environment.popLevel();
        return this.checkContentStatement(bodyResult, NullValue.VALUE, stmt.getLoopStatement());
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    @Override
    public Object visitFlush(FlushStatement stmt) throws VilException {
        this.tracer.visitFlush();
        this.storeContent();
        this.tracer.visitedFlush();
        return null;
    }

    public void storeContent() throws VilException {
        Object tgt = this.getParameter(PARAM_TARGET_SURE);
        if (tgt == null) {
            tgt = this.getParameter(PARAM_TARGET);
        }
        if (tgt instanceof IArtifact && this.mainOut instanceof StringWriter) {
            TemplateLangExecution.storeContent((IArtifact)tgt, (StringWriter)this.mainOut);
        }
    }

    public static void storeContent(IArtifact target, StringWriter out) throws VilException {
        String tmp;
        if (target.enableContentStore() && (tmp = out.toString()).length() > 0) {
            target.getText().setText(tmp);
        }
        target.store();
    }

    @Override
    public Object visitContentAlternativeExpression(ContentAlternativeExpression ex) throws VilException {
        String result = null;
        Object cond = ex.getCondition().accept(this);
        if (Boolean.TRUE.equals(cond)) {
            result = this.evaluateContentExpression(ex.thenEx());
        } else if (Boolean.FALSE.equals(cond)) {
            result = ex.getElseExpressionsCount() > 0 ? this.evaluateContentExpression(ex.elseEx()) : "";
        }
        return result;
    }

    private String evaluateSeparator(Expression ex, String deflt) throws VilException {
        String separator = deflt;
        if (ex != null) {
            Object tmp = ex.accept(this);
            separator = tmp == null ? deflt : tmp.toString();
        }
        return separator;
    }

    @Override
    public Object visitContentLoopExpression(ContentLoopExpression ex) throws VilException {
        Object result = null;
        String separator = this.evaluateSeparator(ex.getSeparator(), "");
        String endSeparator = this.evaluateSeparator(ex.getEndSeparator(), "");
        Object init = ex.getInit().accept(this);
        Iterator<Object> iter = init instanceof net.ssehub.easy.instantiation.core.model.vilTypes.Collection ? ((net.ssehub.easy.instantiation.core.model.vilTypes.Collection)init).iterator() : (init instanceof Collection ? ((Collection)init).iterator() : (init instanceof ContainerValue ? ((ContainerValue)init).iterator() : null));
        if (iter != null) {
            result = "";
            this.environment.pushLevel();
            VariableDeclaration decl = ex.getIterator();
            this.environment.addValue(decl, null);
            while (iter.hasNext()) {
                this.environment.setValue(decl, iter.next());
                String tmp = this.evaluateContentExpression(ex);
                if (tmp == null) break;
                result = ((String)result).length() == 0 ? tmp : (String)result + separator + tmp;
            }
            this.environment.popLevel();
            if (((String)result).length() > 0) {
                result = (String)result + endSeparator;
            }
        }
        return result;
    }

    @Override
    public Object visitContentVarDeclExpression(ContentVarDeclExpression ex) throws VilException {
        VariableDeclaration var = ex.getVariable();
        Object value = var.getExpression() != null ? var.getExpression().accept(this) : null;
        this.environment.addValue(var, value);
        return "";
    }

    @Override
    public Object visitContentImportExpression(ContentImportExpression ex) throws VilException {
        try {
            Template resolved;
            Template current = (Template)this.environment.getContextModel();
            AvailableModels available = TemplateModel.INSTANCE.availableModels();
            ModelInfo currentInfo = available.getModelInfo((IModel)current);
            URI baseUri = null;
            if (currentInfo != null) {
                baseUri = currentInfo.getLocation();
            }
            if (baseUri == null) {
                baseUri = this.getFallbackBaseURI();
            }
            if ((resolved = (Template)TemplateModel.INSTANCE.resolve(ex.getTemplate(), ex.getVersionRestriction(), baseUri, this.environment)) != null) {
                ModelImport imp = new ModelImport(ex.getTemplate());
                imp.setResolved((IModel)resolved);
                current.addRuntimeImport(imp);
            }
        }
        catch (ModelManagementException e) {
            throw new VilException((AbstractException)e);
        }
        return "";
    }

    protected URI getFallbackBaseURI() {
        return null;
    }

    @Override
    public Object visitCompound(Compound compound) throws VilException {
        return null;
    }

    @Override
    public Object visitBuilderBlockExpression(BuilderBlockExpression ex) throws VilException {
        this.environment.pushLevel();
        this.tracer.visitBuilderBlock(ex, this.environment);
        Object result = ex.getVariable().getExpression().accept(this);
        this.environment.addValue(ex.getVariable(), result);
        this.visitTemplateBlock(ex.getBlock());
        this.tracer.visitedBuilderBlock(ex, this.environment, result);
        this.environment.popLevel();
        return result;
    }
}

