/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.AbstractTemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class WhileStatement
extends AbstractTemplateElement {
    private Expression condition;
    private ITemplateElement statement;

    public WhileStatement(Expression condition, ITemplateElement statement) throws VilException {
        this.condition = condition;
        this.statement = statement;
        if (condition == null) {
            throw new VilException("no condition given", 70001);
        }
    }

    public Expression getConditionExpression() {
        return this.condition;
    }

    public ITemplateElement getLoopStatement() {
        return this.statement;
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitWhile(this);
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return TypeRegistry.voidType();
    }

    @Override
    public boolean endsWithContentStatement() {
        return this.statement.endsWithContentStatement();
    }
}

