/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.DefaultValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.GenericArguments;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilGenericType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.UnmodifiableSet;

public class Map<K, V>
implements IVilGenericType,
IStringValueProvider {
    @DefaultValue
    public static final java.util.Map<?, ?> DEFAULT = new HashMap();
    private java.util.Map<Object, Object> map = new HashMap<Object, Object>();
    private TypeDescriptor<?>[] generics;
    private TypeDescriptor<?> type;

    Map(TypeDescriptor<?>[] types) {
        this(types, 0);
    }

    Map(TypeDescriptor<?>[] types, int size) {
        assert (types != null && 2 == types.length);
        this.generics = types;
        try {
            this.type = TypeRegistry.getMapType(types);
        }
        catch (VilException e) {
            this.type = TypeRegistry.DEFAULT.findType(Map.class);
        }
        this.map = new HashMap<Object, Object>(size <= 0 ? 10 : size);
    }

    public Map(java.util.Map<Object, Object> map, TypeDescriptor<?>[] generics) {
        assert (generics != null && 2 == generics.length);
        this.generics = generics;
        this.map = map;
        try {
            this.type = TypeRegistry.getMapType(generics);
        }
        catch (VilException e) {
            this.type = TypeRegistry.DEFAULT.findType(Map.class);
        }
    }

    @OperationMeta(name={"[]"})
    public V at(Object key) {
        Object result = key == null ? null : this.map.get(key);
        return (V)result;
    }

    @OperationMeta(name={"containsKey", "hasKey"})
    public boolean containsKey(Object key) {
        boolean result = false;
        if (key != null) {
            result = this.map.containsKey(key);
        }
        return result;
    }

    @OperationMeta(useGenericParameter=1)
    public V get(Object key) {
        return this.at(key);
    }

    @OperationMeta(useGenericParameter=1, name={"get", "defaultget"})
    public V get(Object key, V deflt) {
        V result = deflt;
        if (this.containsKey(key)) {
            result = this.at(key);
        }
        return result;
    }

    @OperationMeta(useGenericParameter=1)
    public V getOrAdd(Object key, V deflt) {
        V result;
        if (this.containsKey(key)) {
            result = this.at(key);
        } else {
            result = deflt;
            this.add(key, result);
        }
        return result;
    }

    public Set<K> keys() {
        return this.getKeys();
    }

    public Set<K> getKeys() {
        SetSet result = new SetSet(new HashSet(), new TypeDescriptor[0]);
        for (Object o : this.map.keySet()) {
            result.add(o);
        }
        return new UnmodifiableSet(result);
    }

    @OperationMeta(useGenericParameter=1)
    public Set<V> values() {
        return this.getValues();
    }

    @OperationMeta(useGenericParameter=1)
    public Set<V> getValues() {
        SetSet result = new SetSet(new HashSet(), new TypeDescriptor[0]);
        for (Object o : this.map.values()) {
            result.add(o);
        }
        return new UnmodifiableSet(result);
    }

    @GenericArguments(value={0, 1})
    public void add(Object key, V value) {
        Object val = value;
        if (key != null) {
            if (2 == this.generics.length) {
                Map map;
                TypeDescriptor<?>[] params;
                Collection coll;
                if (this.generics[1].isMap() && value instanceof Collection && (coll = (Collection)value).size() == 0) {
                    params = TypeDescriptor.createArray(2);
                    params[0] = this.generics[0];
                    params[1] = this.generics[1];
                    val = new Map<K, V>(params);
                }
                if (this.generics[1].isMap() && value instanceof Map && (map = (Map)value).getSize() == 0 && Map.isAnyMap(map) && !Map.isAnyMap(this)) {
                    params = TypeDescriptor.createArray(2);
                    params[0] = this.generics[1].getGenericParameterType(0);
                    params[1] = this.generics[1].getGenericParameterType(1);
                    val = new Map<K, V>(params);
                }
            }
            this.map.put(key, val);
        }
    }

    @GenericArguments(value={0, 1})
    public void put(Object key, V value) {
        this.add(key, value);
    }

    private static final boolean isAnyMap(Map<?, ?> map) {
        return Map.isAny(map.generics[0]) && Map.isAny(map.generics[1]);
    }

    private static final boolean isAny(TypeDescriptor<?> type) {
        return TypeRegistry.equals(TypeRegistry.anyType(), type);
    }

    public void remove(Object key) {
        if (key != null) {
            this.map.remove(key);
        }
    }

    public void clear() {
        this.map.clear();
    }

    @Invisible(inherit=true)
    public int getDimensionCount() {
        return this.generics.length;
    }

    @Override
    public TypeDescriptor<?> getType() {
        return this.type;
    }

    public int getSize() {
        return this.map.size();
    }

    @Invisible(inherit=true)
    public TypeDescriptor<?> getDimensionType(int index) {
        return this.generics[index];
    }

    @Conversion
    public static Map<?, ?> convert(Sequence<?> sequence) throws VilException {
        int seqSize = sequence.size();
        if (seqSize > 0 && sequence.getGenericParameterCount() != 2) {
            throw new VilException("sequence of dimension " + sequence.getGenericParameterCount() + " cannot be converted into a map of dimension 2", 30006);
        }
        TypeDescriptor<?>[] types = TypeDescriptor.createArray(2);
        if (seqSize > 0) {
            types[0] = sequence.getGenericParameterType(0);
            types[1] = sequence.getGenericParameterType(1);
        } else {
            types[0] = TypeRegistry.anyType();
            types[1] = types[0];
        }
        Map result = new Map(types, seqSize);
        int e = 0;
        while (e < seqSize) {
            Sequence seq;
            Object elt = sequence.get(e);
            if (elt instanceof Sequence) {
                seq = (Sequence)elt;
                if (2 != seq.size()) {
                    throw new VilException("sequence in element " + e + "is not of size 2", 30006);
                }
            } else {
                throw new VilException("element " + e + "is not a sequence", 30006);
            }
            result.map.put(seq.get(0), seq.get(1));
            ++e;
        }
        return result;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return Map.getStringValue(this.map, comparator);
    }

    @Invisible
    public static String getStringValue(java.util.Map<?, ?> map, IStringValueProvider.StringComparator comparator) {
        StringBuilder tmp = new StringBuilder("{");
        if (comparator != null) {
            TreeMap sorter = new TreeMap(comparator);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                sorter.put(StringValueHelper.getStringValue(entry.getKey(), comparator), entry.getValue());
            }
            Iterator iter = sorter.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                tmp.append("{");
                tmp.append(entry.getKey());
                tmp.append(", ");
                tmp.append(StringValueHelper.getStringValue(entry.getValue(), comparator));
                tmp.append("}");
                if (!iter.hasNext()) continue;
                tmp.append(", ");
            }
        } else {
            Iterator<?> iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object value = map.get(key);
                tmp.append("{");
                tmp.append(StringValueHelper.getStringValue(key, comparator));
                tmp.append(", ");
                tmp.append(StringValueHelper.getStringValue(value, comparator));
                tmp.append("}");
                if (!iter.hasNext()) continue;
                tmp.append(", ");
            }
        }
        tmp.append("}");
        return tmp.toString();
    }

    @Invisible
    public static Object checkConvertEmpty(TypeDescriptor<?> type, Object value) {
        if (type.isMap() && value instanceof Map && 2 == type.getGenericParameterCount()) {
            Map map = value;
            TypeDescriptor<?> any = TypeRegistry.anyType();
            if (map.getSize() == 0 && 2 == map.getDimensionCount() && any == map.getDimensionType(0) && any == map.getDimensionType(1)) {
                TypeDescriptor<?>[] params = TypeDescriptor.createArray(2);
                params[0] = type.getGenericParameterType(0);
                params[1] = type.getGenericParameterType(1);
                value = new Map(params);
            }
        }
        return value;
    }

    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Invisible
    public java.util.Map<Object, Object> toMap() {
        HashMap<Object, Object> result;
        if (this.map != null) {
            result = new HashMap<Object, Object>();
            result.putAll(this.map);
        } else {
            result = null;
        }
        return result;
    }

    @OperationMeta(useGenericParameter=1)
    public Sequence<V> sortByKeys(ExpressionEvaluator evaluator) throws VilException {
        List sortedKeys = AbstractCollectionWrapper.sortImpl(this.keys().iterator(), evaluator);
        ArrayList<V> result = new ArrayList<V>(sortedKeys.size());
        for (Object key : sortedKeys) {
            result.add(this.get(key));
        }
        return new ListSequence(result, this.generics[1]);
    }

    @Invisible
    public String toString() {
        return this.map.toString();
    }

    @Invisible
    public java.util.Map<K, V> toMappedMap() {
        HashMap result = new HashMap();
        for (Object k : this.keys()) {
            result.put(k, this.get(k));
        }
        return result;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @OperationMeta(name={"notEmpty", "isNotEmpty"})
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @OperationMeta(name={"clone"})
    public Map<K, V> cloneMap() {
        HashMap<Object, Object> clone = new HashMap<Object, Object>();
        clone.putAll(this.map);
        return new Map<K, V>(clone, this.generics);
    }
}

