/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IClassNameMapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.IClassNameMapperProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.IntHolder;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ReflectionResolver {
    private static TypeRegistry registry = TypeRegistry.DEFAULT;
    private static IClassNameMapper mapper = null;

    public static TypeRegistry setTypeRegistry(TypeRegistry reg) {
        TypeRegistry before = registry;
        if (reg != null) {
            registry = reg;
            mapper = registry instanceof IClassNameMapperProvider ? ((IClassNameMapperProvider)((Object)registry)).getClassNameMapper() : null;
        }
        return before;
    }

    public static TypeRegistry getTypeRegistry() {
        return registry;
    }

    public static TypeDescriptor<?> resolveType(Class<?> cls, Class<?>[] generics) {
        return ReflectionResolver.resolveType(cls, generics, new IntHolder());
    }

    public static TypeDescriptor<?> resolveType(Class<?> cls, Class<?>[] generics, IntHolder pos) {
        TypeDescriptor<IVilType> result = null;
        if (Void.TYPE == cls) {
            result = ReflectionTypeDescriptor.VOID;
        } else {
            try {
                if (ReflectionTypeDescriptor.isSet(cls)) {
                    result = TypeRegistry.getSetType(ReflectionResolver.createParameter(generics, 1, pos));
                } else if (ReflectionTypeDescriptor.isSequence(cls)) {
                    result = TypeRegistry.getSequenceType(ReflectionResolver.createParameter(generics, 1, pos));
                } else if (ReflectionTypeDescriptor.isMap(cls)) {
                    result = TypeRegistry.getMapType(ReflectionResolver.createParameter(generics, 2, pos));
                } else if (ReflectionTypeDescriptor.isIterator(cls)) {
                    result = TypeRegistry.getIteratorType(ReflectionResolver.createParameter(generics, 1, pos));
                }
            }
            catch (VilException vilException) {
                // empty catch block
            }
            if (result == null) {
                String clsName;
                if (mapper != null) {
                    result = registry.getMappedType(cls, generics, pos);
                }
                if (result == null && (result = registry.getType(clsName = mapper != null ? mapper.getVilName(cls) : cls.getName())) == null) {
                    result = registry.getType(cls.getSimpleName());
                }
            }
            if (result == null) {
                result = Object.class == cls ? ReflectionTypeDescriptor.ANY : ReflectionTypeDescriptor.VOID;
            }
        }
        return result;
    }

    private static TypeDescriptor<?>[] createParameter(Class<?>[] generics, int count, IntHolder pos) {
        TypeDescriptor<?>[] result;
        if (generics != null) {
            result = TypeDescriptor.createArray(count);
            int c = 0;
            while (c < count && result != null) {
                if (pos.getValue() < generics.length) {
                    result[c++] = ReflectionResolver.resolveType(generics[pos.getAndInc()], generics, pos);
                    continue;
                }
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    public static boolean hasAnnotationValue(String[] value) {
        return value != null && value.length > 0 && value[0].length() > 0;
    }
}

